/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.lang.reflect.Array;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaUtil;

public final class JavaKind
extends Enum<JavaKind> {
    public static final /* enum */ JavaKind Boolean = new JavaKind('Z', 4, "boolean", 1, true, java.lang.Boolean.TYPE, Boolean.class);
    public static final /* enum */ JavaKind Byte = new JavaKind('B', 8, "byte", 1, true, java.lang.Byte.TYPE, Byte.class);
    public static final /* enum */ JavaKind Short = new JavaKind('S', 9, "short", 1, true, java.lang.Short.TYPE, Short.class);
    public static final /* enum */ JavaKind Char = new JavaKind('C', 5, "char", 1, true, Character.TYPE, Character.class);
    public static final /* enum */ JavaKind Int = new JavaKind('I', 10, "int", 1, true, Integer.TYPE, Integer.class);
    public static final /* enum */ JavaKind Float = new JavaKind('F', 6, "float", 1, false, java.lang.Float.TYPE, Float.class);
    public static final /* enum */ JavaKind Long = new JavaKind('J', 11, "long", 2, false, java.lang.Long.TYPE, Long.class);
    public static final /* enum */ JavaKind Double = new JavaKind('D', 7, "double", 2, false, java.lang.Double.TYPE, Double.class);
    public static final /* enum */ JavaKind Object = new JavaKind('A', 12, "Object", 1, false, null, null);
    public static final /* enum */ JavaKind Void = new JavaKind('V', 14, "void", 0, false, java.lang.Void.TYPE, Void.class);
    public static final /* enum */ JavaKind Illegal = new JavaKind('-', 99, "illegal", 0, false, null, null);
    private final char typeChar;
    private final String javaName;
    private final boolean isStackInt;
    private final Class<?> primitiveJavaClass;
    private final Class<?> boxedJavaClass;
    private final int slotCount;
    private final int basicType;
    private static final int MAX_FORMAT_ARRAY_LENGTH = 5;
    private static final /* synthetic */ JavaKind[] $VALUES;

    public static JavaKind[] values() {
        return (JavaKind[])$VALUES.clone();
    }

    public static JavaKind valueOf(String name) {
        return Enum.valueOf(JavaKind.class, name);
    }

    private JavaKind(char typeChar, int basicType, String javaName, int slotCount, boolean isStackInt, Class<?> primitiveJavaClass, Class<?> boxedJavaClass) {
        this.typeChar = typeChar;
        this.javaName = javaName;
        this.slotCount = slotCount;
        this.isStackInt = isStackInt;
        this.primitiveJavaClass = primitiveJavaClass;
        this.boxedJavaClass = boxedJavaClass;
        this.basicType = basicType;
        assert (primitiveJavaClass == null || javaName.equals(primitiveJavaClass.getName()));
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public boolean needsTwoSlots() {
        return this.slotCount == 2;
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getBasicType() {
        return this.basicType;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public boolean isPrimitive() {
        return this.primitiveJavaClass != null;
    }

    public JavaKind getStackKind() {
        if (this.isStackInt) {
            return Int;
        }
        return this;
    }

    public boolean isNumericInteger() {
        return this.isStackInt || this == Long;
    }

    public boolean isUnsigned() {
        return this == Boolean || this == Char;
    }

    public boolean isNumericFloat() {
        return this == Float || this == Double;
    }

    public boolean isObject() {
        return this == Object;
    }

    public static JavaKind fromTypeString(String typeString) {
        assert (typeString.length() > 0);
        char first = typeString.charAt(0);
        if (first == '[' || first == 'L') {
            return Object;
        }
        return JavaKind.fromPrimitiveOrVoidTypeChar(first);
    }

    public static JavaKind fromWordSize(int wordSizeInBytes) {
        if (wordSizeInBytes == 8) {
            return Long;
        }
        assert (wordSizeInBytes == 4) : "Unsupported word size!";
        return Int;
    }

    public static JavaKind fromPrimitiveOrVoidTypeChar(char ch) {
        switch (ch) {
            case 'Z': {
                return Boolean;
            }
            case 'C': {
                return Char;
            }
            case 'F': {
                return Float;
            }
            case 'D': {
                return Double;
            }
            case 'B': {
                return Byte;
            }
            case 'S': {
                return Short;
            }
            case 'I': {
                return Int;
            }
            case 'J': {
                return Long;
            }
            case 'V': {
                return Void;
            }
        }
        throw new IllegalArgumentException("unknown primitive or void type character: " + ch);
    }

    public static JavaKind fromJavaClass(Class<?> klass) {
        if (klass == JavaKind.Boolean.primitiveJavaClass) {
            return Boolean;
        }
        if (klass == JavaKind.Byte.primitiveJavaClass) {
            return Byte;
        }
        if (klass == JavaKind.Short.primitiveJavaClass) {
            return Short;
        }
        if (klass == JavaKind.Char.primitiveJavaClass) {
            return Char;
        }
        if (klass == JavaKind.Int.primitiveJavaClass) {
            return Int;
        }
        if (klass == JavaKind.Long.primitiveJavaClass) {
            return Long;
        }
        if (klass == JavaKind.Float.primitiveJavaClass) {
            return Float;
        }
        if (klass == JavaKind.Double.primitiveJavaClass) {
            return Double;
        }
        if (klass == JavaKind.Void.primitiveJavaClass) {
            return Void;
        }
        return Object;
    }

    public Class<?> toJavaClass() {
        return this.primitiveJavaClass;
    }

    public Class<?> toBoxedJavaClass() {
        return this.boxedJavaClass;
    }

    public String toString() {
        return this.javaName;
    }

    private static boolean isToStringSafe(Class<?> c) {
        return c == Boolean.class || c == Byte.class || c == Character.class || c == Short.class || c == Integer.class || c == Float.class || c == Long.class || c == Double.class;
    }

    public String format(Object value) {
        if (this.isPrimitive()) {
            assert (JavaKind.isToStringSafe(value.getClass()));
            return value.toString();
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() > 50) {
                return "String:\"" + s.substring(0, 30) + "...\"";
            }
            return "String:\"" + s + '\"';
        }
        if (value instanceof JavaType) {
            return "JavaType:" + ((JavaType)value).toJavaName();
        }
        if (value instanceof Enum) {
            return MetaUtil.getSimpleName(value.getClass(), true) + ":" + ((Enum)value).name();
        }
        if (value instanceof FormatWithToString) {
            return MetaUtil.getSimpleName(value.getClass(), true) + ":" + String.valueOf(value);
        }
        if (value instanceof Class) {
            return "Class:" + ((Class)value).getName();
        }
        if (JavaKind.isToStringSafe(value.getClass())) {
            return value.toString();
        }
        if (value.getClass().isArray()) {
            return JavaKind.formatArray(value);
        }
        return MetaUtil.getSimpleName(value.getClass(), true) + "@" + System.identityHashCode(value);
    }

    private static String formatArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        assert (componentType != null);
        int arrayLength = Array.getLength(array);
        StringBuilder buf = new StringBuilder(MetaUtil.getSimpleName(componentType, true)).append('[').append(arrayLength).append("]{");
        int length = Math.min(5, arrayLength);
        boolean primitive = componentType.isPrimitive();
        for (int i = 0; i < length; ++i) {
            if (primitive) {
                buf.append(Array.get(array, i));
            } else {
                Object o = ((Object[])array)[i];
                buf.append(Object.format(o));
            }
            if (i == length - 1) continue;
            buf.append(", ");
        }
        if (arrayLength != length) {
            buf.append(", ...");
        }
        return buf.append('}').toString();
    }

    public long getMinValue() {
        switch (this) {
            case Boolean: {
                return 0L;
            }
            case Byte: {
                return -128L;
            }
            case Char: {
                return 0L;
            }
            case Short: {
                return -32768L;
            }
            case Int: {
                return Integer.MIN_VALUE;
            }
            case Long: {
                return java.lang.Long.MIN_VALUE;
            }
            case Float: {
                return java.lang.Float.floatToRawIntBits(java.lang.Float.MIN_VALUE);
            }
            case Double: {
                return java.lang.Double.doubleToRawLongBits(java.lang.Double.MIN_VALUE);
            }
        }
        throw new IllegalArgumentException("illegal call to minValue on " + (Object)((Object)this));
    }

    public long getMaxValue() {
        switch (this) {
            case Boolean: {
                return 1L;
            }
            case Byte: {
                return 127L;
            }
            case Char: {
                return 65535L;
            }
            case Short: {
                return 32767L;
            }
            case Int: {
                return Integer.MAX_VALUE;
            }
            case Long: {
                return java.lang.Long.MAX_VALUE;
            }
            case Float: {
                return java.lang.Float.floatToRawIntBits(java.lang.Float.MAX_VALUE);
            }
            case Double: {
                return java.lang.Double.doubleToRawLongBits(java.lang.Double.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("illegal call to maxValue on " + (Object)((Object)this));
    }

    public int getByteCount() {
        if (this == Boolean) {
            return 1;
        }
        return this.getBitCount() >> 3;
    }

    public int getBitCount() {
        switch (this) {
            case Boolean: {
                return 1;
            }
            case Byte: {
                return 8;
            }
            case Char: 
            case Short: {
                return 16;
            }
            case Float: {
                return 32;
            }
            case Int: {
                return 32;
            }
            case Double: {
                return 64;
            }
            case Long: {
                return 64;
            }
        }
        throw new IllegalArgumentException("illegal call to bits on " + (Object)((Object)this));
    }

    static {
        $VALUES = new JavaKind[]{Boolean, Byte, Short, Char, Int, Float, Long, Double, Object, Void, Illegal};
    }

    public static interface FormatWithToString {
    }
}

