/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.Objects;
import jdk.vm.ci.meta.JavaType;

public final class ExceptionHandler {
    private final int startBCI;
    private final int endBCI;
    private final int handlerBCI;
    private final int catchTypeCPI;
    private final JavaType catchType;

    public ExceptionHandler(int startBCI, int endBCI, int catchBCI, int catchTypeCPI, JavaType catchType) {
        this.startBCI = startBCI;
        this.endBCI = endBCI;
        this.handlerBCI = catchBCI;
        this.catchTypeCPI = catchTypeCPI;
        this.catchType = catchType;
    }

    public int getStartBCI() {
        return this.startBCI;
    }

    public int getEndBCI() {
        return this.endBCI;
    }

    public int getHandlerBCI() {
        return this.handlerBCI;
    }

    public int catchTypeCPI() {
        return this.catchTypeCPI;
    }

    public boolean isCatchAll() {
        return this.catchTypeCPI == 0;
    }

    public JavaType getCatchType() {
        return this.catchType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExceptionHandler)) {
            return false;
        }
        ExceptionHandler that = (ExceptionHandler)obj;
        if (this.startBCI != that.startBCI || this.endBCI != that.endBCI || this.handlerBCI != that.handlerBCI || this.catchTypeCPI != that.catchTypeCPI) {
            return false;
        }
        return Objects.equals(this.catchType, that.catchType);
    }

    public String toString() {
        return "ExceptionHandler<startBCI=" + this.startBCI + ", endBCI=" + this.endBCI + ", handlerBCI=" + this.handlerBCI + ", catchTypeCPI=" + this.catchTypeCPI + ", catchType=" + this.catchType + ">";
    }

    public int hashCode() {
        return this.catchTypeCPI ^ this.endBCI ^ this.handlerBCI;
    }
}

