/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code.site;

import java.util.Objects;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.InvokeTarget;

public final class Call
extends Infopoint {
    public final InvokeTarget target;
    public final int size;
    public final boolean direct;

    public Call(InvokeTarget target, int pcOffset, int size, boolean direct, DebugInfo debugInfo) {
        super(pcOffset, debugInfo, InfopointReason.CALL);
        this.size = size;
        this.target = target;
        this.direct = direct;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Call && super.equals(obj)) {
            Call that = (Call)obj;
            if (this.size == that.size && this.direct == that.direct && Objects.equals(this.target, that.target)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pcOffset);
        sb.append('[');
        sb.append(this.target);
        sb.append(']');
        if (this.debugInfo != null) {
            Call.appendDebugInfo(sb, this.debugInfo);
        }
        return sb.toString();
    }
}

