/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;

public class RegisterAttributes {
    private final boolean callerSave;
    private final boolean calleeSave;
    private final boolean allocatable;
    public static final RegisterAttributes NONE = new RegisterAttributes(false, false, false);

    public RegisterAttributes(boolean isCallerSave, boolean isCalleeSave, boolean isAllocatable) {
        this.callerSave = isCallerSave;
        this.calleeSave = isCalleeSave;
        this.allocatable = isAllocatable;
    }

    public static RegisterAttributes[] createMap(RegisterConfig registerConfig, RegisterArray registers) {
        RegisterAttributes[] map = new RegisterAttributes[registers.size()];
        List<Register> callerSaveRegisters = registerConfig.getCallerSaveRegisters().asList();
        List calleeSaveRegisters = registerConfig.getCalleeSaveRegisters() == null ? Collections.emptyList() : registerConfig.getCalleeSaveRegisters().asList();
        List<Register> allocatableRegisters = registerConfig.getAllocatableRegisters().asList();
        for (Register reg : registers) {
            if (reg == null) continue;
            RegisterAttributes attr = new RegisterAttributes(callerSaveRegisters.contains(reg), calleeSaveRegisters.contains(reg), allocatableRegisters.contains(reg));
            if (map.length <= reg.number) {
                map = Arrays.copyOf(map, reg.number + 1);
            }
            map[reg.number] = attr;
        }
        for (int i = 0; i < map.length; ++i) {
            if (map[i] != null) continue;
            map[i] = NONE;
        }
        return map;
    }

    public boolean isAllocatable() {
        return this.allocatable;
    }

    public boolean isCalleeSave() {
        return this.calleeSave;
    }

    public boolean isCallerSave() {
        return this.callerSave;
    }
}

