/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.ValueKind;

public final class Register
implements Comparable<Register> {
    public static final RegisterCategory SPECIAL = new RegisterCategory("SPECIAL");
    public static final Register None = new Register(-1, -1, "noreg", SPECIAL);
    public final int number;
    public final String name;
    public final int encoding;
    private final RegisterCategory registerCategory;

    public int encoding() {
        return this.encoding;
    }

    public Register(int number, int encoding, String name, RegisterCategory registerCategory) {
        this.number = number;
        this.name = name;
        this.registerCategory = registerCategory;
        this.encoding = encoding;
    }

    public RegisterCategory getRegisterCategory() {
        return this.registerCategory;
    }

    public boolean mayContainReference() {
        return this.registerCategory.mayContainReference;
    }

    public RegisterValue asValue(ValueKind<?> kind) {
        return new RegisterValue(kind, this);
    }

    public RegisterValue asValue() {
        return this.asValue(ValueKind.Illegal);
    }

    public boolean isValid() {
        return this.number >= 0;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Register o) {
        if (this.number < o.number) {
            return -1;
        }
        if (this.number > o.number) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return 17 + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Register) {
            Register other = (Register)obj;
            if (this.number == other.number) {
                assert (this.name.equals(other.name));
                assert (this.encoding == other.encoding);
                assert (this.registerCategory.equals(other.registerCategory));
                return true;
            }
        }
        return false;
    }

    public static class RegisterCategory {
        private final String name;
        private final boolean mayContainReference;

        public RegisterCategory(String name) {
            this(name, true);
        }

        public RegisterCategory(String name, boolean mayContainReference) {
            this.name = name;
            this.mayContainReference = mayContainReference;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return 23 + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegisterCategory) {
                RegisterCategory that = (RegisterCategory)obj;
                return this.name.equals(that.name);
            }
            return false;
        }
    }
}

