/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import jdk.vm.ci.code.Register;

public final class Location {
    public final Register reg;
    public final int offset;

    private Location(Register reg, int offset) {
        this.reg = reg;
        this.offset = offset;
    }

    public static Location register(Register reg) {
        return new Location(reg, 0);
    }

    public static Location subregister(Register reg, int offset) {
        return new Location(reg, offset);
    }

    public static Location stack(int offset) {
        return new Location(null, offset);
    }

    public boolean isRegister() {
        return this.reg != null;
    }

    public boolean isStack() {
        return this.reg == null;
    }

    public String toString() {
        String regName = this.isRegister() ? this.reg.name + ":" : "stack:";
        return regName + this.offset;
    }
}

