/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;

public class CodeUtil {
    public static final String NEW_LINE = String.format("%n", new Object[0]);
    public static final int K = 1024;
    public static final int M = 0x100000;

    public static boolean isOdd(int n) {
        return (n & 1) == 1;
    }

    public static boolean isEven(int n) {
        return (n & 1) == 0;
    }

    public static boolean isPowerOf2(int val) {
        return val > 0 && (val & val - 1) == 0;
    }

    public static boolean isPowerOf2(long val) {
        return val > 0L && (val & val - 1L) == 0L;
    }

    public static int log2(int val) {
        assert (val > 0);
        return 31 - Integer.numberOfLeadingZeros(val);
    }

    public static int log2(long val) {
        assert (val > 0L);
        return 63 - Long.numberOfLeadingZeros(val);
    }

    public static long narrow(long value, int resultBits) {
        long ret = value & CodeUtil.mask(resultBits);
        return CodeUtil.signExtend(ret, resultBits);
    }

    public static long signExtend(long value, int inputBits) {
        if (inputBits < 64) {
            if ((value >>> inputBits - 1 & 1L) == 1L) {
                return value | -1L << inputBits;
            }
            return value & (-1L << inputBits ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return value;
    }

    public static long zeroExtend(long value, int inputBits) {
        if (inputBits < 64) {
            return value & (-1L << inputBits ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return value;
    }

    public static long convert(long value, int inputBits, boolean unsigned) {
        if (unsigned) {
            return CodeUtil.zeroExtend(value, inputBits);
        }
        return CodeUtil.signExtend(value, inputBits);
    }

    public static long mask(int bits) {
        assert (0 <= bits && bits <= 64);
        if (bits == 64) {
            return -1L;
        }
        return (1L << bits) - 1L;
    }

    public static long minValue(int bits) {
        assert (0 < bits && bits <= 64);
        return -1L << bits - 1;
    }

    public static long maxValue(int bits) {
        assert (0 < bits && bits <= 64);
        return CodeUtil.mask(bits - 1);
    }

    public static String tabulateValues(BytecodeFrame frame) {
        int cols = Math.max(frame.numLocals, Math.max(frame.numStack, frame.numLocks));
        if (frame.values == null || frame.values.length == 0) {
            assert (cols == 0);
            return null;
        }
        if (cols == 0) {
            return null;
        }
        ArrayList<Object> cells = new ArrayList<Object>();
        cells.add("");
        for (int i = 0; i < cols; ++i) {
            cells.add(i);
        }
        ++cols;
        if (frame.numLocals != 0) {
            cells.add("locals:");
            cells.addAll(Arrays.asList(frame.values).subList(0, frame.numLocals));
            cells.addAll(Collections.nCopies(cols - frame.numLocals - 1, ""));
        }
        if (frame.numStack != 0) {
            cells.add("stack:");
            cells.addAll(Arrays.asList(frame.values).subList(frame.numLocals, frame.numLocals + frame.numStack));
            cells.addAll(Collections.nCopies(cols - frame.numStack - 1, ""));
        }
        if (frame.numLocks != 0) {
            cells.add("locks:");
            cells.addAll(Arrays.asList(frame.values).subList(frame.numLocals + frame.numStack, frame.values.length));
            cells.addAll(Collections.nCopies(cols - frame.numLocks - 1, ""));
        }
        Object[] cellArray = cells.toArray();
        for (int i = 0; i < cellArray.length; ++i) {
            if (i % cols == 0) continue;
            cellArray[i] = "|" + cellArray[i];
        }
        return CodeUtil.tabulate(cellArray, cols, 1, 1);
    }

    public static String tabulate(Object[] cells, int cols, int lpad, int rpad) {
        int rows = (cells.length + (cols - 1)) / cols;
        int[] colWidths = new int[cols];
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                int index = col + row * cols;
                if (index >= cells.length) continue;
                Object cell = cells[index];
                colWidths[col] = Math.max(colWidths[col], String.valueOf(cell).length());
            }
        }
        StringBuilder sb = new StringBuilder();
        String nl = NEW_LINE;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int index = col + row * cols;
                if (index >= cells.length) continue;
                for (int i = 0; i < lpad; ++i) {
                    sb.append(' ');
                }
                Object cell = cells[index];
                String s = String.valueOf(cell);
                sb.append(s);
                for (int w = s.length(); w < colWidths[col]; ++w) {
                    sb.append(' ');
                }
                for (int i = 0; i < rpad; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(nl);
        }
        return sb.toString();
    }

    public static StringBuilder append(StringBuilder sb, BytecodePosition pos) {
        MetaUtil.appendLocation(sb.append("at "), pos.getMethod(), pos.getBCI());
        if (pos.getCaller() != null) {
            sb.append(NEW_LINE);
            CodeUtil.append(sb, pos.getCaller());
        }
        return sb;
    }

    public static StringBuilder append(StringBuilder sb, BytecodeFrame frame) {
        MetaUtil.appendLocation(sb.append("at "), frame.getMethod(), frame.getBCI());
        assert (sb.charAt(sb.length() - 1) == ']');
        sb.deleteCharAt(sb.length() - 1);
        sb.append(", duringCall: ").append(frame.duringCall).append(", rethrow: ").append(frame.rethrowException).append(']');
        String table = CodeUtil.tabulateValues(frame);
        if (table != null) {
            sb.append(NEW_LINE);
            String[] rows = table.split(NEW_LINE);
            for (int i = 0; i < rows.length; ++i) {
                String row = rows[i];
                if (row.trim().isEmpty()) continue;
                sb.append("  ").append(row);
                if (i == rows.length - 1) continue;
                sb.append(NEW_LINE);
            }
        }
        if (frame.caller() != null) {
            sb.append(NEW_LINE);
            CodeUtil.append(sb, frame.caller());
        } else if (frame.getCaller() != null) {
            sb.append(NEW_LINE);
            CodeUtil.append(sb, frame.getCaller());
        }
        return sb;
    }

    public static StringBuilder append(StringBuilder sb, DebugInfo info, RefMapFormatter formatterArg) {
        BytecodeFrame frame;
        RegisterSaveLayout calleeSaveInfo;
        RefMapFormatter formatter = formatterArg;
        if (formatter == null) {
            formatter = new NumberedRefMapFormatter();
        }
        String nl = NEW_LINE;
        ReferenceMap refMap = info.getReferenceMap();
        if (refMap != null) {
            sb.append(refMap.toString());
        }
        if ((calleeSaveInfo = info.getCalleeSaveInfo()) != null) {
            sb.append("callee-save-info:").append(nl);
            Map<Integer, Register> map = calleeSaveInfo.slotsToRegisters(true);
            for (Map.Entry<Integer, Register> e : map.entrySet()) {
                sb.append("    ").append(e.getValue()).append(" -> ").append(formatter.formatStackSlot(e.getKey())).append(nl);
            }
        }
        if ((frame = info.frame()) != null) {
            CodeUtil.append(sb, frame);
        } else if (info.getBytecodePosition() != null) {
            CodeUtil.append(sb, info.getBytecodePosition());
        }
        return sb;
    }

    public static CallingConvention getCallingConvention(CodeCacheProvider codeCache, CallingConvention.Type type, ResolvedJavaMethod method, ValueKindFactory<?> valueKindFactory) {
        JavaType[] argTypes;
        Signature sig = method.getSignature();
        JavaType retType = sig.getReturnType(null);
        int sigCount = sig.getParameterCount(false);
        int argIndex = 0;
        if (!method.isStatic()) {
            argTypes = new JavaType[sigCount + 1];
            argTypes[argIndex++] = method.getDeclaringClass();
        } else {
            argTypes = new JavaType[sigCount];
        }
        for (int i = 0; i < sigCount; ++i) {
            argTypes[argIndex++] = sig.getParameterType(i, null);
        }
        RegisterConfig registerConfig = codeCache.getRegisterConfig();
        return registerConfig.getCallingConvention(type, retType, argTypes, valueKindFactory);
    }

    public static class NumberedRefMapFormatter
    implements RefMapFormatter {
        @Override
        public String formatStackSlot(int frameRefMapIndex) {
            return "s" + frameRefMapIndex;
        }

        public String formatRegister(int regRefMapIndex) {
            return "r" + regRefMapIndex;
        }
    }

    public static class DefaultRefMapFormatter
    implements RefMapFormatter {
        public final int slotSize;
        public final Register fp;
        public final int refMapToFPOffset;

        public DefaultRefMapFormatter(int slotSize, Register fp, int refMapToFPOffset) {
            this.slotSize = slotSize;
            this.fp = fp;
            this.refMapToFPOffset = refMapToFPOffset;
        }

        @Override
        public String formatStackSlot(int frameRefMapIndex) {
            int refMapOffset = frameRefMapIndex * this.slotSize;
            int fpOffset = refMapOffset + this.refMapToFPOffset;
            if (fpOffset >= 0) {
                return this.fp + "+" + fpOffset;
            }
            return this.fp.name + fpOffset;
        }
    }

    public static interface RefMapFormatter {
        public String formatStackSlot(int var1);
    }
}

