/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.util.Arrays;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.SuppressFBWarnings;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class BytecodeFrame
extends BytecodePosition {
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="field is intentionally mutable")
    public final JavaValue[] values;
    private final JavaKind[] slotKinds;
    public final int numLocals;
    public final int numStack;
    public final int numLocks;
    public final boolean rethrowException;
    public final boolean duringCall;
    public static final int UNKNOWN_BCI = -5;
    public static final int UNWIND_BCI = -1;
    public static final int BEFORE_BCI = -2;
    public static final int AFTER_BCI = -3;
    public static final int AFTER_EXCEPTION_BCI = -4;
    public static final int INVALID_FRAMESTATE_BCI = -6;

    public static boolean isPlaceholderBci(int bci) {
        return bci < 0;
    }

    public static String getPlaceholderBciName(int bci) {
        assert (BytecodeFrame.isPlaceholderBci(bci));
        if (bci == -3) {
            return "AFTER_BCI";
        }
        if (bci == -4) {
            return "AFTER_EXCEPTION_BCI";
        }
        if (bci == -6) {
            return "INVALID_FRAMESTATE_BCI";
        }
        if (bci == -2) {
            return "BEFORE_BCI";
        }
        if (bci == -5) {
            return "UNKNOWN_BCI";
        }
        assert (bci == -1);
        return "UNWIND_BCI";
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `slotKinds`")
    public BytecodeFrame(BytecodeFrame caller, ResolvedJavaMethod method, int bci, boolean rethrowException, boolean duringCall, JavaValue[] values, JavaKind[] slotKinds, int numLocals, int numStack, int numLocks) {
        super(caller, method, bci);
        assert (values != null);
        this.rethrowException = rethrowException;
        this.duringCall = duringCall;
        this.values = values;
        this.slotKinds = slotKinds;
        this.numLocals = numLocals;
        this.numStack = numStack;
        this.numLocks = numLocks;
        assert (!rethrowException || numStack == 1) : "must have exception on top of the stack";
    }

    public boolean validateFormat() {
        if (this.caller() != null) {
            this.caller().validateFormat();
        }
        for (int i = 0; i < this.numLocals + this.numStack; ++i) {
            JavaKind kind;
            if (this.values[i] == null || !(kind = this.slotKinds[i]).needsTwoSlots()) continue;
            assert (this.slotKinds.length > i + 1) : String.format("missing second word %s", this);
            assert (this.slotKinds[i + 1] == JavaKind.Illegal) : this;
        }
        return true;
    }

    public JavaKind getLocalValueKind(int i) {
        if (i < 0 || i >= this.numLocals) {
            throw new IndexOutOfBoundsException();
        }
        return this.slotKinds[i];
    }

    public JavaKind getStackValueKind(int i) {
        if (i < 0 || i >= this.numStack) {
            throw new IndexOutOfBoundsException();
        }
        return this.slotKinds[i + this.numLocals];
    }

    public JavaValue getLocalValue(int i) {
        if (i < 0 || i >= this.numLocals) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i];
    }

    public JavaValue getStackValue(int i) {
        if (i < 0 || i >= this.numStack) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i + this.numLocals];
    }

    public JavaValue getLockValue(int i) {
        if (i < 0 || i >= this.numLocks) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i + this.numLocals + this.numStack];
    }

    public BytecodeFrame caller() {
        return (BytecodeFrame)this.getCaller();
    }

    @Override
    public int hashCode() {
        return this.numLocals + 1 ^ this.numStack + 11 ^ this.numLocks + 7;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BytecodeFrame && super.equals(obj)) {
            BytecodeFrame that = (BytecodeFrame)obj;
            if (this.duringCall == that.duringCall && this.rethrowException == that.rethrowException && this.numLocals == that.numLocals && this.numLocks == that.numLocks && this.numStack == that.numStack && Arrays.equals(this.values, that.values)) {
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return CodeUtil.append(new StringBuilder(100), this).toString();
    }
}

