/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.sparc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;

public class SPARCHotSpotRegisterConfig
implements RegisterConfig {
    private final TargetDescription target;
    private final RegisterArray allocatable;
    private final RegisterAttributes[] attributesMap;
    private final RegisterArray cpuCallerParameterRegisters = new RegisterArray(new Register[]{SPARC.o0, SPARC.o1, SPARC.o2, SPARC.o3, SPARC.o4, SPARC.o5});
    private final RegisterArray cpuCalleeParameterRegisters = new RegisterArray(new Register[]{SPARC.i0, SPARC.i1, SPARC.i2, SPARC.i3, SPARC.i4, SPARC.i5});
    private final RegisterArray fpuFloatJavaParameterRegisters = new RegisterArray(new Register[]{SPARC.f0, SPARC.f1, SPARC.f2, SPARC.f3, SPARC.f4, SPARC.f5, SPARC.f6, SPARC.f7});
    private final RegisterArray fpuDoubleJavaParameterRegisters = new RegisterArray(new Register[]{SPARC.d0, null, SPARC.d2, null, SPARC.d4, null, SPARC.d6, null});
    private final RegisterArray fpuFloatNativeParameterRegisters = new RegisterArray(new Register[]{SPARC.f1, SPARC.f3, SPARC.f5, SPARC.f7, SPARC.f9, SPARC.f11, SPARC.f13, SPARC.f15, SPARC.f17, SPARC.f19, SPARC.f21, SPARC.f23, SPARC.f25, SPARC.f27, SPARC.f29, SPARC.f31});
    private final RegisterArray fpuDoubleNativeParameterRegisters = new RegisterArray(new Register[]{SPARC.d0, SPARC.d2, SPARC.d4, SPARC.d6, SPARC.d8, SPARC.d10, SPARC.d12, SPARC.d14, SPARC.d16, SPARC.d18, SPARC.d20, SPARC.d22, SPARC.d24, SPARC.d26, SPARC.d28, SPARC.d30});
    private final RegisterArray callerSaveRegisters;
    private final RegisterArray windowSaveRegisters = new RegisterArray(new Register[]{SPARC.l0, SPARC.l1, SPARC.l2, SPARC.l3, SPARC.l4, SPARC.l5, SPARC.l6, SPARC.l7, SPARC.i0, SPARC.i1, SPARC.i2, SPARC.i3, SPARC.i4, SPARC.i5, SPARC.i6, SPARC.i7});
    private static final RegisterArray reservedRegisters = new RegisterArray(new Register[]{SPARC.sp, SPARC.g0, SPARC.g2});

    public RegisterArray getAllocatableRegisters() {
        return this.allocatable;
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return new RegisterArray(list);
    }

    public RegisterAttributes[] getAttributesMap() {
        return (RegisterAttributes[])this.attributesMap.clone();
    }

    private static RegisterArray initAllocatable(Architecture arch, boolean reserveForHeapBase) {
        RegisterArray allRegisters = arch.getAvailableValueRegisters();
        Register[] registers = new Register[allRegisters.size() - reservedRegisters.size() - (reserveForHeapBase ? 1 : 0)];
        List reservedRegistersList = reservedRegisters.asList();
        int idx = 0;
        for (Register reg : allRegisters) {
            if (reservedRegistersList.contains(reg) || reserveForHeapBase && reg.equals((Object)SPARC.g6)) continue;
            registers[idx++] = reg;
        }
        assert (idx == registers.length);
        return new RegisterArray(registers);
    }

    public SPARCHotSpotRegisterConfig(TargetDescription target, boolean useCompressedOops) {
        this(target, SPARCHotSpotRegisterConfig.initAllocatable(target.arch, useCompressedOops));
    }

    public SPARCHotSpotRegisterConfig(TargetDescription target, RegisterArray allocatable) {
        this.target = target;
        this.allocatable = allocatable;
        HashSet callerSaveSet = new HashSet(target.arch.getAvailableValueRegisters().asList());
        for (Register cs : this.windowSaveRegisters) {
            callerSaveSet.remove(cs);
        }
        this.callerSaveRegisters = new RegisterArray(callerSaveSet);
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)SPARC.allRegisters);
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.callerSaveRegisters;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return null;
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return false;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type type, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        if (type == HotSpotCallingConventionType.JavaCall || type == HotSpotCallingConventionType.NativeCall) {
            return this.callingConvention(this.cpuCallerParameterRegisters, returnType, parameterTypes, hotspotType, valueKindFactory);
        }
        if (type == HotSpotCallingConventionType.JavaCallee) {
            return this.callingConvention(this.cpuCalleeParameterRegisters, returnType, parameterTypes, hotspotType, valueKindFactory);
        }
        throw JVMCIError.shouldNotReachHere();
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type type, JavaKind kind) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return hotspotType == HotSpotCallingConventionType.JavaCallee ? this.cpuCalleeParameterRegisters : this.cpuCallerParameterRegisters;
            }
            case Double: 
            case Float: {
                return this.fpuFloatJavaParameterRegisters;
            }
        }
        throw JVMCIError.shouldNotReachHere((String)("Unknown JavaKind " + kind));
    }

    private CallingConvention callingConvention(RegisterArray generalParameterRegisters, JavaType returnType, JavaType[] parameterTypes, HotSpotCallingConventionType type, ValueKindFactory<?> valueKindFactory) {
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentFloating = 0;
        int currentStackOffset = 0;
        boolean isNative = type == HotSpotCallingConventionType.NativeCall;
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind = parameterTypes[i].getJavaKind().getStackKind();
            if (isNative) {
                RegisterArray registerSet;
                switch (kind) {
                    case Boolean: 
                    case Byte: 
                    case Short: 
                    case Char: 
                    case Int: 
                    case Long: 
                    case Object: {
                        registerSet = generalParameterRegisters;
                        break;
                    }
                    case Double: {
                        registerSet = this.fpuDoubleNativeParameterRegisters;
                        break;
                    }
                    case Float: {
                        registerSet = this.fpuFloatNativeParameterRegisters;
                        break;
                    }
                    default: {
                        throw JVMCIError.shouldNotReachHere();
                    }
                }
                if (i < registerSet.size()) {
                    locations[i] = registerSet.get(i).asValue(valueKindFactory.getValueKind(kind));
                    currentStackOffset += this.target.arch.getWordSize();
                }
            } else {
                switch (kind) {
                    case Boolean: 
                    case Byte: 
                    case Short: 
                    case Char: 
                    case Int: 
                    case Long: 
                    case Object: {
                        if (currentGeneral >= generalParameterRegisters.size()) break;
                        Register register = generalParameterRegisters.get(currentGeneral++);
                        locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                        break;
                    }
                    case Double: {
                        if (currentFloating >= this.fpuFloatJavaParameterRegisters.size()) break;
                        if (currentFloating % 2 != 0) {
                            ++currentFloating;
                        }
                        Register register = this.fpuDoubleJavaParameterRegisters.get(currentFloating);
                        currentFloating += 2;
                        locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                        break;
                    }
                    case Float: {
                        if (currentFloating >= this.fpuFloatJavaParameterRegisters.size()) break;
                        Register register = this.fpuFloatJavaParameterRegisters.get(currentFloating++);
                        locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                        break;
                    }
                    default: {
                        throw JVMCIError.shouldNotReachHere();
                    }
                }
            }
            if (locations[i] != null) continue;
            ValueKind valueKind = valueKindFactory.getValueKind(kind);
            int typeSize = valueKind.getPlatformKind().getSizeInBytes();
            if (isNative) {
                currentStackOffset += this.target.arch.getWordSize() - typeSize;
            }
            currentStackOffset = SPARCHotSpotRegisterConfig.roundUp(currentStackOffset, typeSize);
            int slotOffset = currentStackOffset + 128;
            locations[i] = StackSlot.get((ValueKind)valueKind, (int)slotOffset, (!type.out ? 1 : 0) != 0);
            currentStackOffset += typeSize;
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : returnType.getJavaKind();
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : SPARCHotSpotRegisterConfig.getReturnRegister(returnKind, type).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new CallingConvention(currentStackOffset, returnLocation, locations);
    }

    private static int roundUp(int number, int mod) {
        return (number + mod - 1) / mod * mod;
    }

    public Register getReturnRegister(JavaKind kind) {
        return SPARCHotSpotRegisterConfig.getReturnRegister(kind, HotSpotCallingConventionType.JavaCallee);
    }

    private static Register getReturnRegister(JavaKind kind, HotSpotCallingConventionType type) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return type == HotSpotCallingConventionType.JavaCallee ? SPARC.i0 : SPARC.o0;
            }
            case Float: {
                return SPARC.f0;
            }
            case Double: {
                return SPARC.d0;
            }
            case Void: 
            case Illegal: {
                return null;
            }
        }
        throw new UnsupportedOperationException("no return register for type " + kind);
    }

    public Register getFrameRegister() {
        return SPARC.sp;
    }

    public String toString() {
        return String.format("Allocatable: " + this.getAllocatableRegisters() + "%nCallerSave:  " + this.getCallerSaveRegisters() + "%n", new Object[0]);
    }
}

