/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.aarch64;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotStackIntrospection;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotVMConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.runtime.JVMCIBackend;

public class AArch64HotSpotJVMCIBackendFactory
implements HotSpotJVMCIBackendFactory {
    private static EnumSet<AArch64.CPUFeature> computeFeatures(AArch64HotSpotVMConfig config) {
        EnumSet<AArch64.CPUFeature> features = EnumSet.noneOf(AArch64.CPUFeature.class);
        return features;
    }

    private static EnumSet<AArch64.Flag> computeFlags(AArch64HotSpotVMConfig config) {
        EnumSet<AArch64.Flag> flags = EnumSet.noneOf(AArch64.Flag.class);
        return flags;
    }

    private static TargetDescription createTarget(AArch64HotSpotVMConfig config) {
        int stackFrameAlignment = 16;
        int implicitNullCheckLimit = 4096;
        boolean inlineObjects = true;
        AArch64 arch = new AArch64(AArch64HotSpotJVMCIBackendFactory.computeFeatures(config), AArch64HotSpotJVMCIBackendFactory.computeFlags(config));
        return new TargetDescription((Architecture)arch, true, 16, 4096, true);
    }

    protected HotSpotConstantReflectionProvider createConstantReflection(HotSpotJVMCIRuntime runtime) {
        return new HotSpotConstantReflectionProvider(runtime);
    }

    private static RegisterConfig createRegisterConfig(TargetDescription target) {
        return new AArch64HotSpotRegisterConfig(target);
    }

    protected HotSpotCodeCacheProvider createCodeCache(HotSpotJVMCIRuntime runtime, TargetDescription target, RegisterConfig regConfig) {
        return new HotSpotCodeCacheProvider(runtime, target, regConfig);
    }

    protected HotSpotMetaAccessProvider createMetaAccess(HotSpotJVMCIRuntime runtime) {
        return new HotSpotMetaAccessProvider(runtime);
    }

    @Override
    public String getArchitecture() {
        return "aarch64";
    }

    public String toString() {
        return "JVMCIBackend:" + this.getArchitecture();
    }

    @Override
    public JVMCIBackend createJVMCIBackend(HotSpotJVMCIRuntime runtime, JVMCIBackend host) {
        HotSpotStackIntrospection stackIntrospection;
        HotSpotConstantReflectionProvider constantReflection;
        HotSpotCodeCacheProvider codeCache;
        HotSpotMetaAccessProvider metaAccess;
        assert (host == null);
        AArch64HotSpotVMConfig config = new AArch64HotSpotVMConfig(runtime.getConfigStore());
        TargetDescription target = AArch64HotSpotJVMCIBackendFactory.createTarget(config);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            RegisterConfig regConfig;
            try (InitTimer rt = InitTimer.timer((String)"create MetaAccess provider");){
                metaAccess = this.createMetaAccess(runtime);
            }
            rt = InitTimer.timer((String)"create RegisterConfig");
            var13_11 = null;
            try {
                regConfig = AArch64HotSpotJVMCIBackendFactory.createRegisterConfig(target);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create CodeCache provider");
            var13_11 = null;
            try {
                codeCache = this.createCodeCache(runtime, target, regConfig);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create ConstantReflection provider");
            var13_11 = null;
            try {
                constantReflection = this.createConstantReflection(runtime);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create StackIntrospection provider");
            var13_11 = null;
            try {
                stackIntrospection = new HotSpotStackIntrospection(runtime);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var13_11 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
        }
        var11_6 = null;
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            JVMCIBackend jVMCIBackend = this.createBackend(metaAccess, codeCache, constantReflection, stackIntrospection);
            return jVMCIBackend;
        }
        catch (Throwable throwable) {
            var11_6 = throwable;
            throw throwable;
        }
    }

    protected JVMCIBackend createBackend(HotSpotMetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, StackIntrospection stackIntrospection) {
        return new JVMCIBackend((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, constantReflection, stackIntrospection);
    }
}

