/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import java.util.Objects;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class HotSpotResolvedPrimitiveType
extends HotSpotResolvedJavaType {
    @NativeImageReinitialize
    static HotSpotResolvedPrimitiveType[] primitives;
    private JavaKind kind;
    HotSpotObjectConstantImpl mirror;

    private HotSpotResolvedPrimitiveType(JavaKind kind, HotSpotObjectConstantImpl mirror) {
        super(String.valueOf(kind.getTypeChar()));
        this.mirror = mirror;
        this.kind = kind;
    }

    static HotSpotResolvedPrimitiveType forKind(JavaKind kind) {
        HotSpotResolvedPrimitiveType primitive = primitives[kind.getBasicType()];
        assert (primitive != null) : kind;
        return primitive;
    }

    @VMEntryPoint
    static HotSpotResolvedPrimitiveType fromMetaspace(HotSpotObjectConstantImpl mirror, char typeChar) {
        HotSpotResolvedPrimitiveType result;
        JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)typeChar);
        if (primitives == null) {
            primitives = new HotSpotResolvedPrimitiveType[JavaKind.Void.getBasicType() + 1];
        }
        HotSpotResolvedPrimitiveType.primitives[kind.getBasicType()] = result = new HotSpotResolvedPrimitiveType(kind, mirror);
        return result;
    }

    public int getModifiers() {
        return 1041;
    }

    @Override
    public HotSpotResolvedObjectType getArrayClass() {
        if (this.kind == JavaKind.Void) {
            return null;
        }
        return super.getArrayClass();
    }

    public ResolvedJavaType getElementalType() {
        return this;
    }

    public ResolvedJavaType getComponentType() {
        return null;
    }

    public ResolvedJavaType getSuperclass() {
        return null;
    }

    public ResolvedJavaType[] getInterfaces() {
        return new ResolvedJavaType[0];
    }

    public ResolvedJavaType getSingleImplementor() {
        throw new JVMCIError("Cannot call getSingleImplementor() on a non-interface type: %s", new Object[]{this});
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return null;
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public boolean hasFinalizer() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isBeingInitialized() {
        return false;
    }

    public boolean isLinked() {
        return true;
    }

    public boolean isInstance(JavaConstant obj) {
        return false;
    }

    public boolean isInstanceClass() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        assert (other != null);
        return other.equals(this);
    }

    public ResolvedJavaType getHostClass() {
        return null;
    }

    public JavaKind getJavaKind() {
        return this.kind;
    }

    public boolean isJavaLangObject() {
        return false;
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return null;
    }

    public String toString() {
        return "HotSpotResolvedPrimitiveType<" + this.kind + ">";
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        return new Assumptions.AssumptionResult((Object)this);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return new ResolvedJavaField[0];
    }

    public ResolvedJavaField[] getStaticFields() {
        return new ResolvedJavaField[0];
    }

    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        Objects.requireNonNull(accessingClass);
        return this;
    }

    public void initialize() {
    }

    public void link() {
    }

    public boolean hasDefaultMethods() {
        return false;
    }

    public boolean declaresDefaultMethods() {
        return false;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedType) {
        return null;
    }

    public String getSourceFileName() {
        throw JVMCIError.unimplemented();
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public ResolvedJavaType getEnclosingType() {
        return null;
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return new ResolvedJavaMethod[0];
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return new ResolvedJavaMethod[0];
    }

    public ResolvedJavaMethod getClassInitializer() {
        return null;
    }

    public boolean isCloneableWithAllocation() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HotSpotResolvedPrimitiveType)) {
            return false;
        }
        HotSpotResolvedPrimitiveType that = (HotSpotResolvedPrimitiveType)obj;
        return that.kind == this.kind;
    }

    @Override
    JavaConstant getJavaMirror() {
        return HotSpotJVMCIRuntime.runtime().reflection.getJavaMirror(this);
    }
}

