/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Objects;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotConstantPool;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstantImpl;
import jdk.vm.ci.hotspot.HotSpotModifiers;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotObjectConstantScope;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.MetaspaceObject;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaType;

final class HotSpotResolvedObjectTypeImpl
extends HotSpotResolvedJavaType
implements HotSpotResolvedObjectType,
MetaspaceObject {
    private static final HotSpotResolvedJavaField[] NO_FIELDS = new HotSpotResolvedJavaField[0];
    private static final int METHOD_CACHE_ARRAY_CAPACITY = 8;
    private final long metadataPointer;
    private HotSpotResolvedJavaMethodImpl[] methodCacheArray;
    private HashMap<Long, HotSpotResolvedJavaMethodImpl> methodCacheHashMap;
    private volatile HotSpotResolvedJavaField[] instanceFields;
    private volatile HotSpotResolvedObjectTypeImpl[] interfaces;
    private HotSpotConstantPool constantPool;
    private final JavaConstant mirror;
    private HotSpotResolvedObjectTypeImpl superClass;
    private HotSpotResolvedJavaType componentType;
    HashMap<HotSpotResolvedJavaFieldImpl, Field> reflectionFieldCache;

    static HotSpotResolvedObjectTypeImpl getJavaLangObject() {
        return HotSpotJVMCIRuntime.runtime().getJavaLangObject();
    }

    @VMEntryPoint
    private static HotSpotResolvedObjectTypeImpl fromMetaspace(long klassPointer, String signature) {
        return HotSpotJVMCIRuntime.runtime().fromMetaspace(klassPointer, signature);
    }

    HotSpotResolvedObjectTypeImpl(long metadataPointer, String name) {
        super(name);
        assert (metadataPointer != 0L);
        this.metadataPointer = metadataPointer;
        try (HotSpotObjectConstantScope global = HotSpotObjectConstantScope.enterGlobalScope();){
            this.mirror = HotSpotJVMCIRuntime.runtime().compilerToVm.getJavaMirror(this);
            assert (this.getName().charAt(0) != '[' || this.isArray()) : this.getName();
        }
    }

    long getMetaspaceKlass() {
        long metaspacePointer = this.getMetaspacePointer();
        if (metaspacePointer == 0L) {
            throw new NullPointerException("Klass* is null");
        }
        return metaspacePointer;
    }

    @Override
    public long getMetaspacePointer() {
        return this.metadataPointer;
    }

    public int getModifiers() {
        if (this.isArray()) {
            return this.getElementalType().getModifiers() & 7 | 0x10 | 0x400;
        }
        return this.getAccessFlags() & HotSpotModifiers.jvmClassModifiers();
    }

    public int getAccessFlags() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceKlass() + (long)config.klassAccessFlagsOffset);
    }

    @Override
    public ResolvedJavaType getComponentType() {
        if (this.componentType == null) {
            this.componentType = this.isArray() ? HotSpotJVMCIRuntime.runtime().compilerToVm.getComponentType(this) : this;
        }
        return this.equals(this.componentType) ? null : this.componentType;
    }

    @Override
    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        if (this.isLeaf()) {
            return new Assumptions.AssumptionResult((Object)this);
        }
        HotSpotVMConfig config = HotSpotVMConfig.config();
        if (this.isArray()) {
            ResolvedJavaType elementalType = this.getElementalType();
            Assumptions.AssumptionResult elementType = elementalType.findLeafConcreteSubtype();
            if (elementType != null && ((ResolvedJavaType)elementType.getResult()).equals(elementalType)) {
                Assumptions.AssumptionResult result = new Assumptions.AssumptionResult((Object)this);
                result.add(elementType);
                return result;
            }
            return null;
        }
        if (this.isInterface()) {
            HotSpotResolvedObjectTypeImpl implementor = this.getSingleImplementor();
            if (implementor == null || implementor.equals(this)) {
                return null;
            }
            assert (!implementor.isInterface());
            if (implementor.isAbstract() || !implementor.isLeafClass()) {
                Assumptions.AssumptionResult<ResolvedJavaType> leafConcreteSubtype = implementor.findLeafConcreteSubtype();
                if (leafConcreteSubtype != null) {
                    assert (!((ResolvedJavaType)leafConcreteSubtype.getResult()).equals(implementor));
                    Assumptions.AssumptionResult newResult = new Assumptions.AssumptionResult(leafConcreteSubtype.getResult(), new Assumptions.Assumption[]{new Assumptions.ConcreteSubtype((ResolvedJavaType)this, (ResolvedJavaType)implementor)});
                    newResult.add(leafConcreteSubtype);
                    return newResult;
                }
                return null;
            }
            return this.concreteSubtype(implementor);
        }
        HotSpotResolvedObjectTypeImpl type = this;
        while (type.isAbstract()) {
            HotSpotResolvedObjectTypeImpl subklass = type.getSubklass();
            if (subklass == null || UnsafeAccess.UNSAFE.getAddress(subklass.getMetaspaceKlass() + (long)config.nextSiblingOffset) != 0L) {
                return null;
            }
            type = subklass;
        }
        if (type.isAbstract() || type.isInterface() || !type.isLeafClass()) {
            return null;
        }
        if (this.isAbstract()) {
            return this.concreteSubtype(type);
        }
        assert (this.equals(type));
        return new Assumptions.AssumptionResult((Object)type, new Assumptions.Assumption[]{new Assumptions.LeafType((ResolvedJavaType)type)});
    }

    private Assumptions.AssumptionResult<ResolvedJavaType> concreteSubtype(HotSpotResolvedObjectTypeImpl type) {
        if (type.isLeaf()) {
            return new Assumptions.AssumptionResult((Object)type, new Assumptions.Assumption[]{new Assumptions.ConcreteSubtype((ResolvedJavaType)this, (ResolvedJavaType)type)});
        }
        return new Assumptions.AssumptionResult((Object)type, new Assumptions.Assumption[]{new Assumptions.LeafType((ResolvedJavaType)type), new Assumptions.ConcreteSubtype((ResolvedJavaType)this, (ResolvedJavaType)type)});
    }

    private boolean isLeafClass() {
        return UnsafeAccess.UNSAFE.getLong(this.getMetaspaceKlass() + (long)HotSpotVMConfig.config().subklassOffset) == 0L;
    }

    private HotSpotResolvedObjectTypeImpl getSubklass() {
        return CompilerToVM.compilerToVM().getResolvedJavaType(this, (long)HotSpotVMConfig.config().subklassOffset, false);
    }

    @Override
    public HotSpotResolvedObjectTypeImpl getSuperclass() {
        if (this.isInterface()) {
            return null;
        }
        HotSpotResolvedObjectTypeImpl javaLangObject = HotSpotJVMCIRuntime.runtime().getJavaLangObject();
        if (this.equals(javaLangObject)) {
            return null;
        }
        if (this.isArray()) {
            return javaLangObject;
        }
        if (this.superClass == null) {
            this.superClass = CompilerToVM.compilerToVM().getResolvedJavaType(this, (long)HotSpotVMConfig.config().superOffset, false);
        }
        return this.superClass;
    }

    public HotSpotResolvedObjectTypeImpl[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.isArray()) {
                HotSpotResolvedObjectTypeImpl[] types = new HotSpotResolvedObjectTypeImpl[]{HotSpotJVMCIRuntime.runtime().getJavaLangCloneable(), HotSpotJVMCIRuntime.runtime().getJavaLangSerializable()};
                this.interfaces = types;
            } else {
                this.interfaces = HotSpotJVMCIRuntime.runtime().compilerToVm.getInterfaces(this);
            }
        }
        return this.interfaces;
    }

    public HotSpotResolvedObjectTypeImpl getSingleImplementor() {
        if (!this.isInterface()) {
            throw new JVMCIError("Cannot call getSingleImplementor() on a non-interface type: %s", new Object[]{this});
        }
        return CompilerToVM.compilerToVM().getImplementor(this);
    }

    @Override
    public HotSpotResolvedObjectTypeImpl getSupertype() {
        ResolvedJavaType component = this.getComponentType();
        if (component != null) {
            if (component.equals(HotSpotResolvedObjectTypeImpl.getJavaLangObject()) || component.isPrimitive()) {
                return HotSpotResolvedObjectTypeImpl.getJavaLangObject();
            }
            HotSpotResolvedObjectTypeImpl supertype = ((HotSpotResolvedObjectTypeImpl)component).getSupertype();
            return (HotSpotResolvedObjectTypeImpl)supertype.getArrayClass();
        }
        if (this.isInterface()) {
            return HotSpotResolvedObjectTypeImpl.getJavaLangObject();
        }
        return this.getSuperclass();
    }

    @Override
    public HotSpotResolvedObjectType findLeastCommonAncestor(ResolvedJavaType otherType) {
        if (otherType.isPrimitive()) {
            return null;
        }
        HotSpotResolvedObjectTypeImpl t1 = this;
        HotSpotResolvedObjectTypeImpl t2 = (HotSpotResolvedObjectTypeImpl)otherType;
        while (!t1.isAssignableFrom(t2)) {
            if (t2.isAssignableFrom(t1)) {
                return t2;
            }
            t1 = t1.getSupertype();
            t2 = t2.getSupertype();
        }
        return t1;
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        assert (!this.isArray());
        if (!CompilerToVM.compilerToVM().hasFinalizableSubclass(this)) {
            return new Assumptions.AssumptionResult((Object)false, new Assumptions.Assumption[]{new Assumptions.NoFinalizableSubclass((ResolvedJavaType)this)});
        }
        return new Assumptions.AssumptionResult((Object)true);
    }

    public boolean hasFinalizer() {
        return (this.getAccessFlags() & HotSpotVMConfig.config().jvmAccHasFinalizer) != 0;
    }

    public boolean isArray() {
        return this.layoutHelper() < HotSpotVMConfig.config().klassLayoutHelperNeutralValue;
    }

    public boolean isEnum() {
        HotSpotResolvedObjectTypeImpl superclass = this.getSuperclass();
        return superclass != null && superclass.equals(HotSpotJVMCIRuntime.runtime().getJavaLangEnum());
    }

    public boolean isInitialized() {
        return this.isArray() ? true : this.getInitState() == HotSpotVMConfig.config().instanceKlassStateFullyInitialized;
    }

    @Override
    public boolean isBeingInitialized() {
        return this.isArray() ? false : this.getInitState() == HotSpotVMConfig.config().instanceKlassStateBeingInitialized;
    }

    public boolean isLinked() {
        return this.isArray() ? true : this.getInitState() >= HotSpotVMConfig.config().instanceKlassStateLinked;
    }

    public void link() {
        if (!this.isLinked()) {
            HotSpotJVMCIRuntime.runtime().compilerToVm.ensureLinked(this);
        }
    }

    public boolean hasDefaultMethods() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        char miscFlags = UnsafeAccess.UNSAFE.getChar(this.getMetaspaceKlass() + (long)config.instanceKlassMiscFlagsOffset);
        return (miscFlags & config.jvmMiscFlagsHasDefaultMethods) != 0;
    }

    public boolean declaresDefaultMethods() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        char miscFlags = UnsafeAccess.UNSAFE.getChar(this.getMetaspaceKlass() + (long)config.instanceKlassMiscFlagsOffset);
        return (miscFlags & config.jvmMiscFlagsDeclaresDefaultMethods) != 0;
    }

    private int getInitState() {
        assert (!this.isArray()) : "_init_state only exists in InstanceKlass";
        return UnsafeAccess.UNSAFE.getByte(this.getMetaspaceKlass() + (long)HotSpotVMConfig.config().instanceKlassInitStateOffset) & 0xFF;
    }

    public void initialize() {
        if (!this.isInitialized()) {
            HotSpotJVMCIRuntime.runtime().compilerToVm.ensureInitialized(this);
            assert (this.isInitialized() || this.isBeingInitialized());
        }
    }

    public boolean isInstance(JavaConstant obj) {
        if (obj.getJavaKind() == JavaKind.Object && !obj.isNull()) {
            return HotSpotJVMCIRuntime.runtime().reflection.isInstance(this, (HotSpotObjectConstantImpl)obj);
        }
        return false;
    }

    public boolean isInstanceClass() {
        return !this.isArray() && !this.isInterface();
    }

    public boolean isInterface() {
        return (this.getAccessFlags() & HotSpotVMConfig.config().jvmAccInterface) != 0;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        assert (other != null);
        if (other instanceof HotSpotResolvedObjectTypeImpl) {
            HotSpotResolvedObjectTypeImpl otherType = (HotSpotResolvedObjectTypeImpl)other;
            return HotSpotJVMCIRuntime.runtime().reflection.isAssignableFrom(this, otherType);
        }
        return false;
    }

    public ResolvedJavaType getHostClass() {
        if (this.isArray()) {
            return null;
        }
        return CompilerToVM.compilerToVM().getHostClass(this);
    }

    public boolean isJavaLangObject() {
        return this.getName().equals("Ljava/lang/Object;");
    }

    @Override
    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        assert (!callerType.isArray());
        if (this.isInterface()) {
            return null;
        }
        if (method.isConcrete() && method.getDeclaringClass().equals(this) && method.isPublic() && !HotSpotConstantPool.isSignaturePolymorphicHolder(method.getDeclaringClass())) {
            return method;
        }
        if (!method.getDeclaringClass().isAssignableFrom((ResolvedJavaType)this)) {
            return null;
        }
        if (method.isConstructor()) {
            return method;
        }
        HotSpotResolvedJavaMethodImpl hotSpotMethod = (HotSpotResolvedJavaMethodImpl)method;
        HotSpotResolvedObjectTypeImpl hotSpotCallerType = (HotSpotResolvedObjectTypeImpl)callerType;
        return CompilerToVM.compilerToVM().resolveMethod(this, hotSpotMethod, hotSpotCallerType);
    }

    @Override
    public HotSpotConstantPool getConstantPool() {
        if (this.constantPool == null || !this.isArray() && UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceKlass() + (long)HotSpotVMConfig.config().instanceKlassConstantsOffset) != this.constantPool.getMetaspaceConstantPool()) {
            this.constantPool = CompilerToVM.compilerToVM().getConstantPool(this);
        }
        return this.constantPool;
    }

    @Override
    public int instanceSize() {
        assert (!this.isArray());
        assert (!this.isInterface());
        HotSpotVMConfig config = HotSpotVMConfig.config();
        int layoutHelper = this.layoutHelper();
        assert (layoutHelper > config.klassLayoutHelperNeutralValue) : "must be instance";
        int size = layoutHelper & ~config.klassLayoutHelperInstanceSlowPathBit;
        boolean needsSlowPath = (layoutHelper & config.klassLayoutHelperInstanceSlowPathBit) != 0;
        return needsSlowPath ? -size : size;
    }

    @Override
    public int layoutHelper() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        assert (this.getMetaspaceKlass() != 0L) : this.getName();
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceKlass() + (long)config.klassLayoutHelperOffset);
    }

    @Override
    public long getFingerprint() {
        return CompilerToVM.compilerToVM().getFingerprint(this.getMetaspaceKlass());
    }

    synchronized HotSpotResolvedJavaMethod createMethod(long metaspaceHandle) {
        HotSpotResolvedJavaMethodImpl lookupResult;
        long metaspaceMethod = UnsafeAccess.UNSAFE.getLong(metaspaceHandle);
        if (this.methodCacheArray == null) {
            this.methodCacheArray = new HotSpotResolvedJavaMethodImpl[8];
        }
        for (int i = 0; i < this.methodCacheArray.length; ++i) {
            HotSpotResolvedJavaMethodImpl curMethod = this.methodCacheArray[i];
            if (curMethod == null) {
                HotSpotResolvedJavaMethodImpl newMethod;
                this.methodCacheArray[i] = newMethod = new HotSpotResolvedJavaMethodImpl(this, metaspaceHandle);
                return newMethod;
            }
            if (curMethod.getMetaspaceMethod() != metaspaceMethod) continue;
            return curMethod;
        }
        if (this.methodCacheHashMap == null) {
            this.methodCacheHashMap = new HashMap();
        }
        if ((lookupResult = this.methodCacheHashMap.get(metaspaceMethod)) == null) {
            HotSpotResolvedJavaMethodImpl newMethod = new HotSpotResolvedJavaMethodImpl(this, metaspaceHandle);
            this.methodCacheHashMap.put(metaspaceMethod, newMethod);
            return newMethod;
        }
        return lookupResult;
    }

    @Override
    public int getVtableLength() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        if (this.isInterface() || this.isArray()) {
            return config.baseVtableLength();
        }
        int result = UnsafeAccess.UNSAFE.getInt(this.getMetaspaceKlass() + (long)config.klassVtableLengthOffset) / (config.vtableEntrySize / config.heapWordSize);
        assert (result >= config.baseVtableLength()) : UnsafeAccess.UNSAFE.getInt(this.getMetaspaceKlass() + (long)config.klassVtableLengthOffset) + " " + config.vtableEntrySize;
        return result;
    }

    HotSpotResolvedJavaField createField(JavaType type, long offset, int rawFlags, int index) {
        return new HotSpotResolvedJavaFieldImpl(this, type, offset, rawFlags, index);
    }

    @Override
    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        HotSpotResolvedJavaMethod hmethod = (HotSpotResolvedJavaMethod)method;
        HotSpotResolvedObjectType declaredHolder = hmethod.getDeclaringClass();
        if (!declaredHolder.isAssignableFrom(this) || this.isArray() || this.equals(declaredHolder) || !this.isLinked() || this.isInterface()) {
            ResolvedJavaMethod result = hmethod.uniqueConcreteMethod(declaredHolder);
            if (result != null) {
                return new Assumptions.AssumptionResult((Object)result, new Assumptions.Assumption[]{new Assumptions.ConcreteMethod(method, (ResolvedJavaType)declaredHolder, result)});
            }
            return null;
        }
        HotSpotResolvedJavaMethod resolvedMethod = (HotSpotResolvedJavaMethod)this.resolveMethod(hmethod, this);
        if (resolvedMethod == null) {
            return null;
        }
        if (resolvedMethod.canBeStaticallyBound()) {
            return new Assumptions.AssumptionResult((Object)resolvedMethod);
        }
        ResolvedJavaMethod result = resolvedMethod.uniqueConcreteMethod(this);
        if (result != null) {
            return new Assumptions.AssumptionResult((Object)result, new Assumptions.Assumption[]{new Assumptions.ConcreteMethod(method, (ResolvedJavaType)this, result)});
        }
        return null;
    }

    FieldInfo createFieldInfo(int index) {
        return new FieldInfo(index);
    }

    public void ensureInitialized() {
        HotSpotJVMCIRuntime.runtime().compilerToVm.ensureInitialized(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HotSpotResolvedObjectTypeImpl)) {
            return false;
        }
        HotSpotResolvedObjectTypeImpl that = (HotSpotResolvedObjectTypeImpl)obj;
        return this.getMetaspaceKlass() == that.getMetaspaceKlass();
    }

    @Override
    JavaConstant getJavaMirror() {
        return this.mirror;
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        if (this.instanceFields == null) {
            if (this.isArray() || this.isInterface()) {
                this.instanceFields = NO_FIELDS;
            } else {
                HotSpotResolvedJavaField[] prepend = NO_FIELDS;
                if (this.getSuperclass() != null) {
                    prepend = (HotSpotResolvedJavaField[])this.getSuperclass().getInstanceFields(true);
                }
                this.instanceFields = this.getFields(false, prepend);
            }
        }
        if (!includeSuperclasses && this.getSuperclass() != null) {
            int superClassFieldCount = this.getSuperclass().getInstanceFields(true).length;
            if (superClassFieldCount == this.instanceFields.length) {
                return NO_FIELDS;
            }
            if (superClassFieldCount != 0) {
                ResolvedJavaField[] result = new HotSpotResolvedJavaField[this.instanceFields.length - superClassFieldCount];
                System.arraycopy(this.instanceFields, superClassFieldCount, result, 0, result.length);
                return result;
            }
        }
        return this.instanceFields;
    }

    public ResolvedJavaField[] getStaticFields() {
        if (this.isArray()) {
            return new HotSpotResolvedJavaField[0];
        }
        return this.getFields(true, NO_FIELDS);
    }

    private HotSpotResolvedJavaField[] getFields(boolean retrieveStaticFields, HotSpotResolvedJavaField[] prepend) {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        long metaspaceFields = UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceKlass() + (long)config.instanceKlassFieldsOffset);
        int metaspaceFieldsLength = UnsafeAccess.UNSAFE.getInt(metaspaceFields + (long)config.arrayU1LengthOffset);
        int resultCount = 0;
        int index = 0;
        int i = 0;
        while (i < metaspaceFieldsLength) {
            FieldInfo field = new FieldInfo(index);
            if (field.hasGenericSignature()) {
                --metaspaceFieldsLength;
            }
            if (field.isStatic() == retrieveStaticFields) {
                ++resultCount;
            }
            i += config.fieldInfoFieldSlots;
            ++index;
        }
        if (resultCount == 0) {
            return prepend;
        }
        int prependLength = prepend.length;
        HotSpotResolvedJavaField[] result = new HotSpotResolvedJavaField[resultCount += prependLength];
        if (prependLength != 0) {
            System.arraycopy(prepend, 0, result, 0, prependLength);
        }
        int resultIndex = prependLength;
        for (int i2 = 0; i2 < index; ++i2) {
            FieldInfo field = new FieldInfo(i2);
            if (field.isStatic() != retrieveStaticFields) continue;
            int offset = field.getOffset();
            HotSpotResolvedJavaField resolvedJavaField = this.createField(field.getType(), offset, field.getAccessFlags(), i2);
            for (int j = resultIndex - 1; j >= prependLength && result[j].getOffset() > offset; --j) {
                result[j + 1] = result[j];
            }
            result[j + 1] = resolvedJavaField;
            ++resultIndex;
        }
        return result;
    }

    public String getSourceFileName() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        char sourceFileNameIndex = UnsafeAccess.UNSAFE.getChar(this.getMetaspaceKlass() + (long)config.instanceKlassSourceFileNameIndexOffset);
        if (sourceFileNameIndex == '\u0000') {
            return null;
        }
        return this.getConstantPool().lookupUtf8(sourceFileNameIndex);
    }

    public Annotation[] getAnnotations() {
        return HotSpotJVMCIRuntime.runtime().reflection.getAnnotations(this);
    }

    public Annotation[] getDeclaredAnnotations() {
        return HotSpotJVMCIRuntime.runtime().reflection.getDeclaredAnnotations(this);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return HotSpotJVMCIRuntime.runtime().reflection.getAnnotation(this, annotationClass);
    }

    @Override
    public boolean isDefinitelyResolvedWithRespectTo(ResolvedJavaType accessingClass) {
        assert (accessingClass != null);
        ResolvedJavaType elementType = this.getElementalType();
        if (elementType.isPrimitive()) {
            return true;
        }
        if (elementType.getName().startsWith("Ljava/")) {
            assert (this.hasSameClassLoader(HotSpotJVMCIRuntime.runtime().getJavaLangObject()));
            return true;
        }
        HotSpotResolvedObjectTypeImpl otherMirror = (HotSpotResolvedObjectTypeImpl)accessingClass;
        return this.hasSameClassLoader(otherMirror);
    }

    private boolean hasSameClassLoader(HotSpotResolvedObjectTypeImpl otherMirror) {
        return UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceKlass() + (long)HotSpotVMConfig.config().classLoaderDataOffset) == UnsafeAccess.UNSAFE.getAddress(otherMirror.getMetaspaceKlass() + (long)HotSpotVMConfig.config().classLoaderDataOffset);
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        if (this.isDefinitelyResolvedWithRespectTo(Objects.requireNonNull(accessingClass))) {
            return this;
        }
        HotSpotResolvedObjectTypeImpl accessingType = (HotSpotResolvedObjectTypeImpl)accessingClass;
        return (ResolvedJavaType)HotSpotJVMCIRuntime.runtime().lookupType(this.getName(), accessingType, true);
    }

    @Override
    public Constant klass() {
        return HotSpotMetaspaceConstantImpl.forMetaspaceObject(this, false);
    }

    @Override
    public boolean isPrimaryType() {
        return HotSpotVMConfig.config().secondarySuperCacheOffset != this.superCheckOffset();
    }

    @Override
    public int superCheckOffset() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceKlass() + (long)config.superCheckOffsetOffset);
    }

    @Override
    public long prototypeMarkWord() {
        HotSpotVMConfig config = HotSpotVMConfig.config();
        if (this.isArray()) {
            return config.arrayPrototypeMarkWord();
        }
        return UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceKlass() + (long)config.prototypeMarkWordOffset);
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedEntryKind) {
        ResolvedJavaField[] declaredFields = this.getInstanceFields(true);
        return HotSpotResolvedObjectTypeImpl.findFieldWithOffset(offset, expectedEntryKind, declaredFields);
    }

    public ResolvedJavaField findStaticFieldWithOffset(long offset, JavaKind expectedEntryKind) {
        ResolvedJavaField[] declaredFields = this.getStaticFields();
        return HotSpotResolvedObjectTypeImpl.findFieldWithOffset(offset, expectedEntryKind, declaredFields);
    }

    private static ResolvedJavaField findFieldWithOffset(long offset, JavaKind expectedEntryKind, ResolvedJavaField[] declaredFields) {
        for (ResolvedJavaField field : declaredFields) {
            long resolvedFieldOffset = field.getOffset();
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN && expectedEntryKind.isPrimitive() && !expectedEntryKind.equals((Object)JavaKind.Void) && field.getJavaKind().isPrimitive()) {
                resolvedFieldOffset += (long)(field.getJavaKind().getByteCount() - Math.min(field.getJavaKind().getByteCount(), 4 + expectedEntryKind.getByteCount()));
            }
            if (resolvedFieldOffset != offset) continue;
            return field;
        }
        return null;
    }

    public boolean isLocal() {
        return HotSpotJVMCIRuntime.runtime().reflection.isLocalClass(this);
    }

    public boolean isMember() {
        return HotSpotJVMCIRuntime.runtime().reflection.isMemberClass(this);
    }

    @Override
    public HotSpotResolvedObjectType getEnclosingType() {
        return HotSpotJVMCIRuntime.runtime().reflection.getEnclosingClass(this);
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getDeclaredConstructors(this);
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.getDeclaredMethods(this);
    }

    @Override
    public ResolvedJavaMethod getClassInitializer() {
        if (!this.isArray()) {
            return CompilerToVM.compilerToVM().getClassInitializer(this);
        }
        return null;
    }

    public String toString() {
        return "HotSpotType<" + this.getName() + ", resolved>";
    }

    public ResolvedJavaType lookupType(UnresolvedJavaType unresolvedJavaType, boolean resolve) {
        JavaType javaType = HotSpotJVMCIRuntime.runtime().lookupType(unresolvedJavaType.getName(), this, resolve);
        if (javaType instanceof ResolvedJavaType) {
            return (ResolvedJavaType)javaType;
        }
        return null;
    }

    public ResolvedJavaField resolveField(UnresolvedJavaField unresolvedJavaField, ResolvedJavaType accessingClass) {
        for (ResolvedJavaField field : this.getInstanceFields(false)) {
            if (!field.getName().equals(unresolvedJavaField.getName())) continue;
            return field;
        }
        for (ResolvedJavaField field : this.getStaticFields()) {
            if (!field.getName().equals(unresolvedJavaField.getName())) continue;
            return field;
        }
        throw new InternalError(unresolvedJavaField.toString());
    }

    public boolean isCloneableWithAllocation() {
        return (this.getAccessFlags() & HotSpotVMConfig.config().jvmAccIsCloneable) != 0;
    }

    JavaConstant readFieldValue(HotSpotResolvedJavaField field, boolean isVolatile) {
        return HotSpotJVMCIRuntime.runtime().reflection.readFieldValue(this, field, isVolatile);
    }

    class FieldInfo {
        private final long metaspaceData;

        FieldInfo(int index) {
            HotSpotVMConfig config = HotSpotVMConfig.config();
            long metaspaceFields = UnsafeAccess.UNSAFE.getAddress(HotSpotResolvedObjectTypeImpl.this.getMetaspaceKlass() + (long)config.instanceKlassFieldsOffset);
            assert (config.fieldInfoFieldSlots == 6) : "revisit the field parsing code";
            int offset = config.fieldInfoFieldSlots * 2 * index;
            this.metaspaceData = metaspaceFields + (long)config.arrayU2DataOffset + (long)offset;
        }

        private int getAccessFlags() {
            return this.readFieldSlot(HotSpotVMConfig.config().fieldInfoAccessFlagsOffset);
        }

        private int getNameIndex() {
            return this.readFieldSlot(HotSpotVMConfig.config().fieldInfoNameIndexOffset);
        }

        private int getSignatureIndex() {
            return this.readFieldSlot(HotSpotVMConfig.config().fieldInfoSignatureIndexOffset);
        }

        public int getOffset() {
            HotSpotVMConfig config = HotSpotVMConfig.config();
            int lowPacked = this.readFieldSlot(config.fieldInfoLowPackedOffset);
            int highPacked = this.readFieldSlot(config.fieldInfoHighPackedOffset);
            int offset = (highPacked << 16 | lowPacked) >> config.fieldInfoTagSize;
            return offset;
        }

        private int readFieldSlot(int index) {
            int offset = 2 * index;
            return UnsafeAccess.UNSAFE.getChar(this.metaspaceData + (long)offset);
        }

        public String getName() {
            int nameIndex = this.getNameIndex();
            return this.isInternal() ? HotSpotVMConfig.config().symbolAt(nameIndex) : HotSpotResolvedObjectTypeImpl.this.getConstantPool().lookupUtf8(nameIndex);
        }

        public String getSignature() {
            int signatureIndex = this.getSignatureIndex();
            return this.isInternal() ? HotSpotVMConfig.config().symbolAt(signatureIndex) : HotSpotResolvedObjectTypeImpl.this.getConstantPool().lookupUtf8(signatureIndex);
        }

        public JavaType getType() {
            String signature = this.getSignature();
            return HotSpotJVMCIRuntime.runtime().lookupType(signature, HotSpotResolvedObjectTypeImpl.this, false);
        }

        private boolean isInternal() {
            return (this.getAccessFlags() & HotSpotVMConfig.config().jvmAccFieldInternal) != 0;
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.getAccessFlags());
        }

        public boolean hasGenericSignature() {
            return (this.getAccessFlags() & HotSpotVMConfig.config().jvmAccFieldHasGenericSignature) != 0;
        }
    }
}

