/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMethodHandleAccessProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

abstract class HotSpotObjectConstantImpl
implements HotSpotObjectConstant {
    protected final boolean compressed;

    HotSpotObjectConstantImpl(boolean compressed) {
        this.compressed = compressed;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public abstract JavaConstant compress();

    @Override
    public abstract JavaConstant uncompress();

    @Override
    public HotSpotResolvedObjectType getType() {
        return HotSpotJVMCIRuntime.runtime().reflection.getType(this);
    }

    @Override
    public abstract int getIdentityHashCode();

    private boolean isFullyInitializedConstantCallSite() {
        if (!HotSpotJVMCIRuntime.runtime().getConstantCallSite().isInstance(this)) {
            return false;
        }
        HotSpotResolvedJavaField field = HotSpotMethodHandleAccessProvider.Internals.instance().constantCallSiteFrozenField;
        boolean isFrozen = this.readFieldValue(field, true).asBoolean();
        return isFrozen;
    }

    private HotSpotObjectConstantImpl readTarget() {
        HotSpotResolvedJavaField field = HotSpotMethodHandleAccessProvider.Internals.instance().callSiteTargetField;
        return (HotSpotObjectConstantImpl)this.readFieldValue(field, true);
    }

    @Override
    public JavaConstant getCallSiteTarget(Assumptions assumptions) {
        if (HotSpotJVMCIRuntime.runtime().getCallSite().isInstance(this)) {
            if (!this.isFullyInitializedConstantCallSite()) {
                if (assumptions == null) {
                    return null;
                }
                assumptions.record((Assumptions.Assumption)new Assumptions.CallSiteTargetValue((JavaConstant)this, (JavaConstant)this.readTarget()));
            }
            return this.readTarget();
        }
        return null;
    }

    @Override
    public boolean isInternedString() {
        return HotSpotJVMCIRuntime.runtime().compilerToVm.isInternedString(this);
    }

    @Override
    public <T> T asObject(Class<T> type) {
        return HotSpotJVMCIRuntime.runtime().reflection.asObject(this, type);
    }

    @Override
    public Object asObject(ResolvedJavaType type) {
        return HotSpotJVMCIRuntime.runtime().reflection.asObject(this, (HotSpotResolvedJavaType)type);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HotSpotObjectConstantImpl) {
            HotSpotObjectConstantImpl other = (HotSpotObjectConstantImpl)o;
            return HotSpotJVMCIRuntime.runtime().reflection.equals(this, other);
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentityHashCode();
    }

    @Override
    public String toValueString() {
        if (HotSpotJVMCIRuntime.runtime().getJavaLangString().isInstance(this)) {
            return "\"" + HotSpotJVMCIRuntime.runtime().reflection.asString(this) + "\"";
        }
        return HotSpotJVMCIRuntime.runtime().reflection.formatString(this);
    }

    public String toString() {
        return (this.compressed ? "NarrowOop" : this.getJavaKind().getJavaName()) + "[" + HotSpotJVMCIRuntime.runtime().reflection.formatString(this) + "]";
    }

    public JavaConstant readFieldValue(HotSpotResolvedJavaField field, boolean isVolatile) {
        return HotSpotJVMCIRuntime.runtime().reflection.readFieldValue(this, field, isVolatile);
    }

    public ResolvedJavaType asJavaType() {
        return HotSpotJVMCIRuntime.runtime().reflection.asJavaType(this);
    }
}

