/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Arrays;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotMethodDataAccessor;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;

final class HotSpotMethodData {
    final long metaspaceMethodData;
    private final HotSpotResolvedJavaMethodImpl method;
    private final VMState state;

    HotSpotMethodData(long metaspaceMethodData, HotSpotResolvedJavaMethodImpl method) {
        this.metaspaceMethodData = metaspaceMethodData;
        this.method = method;
        this.state = VMState.instance();
    }

    private int normalDataSize() {
        return UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataDataSize);
    }

    private int extraDataSize() {
        int extraDataBase = this.state.config.methodDataOopDataOffset + this.normalDataSize();
        int extraDataLimit = UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataSize);
        return extraDataLimit - extraDataBase;
    }

    public boolean hasNormalData() {
        return this.normalDataSize() > 0;
    }

    public boolean hasExtraData() {
        return this.extraDataSize() > 0;
    }

    public int getExtraDataBeginOffset() {
        return this.normalDataSize();
    }

    public boolean isWithin(int position) {
        return position >= 0 && position < this.normalDataSize() + this.extraDataSize();
    }

    public int getDeoptimizationCount(DeoptimizationReason reason) {
        HotSpotMetaAccessProvider metaAccess = (HotSpotMetaAccessProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess();
        int reasonIndex = metaAccess.convertDeoptReason(reason);
        return UnsafeAccess.UNSAFE.getByte(this.metaspaceMethodData + (long)this.state.config.methodDataOopTrapHistoryOffset + (long)reasonIndex) & 0xFF;
    }

    public int getOSRDeoptimizationCount(DeoptimizationReason reason) {
        HotSpotMetaAccessProvider metaAccess = (HotSpotMetaAccessProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess();
        int reasonIndex = metaAccess.convertDeoptReason(reason);
        return UnsafeAccess.UNSAFE.getByte(this.metaspaceMethodData + (long)this.state.config.methodDataOopTrapHistoryOffset + (long)this.state.config.deoptReasonOSROffset + (long)reasonIndex) & 0xFF;
    }

    public int getDecompileCount() {
        return UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataDecompiles);
    }

    public int getOverflowRecompileCount() {
        return UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataOverflowRecompiles);
    }

    public int getOverflowTrapCount() {
        return UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataOverflowTraps);
    }

    public HotSpotMethodDataAccessor getNormalData(int position) {
        if (position >= this.normalDataSize()) {
            return null;
        }
        return this.getData(position);
    }

    public HotSpotMethodDataAccessor getExtraData(int position) {
        if (position >= this.normalDataSize() + this.extraDataSize()) {
            return null;
        }
        HotSpotMethodDataAccessor data = this.getData(position);
        if (data != null) {
            return data;
        }
        return data;
    }

    public static HotSpotMethodDataAccessor getNoDataAccessor(boolean exceptionPossiblyNotRecorded) {
        if (exceptionPossiblyNotRecorded) {
            return VMState.instance().noDataExceptionPossiblyNotRecordedAccessor;
        }
        return VMState.instance().noDataNoExceptionAccessor;
    }

    private HotSpotMethodDataAccessor getData(int position) {
        assert (position >= 0) : "out of bounds";
        int tag = HotSpotMethodDataAccessor.readTag(this.state.config, this, position);
        HotSpotMethodDataAccessor accessor = this.state.profileDataAccessors[tag];
        assert (accessor == null || accessor.getTag() == tag) : "wrong data accessor " + accessor + " for tag " + tag;
        return accessor;
    }

    int readUnsignedByte(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return UnsafeAccess.UNSAFE.getByte(this.metaspaceMethodData + fullOffsetInBytes) & 0xFF;
    }

    int readUnsignedShort(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return UnsafeAccess.UNSAFE.getShort(this.metaspaceMethodData + fullOffsetInBytes) & 0xFFFF;
    }

    private long readUnsignedInt(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return UnsafeAccess.UNSAFE.getAddress(this.metaspaceMethodData + fullOffsetInBytes) & 0xFFFFFFFFL;
    }

    private int readUnsignedIntAsSignedInt(int position, int offsetInBytes) {
        long value = this.readUnsignedInt(position, offsetInBytes);
        return VMState.truncateLongToInt(value);
    }

    private int readInt(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return (int)UnsafeAccess.UNSAFE.getAddress(this.metaspaceMethodData + fullOffsetInBytes);
    }

    private HotSpotResolvedJavaMethod readMethod(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return CompilerToVM.compilerToVM().getResolvedJavaMethod(null, this.metaspaceMethodData + fullOffsetInBytes);
    }

    private HotSpotResolvedObjectTypeImpl readKlass(int position, int offsetInBytes) {
        long fullOffsetInBytes = this.state.computeFullOffset(position, offsetInBytes);
        return CompilerToVM.compilerToVM().getResolvedJavaType(this.metaspaceMethodData + fullOffsetInBytes, false);
    }

    public boolean isProfileMature() {
        return HotSpotJVMCIRuntime.runtime().getCompilerToVM().isMature(this.metaspaceMethodData);
    }

    public String toString() {
        int bci;
        HotSpotMethodDataAccessor data;
        int pos;
        StringBuilder sb = new StringBuilder();
        String nl = String.format("%n", new Object[0]);
        String nlIndent = String.format("%n%38s", "");
        sb.append("Raw method data for ");
        sb.append(this.method.format("%H.%n(%p)"));
        sb.append(":");
        sb.append(nl);
        sb.append(String.format("nof_decompiles(%d) nof_overflow_recompiles(%d) nof_overflow_traps(%d)%n", this.getDecompileCount(), this.getOverflowRecompileCount(), this.getOverflowTrapCount()));
        if (this.hasNormalData()) {
            pos = 0;
            while ((data = this.getNormalData(pos)) != null) {
                if (pos != 0) {
                    sb.append(nl);
                }
                bci = data.getBCI(this, pos);
                sb.append(String.format("%-6d bci: %-6d%-20s", pos, bci, data.getClass().getSimpleName()));
                sb.append(data.appendTo(new StringBuilder(), this, pos).toString().replace(nl, nlIndent));
                pos += data.getSize(this, pos);
            }
        }
        if (this.hasExtraData()) {
            pos = this.getExtraDataBeginOffset();
            while ((data = this.getExtraData(pos)) != null) {
                if (pos == this.getExtraDataBeginOffset()) {
                    sb.append(nl).append("--- Extra data:");
                }
                bci = data.getBCI(this, pos);
                sb.append(String.format("%n%-6d bci: %-6d%-20s", pos, bci, data.getClass().getSimpleName()));
                sb.append(data.appendTo(new StringBuilder(), this, pos).toString().replace(nl, nlIndent));
                pos += data.getSize(this, pos);
            }
        }
        return sb.toString();
    }

    public void setCompiledIRSize(int size) {
        UnsafeAccess.UNSAFE.putInt(this.metaspaceMethodData + (long)this.state.config.methodDataIRSizeOffset, size);
    }

    public int getCompiledIRSize() {
        return UnsafeAccess.UNSAFE.getInt(this.metaspaceMethodData + (long)this.state.config.methodDataIRSizeOffset);
    }

    static class UnknownProfileData
    extends HotSpotMethodDataAccessor {
        UnknownProfileData(VMState state, int tag) {
            super(state, tag, 0);
        }

        @Override
        protected int getDynamicSize(HotSpotMethodData data, int position) {
            assert (this.staticSize == 0);
            return HotSpotJVMCIRuntime.runtime().compilerToVm.methodDataProfileDataSize(data.metaspaceMethodData, position);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            sb.append("unknown profile data with tag: " + this.tag);
            return sb;
        }
    }

    static class ArgInfoData
    extends ArrayData {
        ArgInfoData(VMState state, int tag) {
            super(state, tag, state.argInfoDataSize);
        }
    }

    static class MultiBranchData
    extends ArrayData {
        MultiBranchData(VMState state, int tag) {
            super(state, tag, state.multiBranchDataSize);
        }

        @Override
        public double[] getSwitchProbabilities(HotSpotMethodData data, int position) {
            int i;
            int arrayLength = this.getLength(data, position);
            assert (arrayLength > 0) : "switch must have at least the default case";
            assert (arrayLength % this.state.multiBranchDataRowSizeInCells == 0) : "array must have full rows";
            int length = arrayLength / this.state.multiBranchDataRowSizeInCells;
            long totalCount = 0L;
            double[] result = new double[length];
            long count = this.readCount(data, position, 0);
            totalCount += count;
            result[length - 1] = count;
            for (i = 1; i < length; ++i) {
                count = this.readCount(data, position, i);
                totalCount += count;
                result[i - 1] = count;
            }
            if (totalCount <= 0L) {
                return null;
            }
            for (i = 0; i < length; ++i) {
                result[i] = result[i] / (double)totalCount;
            }
            return result;
        }

        private long readCount(HotSpotMethodData data, int position, int i) {
            int offset = this.getCountOffset(i);
            long count = data.readUnsignedInt(position, offset);
            return count;
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            int arrayLength = this.getLength(data, position);
            assert (arrayLength > 0) : "switch must have at least the default case";
            assert (arrayLength % this.state.multiBranchDataRowSizeInCells == 0) : "array must have full rows";
            int length = arrayLength / this.state.multiBranchDataRowSizeInCells;
            long totalCount = 0L;
            for (int i = 0; i < length; ++i) {
                int offset = this.getCountOffset(i);
                totalCount += data.readUnsignedInt(position, offset);
            }
            return VMState.truncateLongToInt(totalCount);
        }

        private int getCountOffset(int index) {
            return this.state.multiBranchDataFirstCountOffset + index * this.state.multiBranchDataRowSize;
        }

        private int getDisplacementOffset(int index) {
            return this.state.multiBranchDataFirstDisplacementOffset + index * this.state.multiBranchDataRowSize;
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            int entries = this.getLength(data, pos) / this.state.multiBranchDataRowSizeInCells;
            sb.append(String.format("entries(%d)", entries));
            for (int i = 0; i < entries; ++i) {
                sb.append(String.format("%n  %d: count(%d) displacement(%d)", i, data.readUnsignedInt(pos, this.getCountOffset(i)), data.readUnsignedInt(pos, this.getDisplacementOffset(i))));
            }
            return sb;
        }
    }

    static class ArrayData
    extends HotSpotMethodDataAccessor {
        ArrayData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        protected int getDynamicSize(HotSpotMethodData data, int position) {
            return this.state.cellsToBytes(this.getLength(data, position));
        }

        protected int getLength(HotSpotMethodData data, int position) {
            return data.readInt(position, this.state.arrayDataLengthOffset);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            return sb.append(String.format("length(%d)", this.getLength(data, pos)));
        }
    }

    static class BranchData
    extends JumpData {
        BranchData(VMState state, int tag) {
            super(state, tag, state.branchDataSize);
        }

        @Override
        public double getBranchTakenProbability(HotSpotMethodData data, int position) {
            long notTakenCount;
            long takenCount = data.readUnsignedInt(position, this.state.takenCountOffset);
            long total = takenCount + (notTakenCount = data.readUnsignedInt(position, this.state.notTakenCountOffset));
            return total <= 0L ? -1.0 : (double)takenCount / (double)total;
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            long count = data.readUnsignedInt(position, this.state.takenCountOffset) + data.readUnsignedInt(position, this.state.notTakenCountOffset);
            return VMState.truncateLongToInt(count);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            long taken = data.readUnsignedInt(pos, this.state.takenCountOffset);
            long notTaken = data.readUnsignedInt(pos, this.state.notTakenCountOffset);
            double takenProbability = this.getBranchTakenProbability(data, pos);
            return sb.append(String.format("taken(%d, %4.2f) not_taken(%d, %4.2f) displacement(%d)", taken, takenProbability, notTaken, 1.0 - takenProbability, this.getTakenDisplacement(data, pos)));
        }
    }

    static class RetData
    extends CounterData {
        RetData(VMState state, int tag) {
            super(state, tag, state.retDataSize);
        }
    }

    static class VirtualCallTypeData
    extends VirtualCallData {
        VirtualCallTypeData(VMState state, int tag) {
            super(state, tag, 0);
        }

        @Override
        protected int getDynamicSize(HotSpotMethodData data, int position) {
            assert (this.staticSize == 0);
            return HotSpotJVMCIRuntime.runtime().compilerToVm.methodDataProfileDataSize(data.metaspaceMethodData, position);
        }
    }

    static class VirtualCallData
    extends ReceiverTypeData {
        VirtualCallData(VMState state, int tag) {
            super(state, tag, state.virtualCallDataSize);
        }

        protected VirtualCallData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            int typeProfileWidth = this.config.typeProfileWidth;
            long total = 0L;
            for (int i = 0; i < typeProfileWidth; ++i) {
                total += data.readUnsignedInt(position, this.getTypeCountOffset(i));
            }
            return VMState.truncateLongToInt(total += (long)this.getCounterValue(data, position));
        }

        @Override
        protected long getTypesNotRecordedExecutionCount(HotSpotMethodData data, int position) {
            return this.getCounterValue(data, position);
        }

        private long getMethodsNotRecordedExecutionCount(HotSpotMethodData data, int position) {
            return data.readUnsignedIntAsSignedInt(position, this.state.nonprofiledCountOffset);
        }

        @Override
        public JavaMethodProfile getMethodProfile(HotSpotMethodData data, int position) {
            return this.createMethodProfile(this.getRawMethodProfile(data, position));
        }

        private RawItemProfile<ResolvedJavaMethod> getRawMethodProfile(HotSpotMethodData data, int position) {
            int profileWidth = this.config.methodProfileWidth;
            ResolvedJavaMethod[] methods = new ResolvedJavaMethod[profileWidth];
            long[] counts = new long[profileWidth];
            long totalCount = 0L;
            int entries = 0;
            for (int i = 0; i < profileWidth; ++i) {
                HotSpotResolvedJavaMethod method = data.readMethod(position, this.getMethodOffset(i));
                if (method == null) continue;
                methods[entries] = method;
                long count = data.readUnsignedInt(position, this.getMethodCountOffset(i));
                totalCount += count;
                counts[entries] = count;
                ++entries;
            }
            totalCount += this.getMethodsNotRecordedExecutionCount(data, position);
            if (entries == 1) {
                counts[0] = totalCount;
            }
            return new RawItemProfile<ResolvedJavaMethod>(entries, methods, counts, totalCount);
        }

        private JavaMethodProfile createMethodProfile(RawItemProfile<ResolvedJavaMethod> profile) {
            double notRecordedMethodProbability;
            if (profile.entries <= 0 || profile.totalCount <= 0L) {
                return null;
            }
            Object[] pmethods = new JavaMethodProfile.ProfiledMethod[profile.entries];
            double totalProbability = 0.0;
            for (int i = 0; i < profile.entries; ++i) {
                double p = profile.counts[i];
                totalProbability += (p /= (double)profile.totalCount);
                pmethods[i] = new JavaMethodProfile.ProfiledMethod(((ResolvedJavaMethod[])profile.items)[i], p);
            }
            Arrays.sort(pmethods);
            double d = notRecordedMethodProbability = profile.entries < this.config.methodProfileWidth ? 0.0 : Math.min(1.0, Math.max(0.0, 1.0 - totalProbability));
            assert (notRecordedMethodProbability == 0.0 || profile.entries == this.config.methodProfileWidth);
            return new JavaMethodProfile(notRecordedMethodProbability, (JavaMethodProfile.ProfiledMethod[])pmethods);
        }

        private int getMethodOffset(int row) {
            return this.state.virtualCallDataFirstMethodOffset + row * this.state.typeDataRowSize;
        }

        private int getMethodCountOffset(int row) {
            return this.state.virtualCallDataFirstMethodCountOffset + row * this.state.typeDataRowSize;
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            RawItemProfile<ResolvedJavaMethod> profile = this.getRawMethodProfile(data, pos);
            super.appendTo(sb.append(String.format("exception_seen(%s) ", this.getExceptionSeen(data, pos))), data, pos).append(String.format("%nmethod_entries(%d)", profile.entries));
            for (int i = 0; i < profile.entries; ++i) {
                long count = profile.counts[i];
                sb.append(String.format("%n  %s (%d, %4.2f)", ((ResolvedJavaMethod[])profile.items)[i].format("%H.%n(%p)"), count, (double)count / (double)profile.totalCount));
            }
            return sb;
        }
    }

    static class ReceiverTypeData
    extends AbstractTypeData {
        ReceiverTypeData(VMState state, int tag) {
            super(state, tag, state.typeCheckDataSize);
        }

        protected ReceiverTypeData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            return -1;
        }

        @Override
        protected long getTypesNotRecordedExecutionCount(HotSpotMethodData data, int position) {
            return this.getNonprofiledCount(data, position);
        }
    }

    static abstract class AbstractTypeData
    extends CounterData {
        protected AbstractTypeData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public JavaTypeProfile getTypeProfile(HotSpotMethodData data, int position) {
            return this.createTypeProfile(this.getNullSeen(data, position), this.getRawTypeProfile(data, position));
        }

        private RawItemProfile<ResolvedJavaType> getRawTypeProfile(HotSpotMethodData data, int position) {
            int typeProfileWidth = this.config.typeProfileWidth;
            ResolvedJavaType[] types = new ResolvedJavaType[typeProfileWidth];
            long[] counts = new long[typeProfileWidth];
            long totalCount = 0L;
            int entries = 0;
            block0: for (int i = 0; i < typeProfileWidth; ++i) {
                HotSpotResolvedObjectTypeImpl receiverKlass = data.readKlass(position, this.getTypeOffset(i));
                if (receiverKlass == null) continue;
                HotSpotResolvedObjectTypeImpl klass = receiverKlass;
                long count = data.readUnsignedInt(position, this.getTypeCountOffset(i));
                for (int j = 0; j < entries; ++j) {
                    if (!types[j].equals(klass)) continue;
                    totalCount += count;
                    int n = j;
                    counts[n] = counts[n] + count;
                    continue block0;
                }
                types[entries] = klass;
                totalCount += count;
                counts[entries] = count;
                ++entries;
            }
            return new RawItemProfile<ResolvedJavaType>(entries, types, counts, totalCount += this.getTypesNotRecordedExecutionCount(data, position));
        }

        protected abstract long getTypesNotRecordedExecutionCount(HotSpotMethodData var1, int var2);

        public int getNonprofiledCount(HotSpotMethodData data, int position) {
            return data.readUnsignedIntAsSignedInt(position, this.state.nonprofiledCountOffset);
        }

        private JavaTypeProfile createTypeProfile(TriState nullSeen, RawItemProfile<ResolvedJavaType> profile) {
            double notRecordedTypeProbability;
            if (profile.entries <= 0 || profile.totalCount <= 0L) {
                return null;
            }
            Object[] ptypes = new JavaTypeProfile.ProfiledType[profile.entries];
            double totalProbability = 0.0;
            for (int i = 0; i < profile.entries; ++i) {
                double p = profile.counts[i];
                totalProbability += (p /= (double)profile.totalCount);
                ptypes[i] = new JavaTypeProfile.ProfiledType(((ResolvedJavaType[])profile.items)[i], p);
            }
            Arrays.sort(ptypes);
            double d = notRecordedTypeProbability = profile.entries < this.config.typeProfileWidth ? 0.0 : Math.min(1.0, Math.max(0.0, 1.0 - totalProbability));
            assert (notRecordedTypeProbability == 0.0 || profile.entries == this.config.typeProfileWidth);
            return new JavaTypeProfile(nullSeen, notRecordedTypeProbability, (JavaTypeProfile.ProfiledType[])ptypes);
        }

        private int getTypeOffset(int row) {
            return this.state.typeDataFirstTypeOffset + row * this.state.typeDataRowSize;
        }

        protected int getTypeCountOffset(int row) {
            return this.state.typeDataFirstTypeCountOffset + row * this.state.typeDataRowSize;
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            RawItemProfile<ResolvedJavaType> profile = this.getRawTypeProfile(data, pos);
            TriState nullSeen = this.getNullSeen(data, pos);
            TriState exceptionSeen = this.getExceptionSeen(data, pos);
            sb.append(String.format("count(%d) null_seen(%s) exception_seen(%s) nonprofiled_count(%d) entries(%d)", this.getCounterValue(data, pos), nullSeen, exceptionSeen, this.getNonprofiledCount(data, pos), profile.entries));
            for (int i = 0; i < profile.entries; ++i) {
                long count = profile.counts[i];
                sb.append(String.format("%n  %s (%d, %4.2f)", ((ResolvedJavaType[])profile.items)[i].toJavaName(), count, (double)count / (double)profile.totalCount));
            }
            return sb;
        }
    }

    static class RawItemProfile<T> {
        final int entries;
        final T[] items;
        final long[] counts;
        final long totalCount;

        RawItemProfile(int entries, T[] items, long[] counts, long totalCount) {
            this.entries = entries;
            this.items = items;
            this.counts = counts;
            this.totalCount = totalCount;
        }
    }

    static class JumpData
    extends HotSpotMethodDataAccessor {
        JumpData(VMState state, int tag) {
            super(state, tag, state.jumpDataSize);
        }

        protected JumpData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public double getBranchTakenProbability(HotSpotMethodData data, int position) {
            return this.getExecutionCount(data, position) != 0 ? 1.0 : 0.0;
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            return data.readUnsignedIntAsSignedInt(position, this.state.takenCountOffset);
        }

        public int getTakenDisplacement(HotSpotMethodData data, int position) {
            return data.readInt(position, this.state.takenDisplacementOffset);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            return sb.append(String.format("taken(%d) displacement(%d)", this.getExecutionCount(data, pos), this.getTakenDisplacement(data, pos)));
        }
    }

    static class CounterData
    extends BitData {
        CounterData(VMState state, int tag) {
            super(state, tag, state.counterDataSize);
        }

        protected CounterData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public int getExecutionCount(HotSpotMethodData data, int position) {
            return this.getCounterValue(data, position);
        }

        protected int getCounterValue(HotSpotMethodData data, int position) {
            return data.readUnsignedIntAsSignedInt(position, this.state.counterDataCountOffset);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            return sb.append(String.format("count(%d) null_seen(%s) exception_seen(%s)", this.getCounterValue(data, pos), this.getNullSeen(data, pos), this.getExceptionSeen(data, pos)));
        }
    }

    static class BitData
    extends HotSpotMethodDataAccessor {
        private BitData(VMState state, int tag) {
            super(state, tag, state.bitDataSize);
        }

        protected BitData(VMState state, int tag, int staticSize) {
            super(state, tag, staticSize);
        }

        @Override
        public TriState getNullSeen(HotSpotMethodData data, int position) {
            return TriState.get(((this.getFlags(data, position) & this.state.bitDataNullSeenFlag) != 0 ? 1 : 0) != 0);
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            return sb.append(String.format("exception_seen(%s)", this.getExceptionSeen(data, pos)));
        }
    }

    static class NoMethodData
    extends HotSpotMethodDataAccessor {
        private final TriState exceptionSeen;

        protected NoMethodData(VMState state, int tag, TriState exceptionSeen) {
            super(state, tag, state.noDataSize);
            this.exceptionSeen = exceptionSeen;
        }

        @Override
        public int getBCI(HotSpotMethodData data, int position) {
            return -1;
        }

        @Override
        public TriState getExceptionSeen(HotSpotMethodData data, int position) {
            return this.exceptionSeen;
        }

        @Override
        public StringBuilder appendTo(StringBuilder sb, HotSpotMethodData data, int pos) {
            return sb;
        }
    }

    static final class VMState {
        final HotSpotVMConfig config = HotSpotVMConfig.config();
        final HotSpotMethodDataAccessor noDataNoExceptionAccessor;
        final HotSpotMethodDataAccessor noDataExceptionPossiblyNotRecordedAccessor;
        final int noDataSize;
        final int bitDataSize;
        final int bitDataNullSeenFlag;
        final int counterDataSize;
        final int counterDataCountOffset;
        final int jumpDataSize;
        final int takenCountOffset;
        final int takenDisplacementOffset;
        final int typeDataRowSize;
        final int nonprofiledCountOffset;
        final int typeDataFirstTypeOffset;
        final int typeDataFirstTypeCountOffset;
        final int typeCheckDataSize;
        final int virtualCallDataSize;
        final int virtualCallDataFirstMethodOffset;
        final int virtualCallDataFirstMethodCountOffset;
        final int retDataRowSize;
        final int retDataSize;
        final int branchDataSize;
        final int notTakenCountOffset;
        final int arrayDataLengthOffset;
        final int arrayDataStartOffset;
        final int multiBranchDataSize;
        final int multiBranchDataRowSizeInCells;
        final int multiBranchDataRowSize;
        final int multiBranchDataFirstCountOffset;
        final int multiBranchDataFirstDisplacementOffset;
        final int argInfoDataSize;
        final HotSpotMethodDataAccessor[] profileDataAccessors;
        @NativeImageReinitialize
        private static volatile VMState instance;

        private boolean checkAccessorTags() {
            int expectedTag = 0;
            for (HotSpotMethodDataAccessor accessor : this.profileDataAccessors) {
                if (expectedTag == 0) {
                    assert (accessor == null);
                } else assert (accessor.tag == expectedTag) : expectedTag + " != " + accessor.tag + " " + accessor;
                ++expectedTag;
            }
            return true;
        }

        private VMState() {
            this.noDataNoExceptionAccessor = new NoMethodData(this, this.config.dataLayoutNoTag, TriState.FALSE);
            this.noDataExceptionPossiblyNotRecordedAccessor = new NoMethodData(this, this.config.dataLayoutNoTag, TriState.UNKNOWN);
            this.noDataSize = this.cellIndexToOffset(0);
            this.bitDataSize = this.cellIndexToOffset(0);
            this.bitDataNullSeenFlag = 1 << this.config.bitDataNullSeenFlag;
            this.counterDataSize = this.cellIndexToOffset(1);
            this.counterDataCountOffset = this.cellIndexToOffset(this.config.methodDataCountOffset);
            this.jumpDataSize = this.cellIndexToOffset(2);
            this.takenCountOffset = this.cellIndexToOffset(this.config.jumpDataTakenOffset);
            this.takenDisplacementOffset = this.cellIndexToOffset(this.config.jumpDataDisplacementOffset);
            this.typeDataRowSize = this.cellsToBytes(this.config.receiverTypeDataReceiverTypeRowCellCount);
            this.nonprofiledCountOffset = this.cellIndexToOffset(this.config.receiverTypeDataNonprofiledCountOffset);
            this.typeDataFirstTypeOffset = this.cellIndexToOffset(this.config.receiverTypeDataReceiver0Offset);
            this.typeDataFirstTypeCountOffset = this.cellIndexToOffset(this.config.receiverTypeDataCount0Offset);
            this.typeCheckDataSize = this.cellIndexToOffset(2) + this.typeDataRowSize * this.config.typeProfileWidth;
            this.virtualCallDataSize = this.cellIndexToOffset(2) + this.typeDataRowSize * (this.config.typeProfileWidth + this.config.methodProfileWidth);
            this.virtualCallDataFirstMethodOffset = this.typeDataFirstTypeOffset + this.typeDataRowSize * this.config.typeProfileWidth;
            this.virtualCallDataFirstMethodCountOffset = this.typeDataFirstTypeCountOffset + this.typeDataRowSize * this.config.typeProfileWidth;
            this.retDataRowSize = this.cellsToBytes(3);
            this.retDataSize = this.cellIndexToOffset(1) + this.retDataRowSize * this.config.bciProfileWidth;
            this.branchDataSize = this.cellIndexToOffset(3);
            this.notTakenCountOffset = this.cellIndexToOffset(this.config.branchDataNotTakenOffset);
            this.arrayDataLengthOffset = this.cellIndexToOffset(this.config.arrayDataArrayLenOffset);
            this.arrayDataStartOffset = this.cellIndexToOffset(this.config.arrayDataArrayStartOffset);
            this.multiBranchDataSize = this.cellIndexToOffset(1);
            this.multiBranchDataRowSizeInCells = this.config.multiBranchDataPerCaseCellCount;
            this.multiBranchDataRowSize = this.cellsToBytes(this.multiBranchDataRowSizeInCells);
            this.multiBranchDataFirstCountOffset = this.arrayDataStartOffset + this.cellsToBytes(0);
            this.multiBranchDataFirstDisplacementOffset = this.arrayDataStartOffset + this.cellsToBytes(1);
            this.argInfoDataSize = this.cellIndexToOffset(1);
            this.profileDataAccessors = new HotSpotMethodDataAccessor[]{null, new BitData(this, this.config.dataLayoutBitDataTag), new CounterData(this, this.config.dataLayoutCounterDataTag), new JumpData(this, this.config.dataLayoutJumpDataTag), new ReceiverTypeData(this, this.config.dataLayoutReceiverTypeDataTag), new VirtualCallData(this, this.config.dataLayoutVirtualCallDataTag), new RetData(this, this.config.dataLayoutRetDataTag), new BranchData(this, this.config.dataLayoutBranchDataTag), new MultiBranchData(this, this.config.dataLayoutMultiBranchDataTag), new ArgInfoData(this, this.config.dataLayoutArgInfoDataTag), new UnknownProfileData(this, this.config.dataLayoutCallTypeDataTag), new VirtualCallTypeData(this, this.config.dataLayoutVirtualCallTypeDataTag), new UnknownProfileData(this, this.config.dataLayoutParametersTypeDataTag), new UnknownProfileData(this, this.config.dataLayoutSpeculativeTrapDataTag)};
            assert (this.checkAccessorTags());
        }

        private static int truncateLongToInt(long value) {
            return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
        }

        private int computeFullOffset(int position, int offsetInBytes) {
            return this.config.methodDataOopDataOffset + position + offsetInBytes;
        }

        private int cellIndexToOffset(int cells) {
            return this.config.dataLayoutHeaderSize + this.cellsToBytes(cells);
        }

        private int cellsToBytes(int cells) {
            return cells * this.config.dataLayoutCellSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static VMState instance() {
            VMState result = instance;
            if (result != null) return result;
            Class<VMState> clazz = VMState.class;
            synchronized (VMState.class) {
                result = instance;
                if (result != null) return result;
                instance = result = new VMState();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }
    }
}

