/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.MetaspaceObject;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.VMConstant;

final class HotSpotMetaspaceConstantImpl
implements HotSpotMetaspaceConstant,
VMConstant {
    private final MetaspaceObject metaspaceObject;
    private final boolean compressed;

    static HotSpotMetaspaceConstantImpl forMetaspaceObject(MetaspaceObject metaspaceObject, boolean compressed) {
        return new HotSpotMetaspaceConstantImpl(metaspaceObject, compressed);
    }

    static MetaspaceObject getMetaspaceObject(Constant constant) {
        return ((HotSpotMetaspaceConstantImpl)constant).metaspaceObject;
    }

    private HotSpotMetaspaceConstantImpl(MetaspaceObject metaspaceObject, boolean compressed) {
        this.metaspaceObject = metaspaceObject;
        this.compressed = compressed;
    }

    public int hashCode() {
        return System.identityHashCode(this.metaspaceObject) ^ (this.compressed ? 1 : 2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotSpotMetaspaceConstantImpl)) {
            return false;
        }
        HotSpotMetaspaceConstantImpl other = (HotSpotMetaspaceConstantImpl)o;
        return Objects.equals(this.metaspaceObject, other.metaspaceObject) && this.compressed == other.compressed;
    }

    public String toValueString() {
        return String.format("meta{%s%s}", this.metaspaceObject, this.compressed ? ";compressed" : "");
    }

    public String toString() {
        return this.toValueString();
    }

    public boolean isDefaultForKind() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public Constant compress() {
        assert (!this.isCompressed());
        HotSpotMetaspaceConstantImpl res = HotSpotMetaspaceConstantImpl.forMetaspaceObject(this.metaspaceObject, true);
        assert (res.isCompressed());
        return res;
    }

    @Override
    public Constant uncompress() {
        assert (this.isCompressed());
        HotSpotMetaspaceConstantImpl res = HotSpotMetaspaceConstantImpl.forMetaspaceObject(this.metaspaceObject, false);
        assert (!res.isCompressed());
        return res;
    }

    @Override
    public HotSpotResolvedObjectType asResolvedJavaType() {
        if (this.metaspaceObject instanceof HotSpotResolvedObjectType) {
            return (HotSpotResolvedObjectType)((Object)this.metaspaceObject);
        }
        return null;
    }

    @Override
    public HotSpotResolvedJavaMethod asResolvedJavaMethod() {
        if (this.metaspaceObject instanceof HotSpotResolvedJavaMethod) {
            return (HotSpotResolvedJavaMethod)((Object)this.metaspaceObject);
        }
        return null;
    }
}

