/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompilationRequestResult;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.runtime.JVMCICompiler;
import jdk.vm.ci.runtime.JVMCICompilerFactory;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.JVMCIServiceLocator;
import jdk.vm.ci.services.Services;

final class HotSpotJVMCICompilerConfig {
    @NativeImageReinitialize
    private static JVMCICompilerFactory compilerFactory;

    HotSpotJVMCICompilerConfig() {
    }

    static JVMCICompilerFactory getCompilerFactory() {
        if (compilerFactory == null) {
            JVMCICompilerFactory factory = null;
            String compilerName = HotSpotJVMCIRuntime.Option.Compiler.getString();
            if (compilerName != null) {
                if (compilerName.isEmpty() || compilerName.equals("null")) {
                    factory = new DummyCompilerFactory("Value of " + HotSpotJVMCIRuntime.Option.Compiler.getPropertyName() + " property is \"" + compilerName + "\" which denotes the null JVMCI compiler.");
                } else {
                    for (JVMCICompilerFactory f : HotSpotJVMCICompilerConfig.getJVMCICompilerFactories()) {
                        if (!f.getCompilerName().equals(compilerName)) continue;
                        factory = f;
                    }
                    if (factory == null) {
                        throw new JVMCIError("JVMCI compiler \"%s\" not found", new Object[]{compilerName});
                    }
                }
            } else {
                ArrayList<String> multiple = null;
                for (JVMCICompilerFactory f : HotSpotJVMCICompilerConfig.getJVMCICompilerFactories()) {
                    if (multiple != null) {
                        multiple.add(f.getCompilerName());
                        continue;
                    }
                    if (factory == null) {
                        factory = f;
                        continue;
                    }
                    multiple = new ArrayList<String>();
                    multiple.add(f.getCompilerName());
                    multiple.add(factory.getCompilerName());
                    factory = null;
                }
                if (multiple != null) {
                    factory = new DummyCompilerFactory("Multiple providers of " + JVMCICompilerFactory.class + " available: " + String.join((CharSequence)", ", multiple) + ". You can select one of these with the " + HotSpotJVMCIRuntime.Option.Compiler.getPropertyName() + " property (e.g., -D" + HotSpotJVMCIRuntime.Option.Compiler.getPropertyName() + "=" + (String)multiple.get(0) + ").");
                } else if (factory == null) {
                    Path jvmciDir = Paths.get(Services.getSavedProperty((String)"java.home"), "lib", "jvmci");
                    factory = new DummyCompilerFactory("No providers of " + JVMCICompilerFactory.class + " found in " + jvmciDir + " or on the class path specified by the jvmci.class.path.append property.");
                }
            }
            factory.onSelection();
            compilerFactory = factory;
        }
        return compilerFactory;
    }

    private static List<JVMCICompilerFactory> getJVMCICompilerFactories() {
        return JVMCIServiceLocator.getProviders(JVMCICompilerFactory.class);
    }

    private static class DummyCompilerFactory
    implements JVMCICompilerFactory,
    JVMCICompiler {
        private final String reason;

        DummyCompilerFactory(String reason) {
            this.reason = reason;
        }

        public CompilationRequestResult compileMethod(CompilationRequest request) {
            throw new JVMCIError("No JVMCI compiler selected. " + this.reason);
        }

        public String getCompilerName() {
            return "null";
        }

        public JVMCICompiler createCompiler(JVMCIRuntime runtime) {
            return this;
        }
    }
}

