/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Objects;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMemoryAccessProviderImpl;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstantImpl;
import jdk.vm.ci.hotspot.HotSpotMethodHandleAccessProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.MetaspaceObject;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HotSpotConstantReflectionProvider
implements ConstantReflectionProvider {
    protected final HotSpotJVMCIRuntime runtime;
    protected final HotSpotMethodHandleAccessProvider methodHandleAccess;
    private final HotSpotMemoryAccessProviderImpl memoryAccess;

    public HotSpotConstantReflectionProvider(HotSpotJVMCIRuntime runtime) {
        this.runtime = runtime;
        this.methodHandleAccess = new HotSpotMethodHandleAccessProvider(this);
        this.memoryAccess = new HotSpotMemoryAccessProviderImpl(runtime);
    }

    public MethodHandleAccessProvider getMethodHandleAccess() {
        return this.methodHandleAccess;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return this.memoryAccess;
    }

    public Boolean constantEquals(Constant x, Constant y) {
        if (x == y) {
            return true;
        }
        if (x instanceof HotSpotObjectConstantImpl) {
            return y instanceof HotSpotObjectConstantImpl && x.equals(y);
        }
        return Objects.equals(x, y);
    }

    public Integer readArrayLength(JavaConstant array) {
        if (array == null || array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        HotSpotObjectConstantImpl arrayObject = (HotSpotObjectConstantImpl)array;
        return this.runtime.getReflection().getLength(arrayObject);
    }

    public JavaConstant readArrayElement(JavaConstant array, int index) {
        if (array == null || array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        HotSpotObjectConstantImpl arrayObject = (HotSpotObjectConstantImpl)array;
        return this.runtime.getReflection().readArrayElement(arrayObject, index);
    }

    private static boolean isBoxCached(JavaConstant source) {
        switch (source.getJavaKind()) {
            case Boolean: {
                return true;
            }
            case Char: {
                return source.asInt() <= 127;
            }
            case Byte: 
            case Short: 
            case Int: {
                return source.asInt() >= -128 && source.asInt() <= 127;
            }
            case Long: {
                return source.asLong() >= -128L && source.asLong() <= 127L;
            }
            case Float: 
            case Double: {
                return false;
            }
        }
        throw new IllegalArgumentException("unexpected kind " + source.getJavaKind());
    }

    public JavaConstant boxPrimitive(JavaConstant source) {
        if (source == null || !source.getJavaKind().isPrimitive() || !HotSpotConstantReflectionProvider.isBoxCached(source)) {
            return null;
        }
        return this.runtime.getReflection().boxPrimitive(source);
    }

    public JavaConstant unboxPrimitive(JavaConstant source) {
        if (source == null || !source.getJavaKind().isObject()) {
            return null;
        }
        if (source.isNull()) {
            return null;
        }
        return this.runtime.getReflection().unboxPrimitive((HotSpotObjectConstantImpl)source);
    }

    public JavaConstant forString(String value) {
        return this.runtime.getReflection().forObject(value);
    }

    public JavaConstant forObject(Object value) {
        return this.runtime.getReflection().forObject(value);
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        MetaspaceObject obj;
        if (constant instanceof HotSpotObjectConstantImpl) {
            return ((HotSpotObjectConstantImpl)constant).asJavaType();
        }
        if (constant instanceof HotSpotMetaspaceConstant && (obj = HotSpotMetaspaceConstantImpl.getMetaspaceObject(constant)) instanceof HotSpotResolvedObjectTypeImpl) {
            return (ResolvedJavaType)obj;
        }
        return null;
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        HotSpotResolvedJavaField hotspotField = (HotSpotResolvedJavaField)field;
        if (hotspotField.isStatic()) {
            HotSpotResolvedObjectTypeImpl holder = (HotSpotResolvedObjectTypeImpl)hotspotField.getDeclaringClass();
            if (holder.isInitialized()) {
                return holder.readFieldValue(hotspotField, field.isVolatile());
            }
        } else if (receiver.isNonNull() && receiver instanceof HotSpotObjectConstantImpl) {
            HotSpotObjectConstantImpl object = (HotSpotObjectConstantImpl)receiver;
            if (hotspotField.isInObject(receiver)) {
                return object.readFieldValue(hotspotField, field.isVolatile());
            }
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return ((HotSpotResolvedJavaType)type).getJavaMirror();
    }

    public Constant asObjectHub(ResolvedJavaType type) {
        if (type instanceof HotSpotResolvedObjectType) {
            return ((HotSpotResolvedObjectType)type).klass();
        }
        throw JVMCIError.unimplemented();
    }
}

