/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSTypedArrayObject.class)
final class JSTypedArrayObjectGen {
    private JSTypedArrayObjectGen() {
    }

    static {
        LibraryExport.register(JSTypedArrayObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSTypedArrayObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSTypedArrayObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSTypedArrayObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSTypedArrayObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSTypedArrayObject.class)
        private static final class Uncached
        extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSTypedArrayObject)((Object)receiver)).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSTypedArrayObject)((Object)receiver)).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSTypedArrayObject)((Object)receiver)).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                return arg0Value.readArrayElement(arg1Value, this.javaScriptLanguageReference_, JSObject.getUncachedRead(), ExportValueNode.getUncached(), this);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                return arg0Value.isArrayElementReadable(arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                return arg0Value.isArrayElementReadable(arg1Value, this);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                arg0Value.writeArrayElement(arg1Value, arg2Value, ImportValueNodeGen.getUncached(), this.javaScriptLanguageReference_, JSObject.getUncachedWrite(), this);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSTypedArrayObject)((Object)receiver)).isArrayElementInsertable(index);
            }
        }

        @GeneratedBy(value=JSTypedArrayObject.class)
        private static final class Cached
        extends JSNonProxyObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @Node.Child
            private ReadElementNode readArrayElementNode__readNode_;
            @Node.Child
            private ExportValueNode readArrayElementNode__exportNode_;
            @Node.Child
            private ImportValueNode writeArrayElementNode__castValueNode_;
            @Node.Child
            private WriteElementNode writeArrayElementNode__writeNode_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSTypedArrayObject)((Object)receiver)).getMembers(includeInternal);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSTypedArrayObject)((Object)receiver)).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSTypedArrayObject)((Object)receiver)).getArraySize();
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    Cached readArrayElementNode__thisLibrary__ = this;
                    return arg0Value.readArrayElement(arg1Value, readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.readArrayElementNode__exportNode_, readArrayElementNode__thisLibrary__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(JSTypedArrayObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    Cached readArrayElementNode__thisLibrary__ = null;
                    TruffleLanguage.LanguageReference readArrayElementNode__languageRef__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    readArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.readArrayElementNode__readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)readArrayElementNode__languageRef__.get()).getJSContext()));
                    this.readArrayElementNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    readArrayElementNode__thisLibrary__ = this;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readArrayElement(arg1Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.readArrayElementNode__exportNode_, readArrayElementNode__thisLibrary__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                Cached isArrayElementReadableNode__thisLibrary__ = this;
                return arg0Value.isArrayElementReadable(arg1Value, isArrayElementReadableNode__thisLibrary__);
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                Cached isArrayElementReadableNode__thisLibrary__ = this;
                return arg0Value.isArrayElementReadable(arg1Value, isArrayElementReadableNode__thisLibrary__);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSTypedArrayObject arg0Value = (JSTypedArrayObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    Cached writeArrayElementNode__thisLibrary__ = this;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, this.writeArrayElementNode__castValueNode_, writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_, writeArrayElementNode__thisLibrary__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(JSTypedArrayObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    Cached writeArrayElementNode__thisLibrary__ = null;
                    TruffleLanguage.LanguageReference writeArrayElementNode__languageRef__ = null;
                    this.writeArrayElementNode__castValueNode_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    writeArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.writeArrayElementNode__writeNode_ = (WriteElementNode)super.insert((Node)WriteElementNode.createCachedInterop((TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeArrayElementNode__languageRef__));
                    writeArrayElementNode__thisLibrary__ = this;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, this.writeArrayElementNode__castValueNode_, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_, writeArrayElementNode__thisLibrary__);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSTypedArrayObject)((Object)receiver)).isArrayElementInsertable(index);
            }
        }
    }
}

