/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSFunctionObject.class)
public final class JSFunctionObjectGen {
    private JSFunctionObjectGen() {
    }

    static {
        LibraryExport.register(JSFunctionObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSFunctionObject.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSFunctionObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSFunctionObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSFunctionObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSFunctionObject.class)
        public static class Uncached
        extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                return arg0Value.isExecutable(IsCallableNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                return arg0Value.execute(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).isInstantiable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                return arg0Value.instantiate(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), JSInteropInstantiateNodeGen.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).hasSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).getSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).isMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).getMetaObjectName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).getMetaObjectName();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSFunctionObject)((Object)receiver)).isMetaInstance(instance);
            }
        }

        @GeneratedBy(value=JSFunctionObject.class)
        public static class Cached
        extends JSNonProxyObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private ExportValueNode exportValue;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @Node.Child
            private IsCallableNode isExecutableNode__isCallable_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private JSInteropInstantiateNode instantiateNode__callNode_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    return arg0Value.isExecutable(this.isExecutableNode__isCallable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableNode_AndSpecialize(JSFunctionObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.isExecutableNode__isCallable_ = (IsCallableNode)super.insert((Node)IsCallableNode.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isExecutable(this.isExecutableNode__isCallable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    return arg0Value.execute(arg1Value, executeNode__language__, this.executeNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(JSFunctionObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JavaScriptLanguage executeNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    this.executeNode__callNode_ = (JSInteropExecuteNode)super.insert((Node)JSInteropExecuteNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.execute(arg1Value, executeNode__language__, this.executeNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).isInstantiable();
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSFunctionObject arg0Value = (JSFunctionObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage instantiateNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    return arg0Value.instantiate(arg1Value, instantiateNode__language__, this.instantiateNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(JSFunctionObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JavaScriptLanguage instantiateNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    instantiateNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    this.instantiateNode__callNode_ = (JSInteropInstantiateNode)super.insert((Node)JSInteropInstantiateNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.instantiate(arg1Value, instantiateNode__language__, this.instantiateNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).hasSourceLocation();
            }

            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).getSourceLocation();
            }

            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).isMetaObject();
            }

            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).getMetaObjectName();
            }

            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).getMetaObjectName();
            }

            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSFunctionObject)((Object)receiver)).isMetaInstance(instance);
            }
        }
    }
}

