/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.intl.InitializeLocaleNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InitializeLocaleNode.class)
public final class InitializeLocaleNodeGen
extends InitializeLocaleNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private JSToStringNode initializeLocaleUsingObject_toStringNode_;

    private InitializeLocaleNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public DynamicObject executeInit(DynamicObject arg0Value, Object arg1Value, Object arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xF) != 0) {
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arg1Value)) {
                String arg1Value_ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arg1Value);
                return this.initializeLocaleUsingString(arg0Value, arg1Value_, arg2Value);
            }
            if ((state_0 & 6) != 0 && JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                if ((state_0 & 2) != 0 && JSGuards.isJSLocale(arg1Value_)) {
                    return this.initializeLocaleUsingLocale(arg0Value, arg1Value_, arg2Value);
                }
                if ((state_0 & 4) != 0 && JSGuards.isJSObject(arg1Value_) && !JSGuards.isJSLocale(arg1Value_)) {
                    return this.initializeLocaleUsingObject(arg0Value, arg1Value_, arg2Value, this.initializeLocaleUsingObject_toStringNode_);
                }
            }
            if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arg1Value) && !JSGuards.isString(arg1Value)) {
                return this.initializeLocaleOther(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private DynamicObject executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, Object arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            int stringCast1 = JSTypesGen.specializeImplicitString(arg1Value);
            if (stringCast1 != 0) {
                String arg1Value_ = JSTypesGen.asImplicitString(stringCast1, arg1Value);
                state_0 |= stringCast1 << 4;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.initializeLocaleUsingString(arg0Value, arg1Value_, arg2Value);
                return dynamicObject;
            }
            if (JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                if (JSGuards.isJSLocale(arg1Value_)) {
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.initializeLocaleUsingLocale(arg0Value, arg1Value_, arg2Value);
                    return dynamicObject;
                }
                if (JSGuards.isJSObject(arg1Value_) && !JSGuards.isJSLocale(arg1Value_)) {
                    this.initializeLocaleUsingObject_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.initializeLocaleUsingObject(arg0Value, arg1Value_, arg2Value, this.initializeLocaleUsingObject_toStringNode_);
                    return dynamicObject;
                }
            }
            if (!JSGuards.isJSObject(arg1Value) && !JSGuards.isString(arg1Value)) {
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.initializeLocaleOther(arg0Value, arg1Value, arg2Value);
                return dynamicObject;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "initializeLocaleUsingString";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "initializeLocaleUsingLocale";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "initializeLocaleUsingObject";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
            cached.add(Arrays.asList(this.initializeLocaleUsingObject_toStringNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "initializeLocaleOther";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static InitializeLocaleNode create(JSContext context) {
        return new InitializeLocaleNodeGen(context);
    }
}

