/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.event.ProfilingStateEvent;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.openide.util.Lookup;

public abstract class ProfilerFeature {
    public abstract Icon getIcon();

    public abstract String getName();

    public abstract String getDescription();

    public abstract int getPosition();

    public abstract JPanel getResultsUI();

    public abstract JPanel getSettingsUI();

    public abstract ProfilerToolbar getToolbar();

    public abstract boolean supportsSettings(ProfilingSettings var1);

    public abstract void configureSettings(ProfilingSettings var1);

    public abstract boolean currentSettingsValid();

    public abstract boolean supportsConfiguration(Lookup var1);

    public abstract void configure(Lookup var1);

    protected void activatedInSession() {
    }

    protected void deactivatedInSession() {
    }

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public static final class Registry {
        private static boolean HAS_PROVIDERS;

        private Registry() {
        }

        public static boolean hasProviders() {
            return HAS_PROVIDERS;
        }

        static Collection<? extends Provider> getProviders() {
            Collection providers = Lookup.getDefault().lookupAll(Provider.class);
            HAS_PROVIDERS = !providers.isEmpty();
            return providers;
        }
    }

    public static abstract class Provider {
        public abstract ProfilerFeature getFeature(ProfilerSession var1);
    }

    public static abstract class Basic
    extends ProfilerFeature {
        private Set<ChangeListener> listeners;
        private final Icon icon;
        private final String name;
        private final String description;
        private final int position;
        private final ProfilerSession session;
        private volatile boolean isActive;
        private ProfilingStateListener listener;

        public Basic(Icon icon, String name, String description, int position, ProfilerSession session) {
            this.icon = icon;
            this.name = name;
            this.description = description;
            this.position = position;
            this.session = session;
        }

        @Override
        public final Icon getIcon() {
            return this.icon;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        @Override
        public final int getPosition() {
            return this.position;
        }

        protected final ProfilerSession getSession() {
            return this.session;
        }

        @Override
        public JPanel getSettingsUI() {
            return null;
        }

        @Override
        public boolean supportsSettings(ProfilingSettings settings) {
            return true;
        }

        @Override
        public boolean currentSettingsValid() {
            return true;
        }

        @Override
        public ProfilerToolbar getToolbar() {
            return null;
        }

        @Override
        public boolean supportsConfiguration(Lookup configuration) {
            return false;
        }

        @Override
        public void configure(Lookup configuration) {
        }

        protected void notifyActivated() {
        }

        protected void notifyDeactivated() {
        }

        protected final boolean isActivated() {
            return this.isActive;
        }

        @Override
        protected final void activatedInSession() {
            this.isActive = true;
            this.notifyActivated();
            this.session.addListener(this.getListener());
            final int state = this.session.getState();
            Runnable notifier = new Runnable(){

                @Override
                public void run() {
                    Basic.this.profilingStateChanged(-1, state);
                }
            };
            UIUtils.runInEventDispatchThread((Runnable)notifier);
        }

        @Override
        protected final void deactivatedInSession() {
            this.isActive = false;
            this.notifyDeactivated();
            this.session.removeListener(this.getListener());
            this.listener = null;
            boolean state = true;
            Runnable notifier = new Runnable(){

                @Override
                public void run() {
                    Basic.this.profilingStateChanged(-1, 1);
                }
            };
            UIUtils.runInEventDispatchThread((Runnable)notifier);
        }

        protected final int getSessionState() {
            return this.isActive ? this.session.getState() : 1;
        }

        protected final String readFlag(String flag, String defaultValue) {
            String id = this.getClass().getName();
            return this.session.getStorage().readFlag(id + "_" + flag, defaultValue);
        }

        protected final void storeFlag(String flag, String value) {
            String id = this.getClass().getName();
            this.session.getStorage().storeFlag(id + "_" + flag, value);
        }

        private ProfilingStateListener getListener() {
            if (this.listener == null) {
                this.listener = new ProfilingStateListener(){

                    public void serverStateChanged(int serverState, int serverProgress) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.serverStateChanged(serverState, serverProgress);
                    }

                    public void instrumentationChanged(int oldType, int newType) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.instrumentationChanged(oldType, newType);
                    }

                    public void profilingStateChanged(ProfilingStateEvent e) {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.profilingStateChanged(e.getOldState(), e.getNewState());
                    }

                    public void threadsMonitoringChanged() {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.threadsMonitoringChanged();
                    }

                    public void lockContentionMonitoringChanged() {
                        if (!Basic.this.isActive) {
                            return;
                        }
                        Basic.this.lockContentionMonitoringChanged();
                    }
                };
            }
            return this.listener;
        }

        protected void serverStateChanged(int serverState, int serverProgress) {
        }

        protected void instrumentationChanged(int oldType, int newType) {
        }

        protected void profilingStateChanged(int oldState, int newState) {
        }

        protected void threadsMonitoringChanged() {
        }

        protected void lockContentionMonitoringChanged() {
        }

        @Override
        public final synchronized void addChangeListener(ChangeListener listener) {
            if (this.listeners == null) {
                this.listeners = new HashSet<ChangeListener>();
            }
            this.listeners.add(listener);
        }

        @Override
        public final synchronized void removeChangeListener(ChangeListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        protected final synchronized void fireChange() {
            if (this.listeners == null) {
                return;
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(e);
            }
        }
    }
}

