/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.graalvm.home.HomeFinder;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.RuntimeOptions;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;

public abstract class Launcher {
    private static final boolean STATIC_VERBOSE = Boolean.getBoolean("org.graalvm.launcher.verbose");
    private static final boolean SHELL_SCRIPT_LAUNCHER = Boolean.getBoolean("org.graalvm.launcher.shell");
    public static final int LAUNCHER_OPTIONS_INDENT = 45;
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    final Native nativeAccess;
    private final boolean verbose;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private boolean help;
    private boolean helpInternal;
    private boolean helpExpert;
    private boolean helpVM;
    private Path logFile;
    private int optionIndent = 45;
    private List<String> kindAndCategory = new ArrayList<String>();
    private Path home;
    private static final String CLASSPATH = System.getProperty("org.graalvm.launcher.classpath");

    protected Launcher() {
        this.verbose = STATIC_VERBOSE || Boolean.parseBoolean(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
        this.nativeAccess = IS_AOT ? new Native() : null;
    }

    protected final Path getLogFile() {
        return this.logFile;
    }

    protected final void setOutput(PrintStream ps) {
        this.out = ps;
    }

    protected final void setError(PrintStream ps) {
        this.err = ps;
    }

    protected final PrintStream getOutput() {
        return this.out;
    }

    protected final PrintStream getError() {
        return this.err;
    }

    void handleAbortException(AbortException e) {
        if (e.getMessage() != null) {
            this.err.println("ERROR: " + e.getMessage());
        }
        if (e.getCause() != null) {
            e.printStackTrace();
        }
        System.exit(e.getExitCode());
    }

    protected final AbortException exit() {
        return this.exit(0);
    }

    protected final AbortException exit(int exitCode) {
        return this.abort((String)null, exitCode);
    }

    protected final AbortException abort(String message) {
        return this.abort(message, 1);
    }

    protected final AbortException abort(String message, int exitCode) {
        throw new AbortException(message, exitCode);
    }

    protected final AbortException abort(Throwable t) {
        return this.abort(t, 255);
    }

    protected final AbortException abort(Throwable t, int exitCode) {
        if (t.getCause() instanceof IOException && t.getClass() == RuntimeException.class) {
            String message = t.getMessage();
            if (message != null && !message.startsWith(t.getCause().getClass().getName() + ": ")) {
                this.err.println(message);
            }
            throw this.abort((IOException)t.getCause(), exitCode);
        }
        throw new AbortException(t, exitCode);
    }

    protected final AbortException abort(IOException e) {
        return this.abort(e, 74);
    }

    protected final AbortException abort(IOException e, int exitCode) {
        String message = e.getMessage();
        if (message != null) {
            if (e instanceof NoSuchFileException) {
                throw this.abort("Not such file: " + message, exitCode);
            }
            if (e instanceof AccessDeniedException) {
                throw this.abort("Access denied: " + message, exitCode);
            }
            throw this.abort(message + " (" + e.getClass().getSimpleName() + ")", exitCode);
        }
        throw this.abort((Throwable)e, exitCode);
    }

    protected AbortException abortUnrecognizedArgument(String argument) {
        throw this.abortInvalidArgument(argument, "Unrecognized argument: '" + argument + "'. Use --help for usage instructions.");
    }

    protected final AbortException abortInvalidArgument(String argument, String message) {
        return this.abortInvalidArgument(argument, message, 2);
    }

    protected final AbortException abortInvalidArgument(String argument, String message, int exitCode) {
        List<String> matches;
        Set<String> allArguments = this.collectAllArguments();
        String testString = argument;
        int equalIndex = argument.indexOf(61);
        if (equalIndex != -1) {
            testString = argument.substring(0, equalIndex);
        }
        if ((matches = Launcher.fuzzyMatch(allArguments, testString, 0.7f)).isEmpty()) {
            matches = Launcher.fuzzyMatch(allArguments, testString, 0.5f);
        }
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        if (!matches.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append("Did you mean one of the following arguments?").append(System.lineSeparator());
            Iterator<String> iterator = matches.iterator();
            while (true) {
                String match = iterator.next();
                sb.append("  ").append(match);
                if (!iterator.hasNext()) break;
                sb.append(System.lineSeparator());
            }
        }
        if (sb.length() > 0) {
            throw this.abort(sb.toString(), exitCode);
        }
        throw this.exit(exitCode);
    }

    protected void warn(String message) {
        this.err.println("Warning: " + message);
    }

    protected void warn(String message, Object ... args) {
        StringBuilder sb = new StringBuilder("Warning: ");
        new Formatter(sb).format(message, args);
        sb.append(System.lineSeparator());
        this.err.print(sb.toString());
    }

    protected final void setOptionIndent(int indent) {
        this.optionIndent = indent < 0 ? 45 : indent;
    }

    protected abstract void printHelp(OptionCategory var1);

    protected abstract void printVersion();

    protected abstract void collectArguments(Set<String> var1);

    protected abstract OptionDescriptor findOptionDescriptor(String var1, String var2);

    protected boolean canPolyglot() {
        return !this.isStandalone();
    }

    protected void maybePrintAdditionalHelp(OptionCategory helpCategory) {
    }

    private String[] executableNames(String basename) {
        switch (OS.current) {
            case Linux: 
            case Darwin: 
            case Solaris: {
                return new String[]{basename};
            }
            case Windows: {
                return new String[]{basename + ".exe", basename + ".cmd"};
            }
        }
        throw this.abort("executableName: OS not supported: " + (Object)((Object)OS.current));
    }

    protected String getMainClass() {
        return this.getClass().getName();
    }

    protected VMType getDefaultVMType() {
        return VMType.Native;
    }

    public static boolean isAOT() {
        return IS_AOT;
    }

    private boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isGraalVMAvailable() {
        return this.getGraalVMHome() != null;
    }

    protected boolean isStandalone() {
        return !this.isGraalVMAvailable();
    }

    private OptionCategory getHelpCategory() {
        if (this.helpInternal) {
            return OptionCategory.INTERNAL;
        }
        if (this.helpExpert) {
            return OptionCategory.EXPERT;
        }
        return OptionCategory.USER;
    }

    protected Path getGraalVMHome() {
        if (this.home == null) {
            this.home = HomeFinder.getInstance().getHomeFolder();
        }
        return this.home;
    }

    protected final Path getGraalVMBinaryPath(String binaryName) {
        String[] executableNames = this.executableNames(binaryName);
        Path graalVMHome = this.getGraalVMHome();
        if (graalVMHome == null) {
            throw this.abort("Cannot exec to GraalVM binary: could not find GraalVM home");
        }
        for (String executableName : executableNames) {
            Path[] execPaths;
            for (Path execPath : execPaths = new Path[]{graalVMHome.resolve("bin").resolve(executableName), graalVMHome.resolve("jre").resolve("bin").resolve(executableName)}) {
                if (!Files.exists(execPath, new LinkOption[0])) continue;
                return execPath;
            }
        }
        throw this.abort("Cannot exec to GraalVM binary: could not find a '" + binaryName + "' executable");
    }

    protected boolean runLauncherAction() {
        boolean printDefaultHelp = this.help || (this.helpExpert || this.helpInternal) && this.kindAndCategory.isEmpty() && !this.helpVM;
        OptionCategory hc = this.getHelpCategory();
        if (printDefaultHelp) {
            this.printDefaultHelp(hc);
        }
        this.maybePrintAdditionalHelp(hc);
        if (this.helpVM) {
            if (this.nativeAccess == null) {
                this.printJvmHelp();
            } else {
                this.nativeAccess.printNativeHelp();
            }
        }
        return this.printAllOtherHelpCategories(printDefaultHelp);
    }

    protected void printDefaultHelp(OptionCategory printCategory) {
        VMType defaultVMType = SHELL_SCRIPT_LAUNCHER ? VMType.JVM : this.getDefaultVMType();
        this.printHelp(printCategory);
        this.out.println();
        this.out.println("Runtime options:");
        this.setOptionIndent(45);
        if (this.canPolyglot()) {
            this.launcherOption("--polyglot", "Run with all other guest languages accessible.");
        }
        if (!SHELL_SCRIPT_LAUNCHER) {
            this.launcherOption("--native", "Run using the native launcher with limited access to Java libraries" + (defaultVMType == VMType.Native ? " (default)" : "") + ".");
        }
        if (!this.isStandalone()) {
            this.launcherOption("--jvm", "Run on the Java Virtual Machine with access to Java libraries" + (defaultVMType == VMType.JVM ? " (default)" : "") + ".");
        }
        this.launcherOption("--vm.[option]", "Pass options to the host VM. To see available options, use '--help:vm'.");
        this.launcherOption("--log.file=<String>", "Redirect guest languages logging into a given file.");
        this.launcherOption("--log.[logger].level=<String>", "Set language log level to OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST or ALL.");
        this.launcherOption("--help", "Print this help message.");
        this.launcherOption("--help:vm", "Print options for the host VM.");
    }

    protected void printOtherHelpCategory(String kind, String option) {
        this.kindAndCategory.add(kind);
        this.kindAndCategory.add(option);
    }

    private boolean printAllOtherHelpCategories(boolean printHelp) {
        boolean print;
        boolean bl = print = printHelp || this.helpVM || !this.kindAndCategory.isEmpty();
        if (!print) {
            return false;
        }
        this.out.println();
        Iterator<String> it = this.kindAndCategory.iterator();
        while (it.hasNext()) {
            String kind = it.next();
            String opt = it.next();
            this.printOtherHelpCategories0(kind, opt);
        }
        this.out.println("See http://www.graalvm.org for more information.");
        return true;
    }

    private void printOtherHelpCategories0(String kind, String option) {
        if (this.helpExpert || this.helpInternal) {
            this.out.println("Use '" + option + "' to list user " + kind + " options.");
        }
        if (!this.helpExpert) {
            this.out.println("Use '" + option + " --help:expert' to list expert " + kind + " options.");
        }
        if (!this.helpInternal) {
            this.out.println("Use '" + option + " --help:internal' to list internal " + kind + " options.");
        }
    }

    static String optionsTitle(String kind, OptionCategory optionCategory) {
        String category;
        switch (optionCategory) {
            case USER: {
                category = "User ";
                break;
            }
            case EXPERT: {
                category = "Expert ";
                break;
            }
            case INTERNAL: {
                category = "Internal ";
                break;
            }
            default: {
                category = "";
            }
        }
        return category + kind + " options:";
    }

    protected final void parseUnrecognizedOptions(String defaultOptionPrefix, Map<String, String> polyglotOptions, List<String> unrecognizedArgs) {
        boolean experimentalOptions = false;
        Iterator<String> iterator = unrecognizedArgs.iterator();
        while (iterator.hasNext()) {
            String arg;
            switch (arg = iterator.next()) {
                case "--experimental-options": 
                case "--experimental-options=true": {
                    experimentalOptions = true;
                    break;
                }
                case "--experimental-options=false": {
                    experimentalOptions = false;
                }
            }
        }
        for (String arg : unrecognizedArgs) {
            if (this.parseCommonOption(defaultOptionPrefix, polyglotOptions, experimentalOptions, arg)) continue;
            this.parsePolyglotOption(defaultOptionPrefix, polyglotOptions, experimentalOptions, arg);
        }
    }

    protected boolean parseCommonOption(String defaultOptionPrefix, Map<String, String> polyglotOptions, boolean experimentalOptions, String arg) {
        switch (arg) {
            case "--help": {
                this.help = true;
                break;
            }
            case "--help:debug": {
                this.warn("--help:debug is deprecated, use --help:internal instead.");
                this.helpInternal = true;
                break;
            }
            case "--help:internal": {
                this.helpInternal = true;
                break;
            }
            case "--help:expert": {
                this.helpExpert = true;
                break;
            }
            case "--help:vm": {
                this.helpVM = true;
                break;
            }
            case "--experimental-options": 
            case "--experimental-options=true": 
            case "--experimental-options=false": {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void parsePolyglotOption(String defaultOptionPrefix, Map<String, String> polyglotOptions, boolean experimentalOptions, String arg) {
        OptionDescriptor descriptor;
        String value;
        String key;
        if (arg.equals("--jvm")) {
            if (Launcher.isAOT()) {
                throw this.abort("should not reach here: jvm option failed to switch to JVM");
            }
            return;
        }
        if (arg.equals("--native")) {
            if (!Launcher.isAOT()) {
                throw this.abort("native options are not supported on the JVM");
            }
            return;
        }
        if (arg.startsWith("--vm.") && arg.length() > "--vm.".length()) {
            return;
        }
        if (arg.length() <= 2 || !arg.startsWith("--")) {
            throw this.abortUnrecognizedArgument(arg);
        }
        int eqIdx = arg.indexOf(61);
        if (eqIdx < 0) {
            key = arg.substring(2);
            value = null;
        } else {
            key = arg.substring(2, eqIdx);
            value = arg.substring(eqIdx + 1);
        }
        if (value == null) {
            value = "true";
        }
        int index = key.indexOf(46);
        String group = key;
        if (index >= 0) {
            group = group.substring(0, index);
        }
        if ("log".equals(group)) {
            if (key.endsWith(".level")) {
                try {
                    Level.parse(value);
                    polyglotOptions.put(key, value);
                }
                catch (IllegalArgumentException e) {
                    throw this.abort(String.format("Invalid log level %s specified. %s'", arg, e.getMessage()));
                }
                return;
            }
            if (key.equals("log.file")) {
                this.logFile = Paths.get(value, new String[0]);
                return;
            }
        }
        if ((descriptor = this.findOptionDescriptor(group, key)) == null) {
            if (defaultOptionPrefix != null) {
                descriptor = this.findOptionDescriptor(defaultOptionPrefix, defaultOptionPrefix + "." + key);
            }
            if (descriptor == null) {
                throw this.abortUnrecognizedArgument(arg);
            }
        }
        try {
            descriptor.getKey().getType().convert(value);
        }
        catch (IllegalArgumentException e) {
            throw this.abort(String.format("Invalid argument %s specified. %s'", arg, e.getMessage()));
        }
        if (descriptor.isDeprecated()) {
            String messageFormat = "Option '%s' is deprecated and might be removed from future versions.";
            String deprecationMessage = descriptor.getDeprecationMessage();
            String message = deprecationMessage != null ? String.format(messageFormat + "%n%s", descriptor.getName(), deprecationMessage) : String.format(messageFormat, descriptor.getName());
            this.warn(message);
        }
        if (!experimentalOptions && descriptor.getStability() == OptionStability.EXPERIMENTAL) {
            throw this.abort(String.format("Option '%s' is experimental and must be enabled via '--experimental-options'%nDo not use experimental options in production environments.", arg));
        }
        polyglotOptions.put(descriptor.getName(), value);
    }

    private Set<String> collectAllArguments() {
        LinkedHashSet<String> options = new LinkedHashSet<String>();
        this.collectArguments(options);
        if (this.canPolyglot()) {
            options.add("--polyglot");
        }
        if (!this.isStandalone()) {
            options.add("--jvm");
        }
        options.add("--native");
        options.add("--help");
        options.add("--help:expert");
        options.add("--help:internal");
        options.add("--help:vm");
        return options;
    }

    private static List<String> fuzzyMatch(Set<String> arguments, String argument, float threshold) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String arg : arguments) {
            float score = Launcher.stringSimilarity(arg, argument);
            if (!(score >= threshold)) continue;
            matches.add(arg);
        }
        return matches;
    }

    private static float stringSimilarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i = 0; i < str1.length() - 1; ++i) {
            for (int j = 0; j < str2.length() - 1; ++j) {
                if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }

    protected void launcherOption(String option, String description) {
        this.printOption(option, description, 2, this.optionIndent);
    }

    private static String spaces(int length) {
        return new String(new char[length]).replace('\u0000', ' ');
    }

    private static String wrap(String s) {
        int width = 120;
        StringBuilder sb = new StringBuilder(s);
        int cursor = 0;
        while (cursor + 120 < sb.length()) {
            int i = sb.lastIndexOf(" ", cursor + 120);
            if (i == -1 || i < cursor) {
                i = sb.indexOf(" ", cursor + 120);
            }
            if (i == -1) break;
            sb.replace(i, i + 1, System.lineSeparator());
            cursor = i;
        }
        return sb.toString();
    }

    private void printOption(String option, String description, int indentStart, int optionWidth) {
        String indent = Launcher.spaces(indentStart);
        String desc = Launcher.wrap(description != null ? description : "");
        String nl = System.lineSeparator();
        String[] descLines = desc.split(nl);
        if (option.length() >= optionWidth && description != null) {
            this.out.println(indent + option + nl + indent + Launcher.spaces(optionWidth) + descLines[0]);
        } else {
            this.out.println(indent + option + Launcher.spaces(optionWidth - option.length()) + descLines[0]);
        }
        for (int i = 1; i < descLines.length; ++i) {
            this.out.println(indent + Launcher.spaces(optionWidth) + descLines[i]);
        }
    }

    void printOption(PrintableOption option) {
        this.printOption(option, 2);
    }

    void printOption(PrintableOption option, int indentation) {
        this.printOption(option.option, option.description, indentation, this.optionIndent);
    }

    void printOptions(List<PrintableOption> options, String title, int indentation) {
        Collections.sort(options);
        this.out.println(title);
        for (PrintableOption option : options) {
            this.printOption(option, indentation);
        }
    }

    protected final void println(String l) {
        this.out.println(l);
    }

    protected final void println(String ... lines) {
        for (String l : lines) {
            this.out.println(l);
        }
    }

    private void printJvmHelp() {
        this.println("JVM options:");
        String classpathHelp = "Manage the classpath for Java libraries that you can access from guest languages ('" + File.pathSeparator + "' separated list)";
        this.launcherOption("--vm.classpath=<path>[" + File.pathSeparator + "path...]", classpathHelp);
        this.launcherOption("--vm.cp=<path>[" + File.pathSeparator + "path...]", classpathHelp);
        this.launcherOption("--vm.D<name>=<value>", "Set a system property");
        this.launcherOption("--vm.esa", "Enable system assertions");
        this.launcherOption("--vm.ea[:<packagename>...|:<classname>]", "Enable assertions with specified granularity");
        this.launcherOption("--vm.agentlib:<libname>[=<options>]", "Load native agent library <libname>");
        this.launcherOption("--vm.agentpath:<pathname>[=<options>]", "Load native agent library by full pathname");
        this.launcherOption("--vm.javaagent:<jarpath>[=<options>]", "Load Java programming language agent");
        this.launcherOption("--vm.Xbootclasspath/a:<path>[" + File.pathSeparator + "path...]", "Append classpath entries to the JVM's boot classpath ('" + File.pathSeparator + "' separated list)");
        this.launcherOption("--vm.Xmx<size>", "Set maximum Java heap size");
        this.launcherOption("--vm.Xms<size>", "Set initial Java heap size");
        this.launcherOption("--vm.Xss<size>", "Set java thread stack size");
    }

    private void printBasicNativeHelp() {
        this.launcherOption("--vm.D<property>=<value>", "Sets a system property");
        this.launcherOption("--vm.Xmn<value>", "Sets the maximum size of the young generation, in bytes. Default: 256MB.");
        this.launcherOption("--vm.Xmx<value>", "Sets the maximum size of the heap, in bytes. Default: MaximumHeapSizePercent * physical memory.");
        this.launcherOption("--vm.Xms<value>", "Sets the minimum size of the heap, in bytes. Default: 2 * maximum young generation size.");
        this.launcherOption("--vm.Xss<value>", "Sets the size of each thread stack, in bytes. Default: OS-dependent.");
    }

    @Deprecated
    protected final void maybeNativeExec(List<String> args, boolean isPolyglotLauncher, Map<String, String> polyglotOptions) {
        this.maybeNativeExec(args, args, isPolyglotLauncher);
    }

    protected final void maybeNativeExec(List<String> originalArgs, List<String> unrecognizedArgs, boolean isPolyglotLauncher) {
        if (!IS_AOT) {
            return;
        }
        this.maybeExec(originalArgs, unrecognizedArgs, isPolyglotLauncher, this.getDefaultVMType());
    }

    void maybeExec(List<String> originalArgs, List<String> unrecognizedArgs, boolean isPolyglotLauncher, VMType defaultVmType) {
        assert (Launcher.isAOT());
        VMType vmType = null;
        boolean polyglot = false;
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> applicationArgs = new ArrayList<String>(originalArgs);
        Iterator<String> iterator = unrecognizedArgs.iterator();
        ArrayList<String> vmOptions = new ArrayList<String>();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.equals("--jvm")) {
                if (vmType == VMType.Native) {
                    throw this.abort("'--jvm' and '--native' options can not be used together.");
                }
                if (this.isStandalone()) {
                    throw this.abort("'--jvm' is only supported when this launcher is part of a GraalVM.");
                }
                vmType = VMType.JVM;
                iterator.remove();
                continue;
            }
            if (arg.equals("--native")) {
                if (vmType == VMType.JVM) {
                    throw this.abort("'--jvm' and '--native' options can not be used together.");
                }
                vmType = VMType.Native;
                iterator.remove();
                continue;
            }
            if (arg.startsWith("--vm.") && arg.length() > "--vm.".length()) {
                String vmArg = arg.substring("--vm.".length());
                if (vmArg.equals("classpath")) {
                    throw this.abort("'--vm.classpath' argument must be of the form '--vm.classpath=<classpath>', not two separate arguments");
                }
                if (vmArg.equals("cp")) {
                    throw this.abort("'--vm.cp' argument must be of the form '--vm.cp=<classpath>', not two separate arguments");
                }
                if (vmArg.startsWith("classpath=") || vmArg.startsWith("cp=")) {
                    int eqIndex = vmArg.indexOf(61);
                    jvmArgs.add('-' + vmArg.substring(0, eqIndex));
                    jvmArgs.add(vmArg.substring(eqIndex + 1));
                } else {
                    vmOptions.add(vmArg);
                }
                iterator.remove();
                continue;
            }
            if (!arg.equals("--polyglot")) continue;
            polyglot = true;
        }
        boolean isDefaultVMType = false;
        if (vmType == null) {
            vmType = defaultVmType;
            isDefaultVMType = true;
        }
        if (vmType == VMType.JVM) {
            for (String vmOption : vmOptions) {
                jvmArgs.add('-' + vmOption);
            }
            if (!isPolyglotLauncher && polyglot) {
                applicationArgs.add(0, "--polyglot");
            }
            assert (!this.isStandalone());
            this.executeJVM(this.nativeAccess == null ? System.getProperty("java.class.path") : this.nativeAccess.getClasspath(jvmArgs), jvmArgs, applicationArgs, Collections.emptyMap());
        } else {
            assert (vmType == VMType.Native);
            for (String vmOption : vmOptions) {
                this.nativeAccess.setNativeOption(vmOption);
            }
            VMRuntime.initialize();
            if (!isPolyglotLauncher && polyglot) {
                assert (jvmArgs.isEmpty());
                if (this.isStandalone()) {
                    throw this.abort("--polyglot option is only supported when this launcher is part of a GraalVM.");
                }
                this.executePolyglot(applicationArgs, Collections.emptyMap(), !isDefaultVMType);
            }
        }
    }

    @Deprecated
    protected void executeJVM(String classpath, List<String> jvmArgs, List<String> remainingArgs, Map<String, String> polyglotOptions) {
        this.executeJVM(classpath, jvmArgs, remainingArgs);
    }

    protected void executeJVM(String classpath, List<String> jvmArgs, List<String> remainingArgs) {
        this.nativeAccess.execJVM(classpath, jvmArgs, remainingArgs);
    }

    @Deprecated
    protected void executePolyglot(List<String> mainArgs, Map<String, String> polyglotOptions, boolean forceNative) {
        this.executePolyglot(mainArgs, forceNative);
    }

    protected void executePolyglot(List<String> mainArgs, boolean forceNative) {
        this.nativeAccess.executePolyglot(mainArgs, forceNative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OutputStream newLogStream(Path path) throws IOException {
        Path usedPath = path;
        Path lockFile = null;
        FileChannel lockFileChannel = null;
        int unique = 0;
        while (true) {
            StringBuilder lockFileNameBuilder = new StringBuilder();
            lockFileNameBuilder.append(path.toString());
            if (unique > 0) {
                lockFileNameBuilder.append(unique);
                usedPath = Paths.get(lockFileNameBuilder.toString(), new String[0]);
            }
            lockFileNameBuilder.append(".lck");
            lockFile = Paths.get(lockFileNameBuilder.toString(), new String[0]);
            Map.Entry<FileChannel, Boolean> openResult = Launcher.openChannel(lockFile);
            if (openResult != null) {
                lockFileChannel = openResult.getKey();
                if (Launcher.lock(lockFileChannel, openResult.getValue())) break;
                lockFileChannel.close();
            }
            ++unique;
        }
        assert (lockFile != null && lockFileChannel != null);
        boolean success = false;
        try {
            LockableOutputStream stream = new LockableOutputStream(new BufferedOutputStream(Files.newOutputStream(usedPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND)), lockFile, lockFileChannel);
            success = true;
            LockableOutputStream lockableOutputStream = stream;
            return lockableOutputStream;
        }
        finally {
            if (!success) {
                LockableOutputStream.unlock(lockFile, lockFileChannel);
            }
        }
    }

    private static Map.Entry<FileChannel, Boolean> openChannel(Path path) throws IOException {
        FileChannel channel = null;
        for (int retries = 0; channel == null && retries < 2; ++retries) {
            try {
                channel = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                return new AbstractMap.SimpleImmutableEntry<FileChannel, Boolean>(channel, true);
            }
            catch (FileAlreadyExistsException faee) {
                if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS) && Launcher.isParentWritable(path)) {
                    try {
                        channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                        return new AbstractMap.SimpleImmutableEntry<FileChannel, Boolean>(channel, false);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        continue;
                    }
                    catch (IOException x) {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isParentWritable(Path path) {
        Path parentPath = path.getParent();
        if (parentPath == null && !path.isAbsolute()) {
            parentPath = path.toAbsolutePath().getParent();
        }
        return parentPath != null && Files.isWritable(parentPath);
    }

    private static boolean lock(FileChannel lockFileChannel, boolean newFile) {
        boolean available = false;
        try {
            available = lockFileChannel.tryLock() != null;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
        }
        catch (IOException ioe) {
            available = newFile;
        }
        return available;
    }

    private static final class LockableOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private final Path lockFile;
        private final FileChannel lockFileChannel;

        LockableOutputStream(OutputStream delegate, Path lockFile, FileChannel lockFileChannel) {
            this.delegate = delegate;
            this.lockFile = lockFile;
            this.lockFileChannel = lockFileChannel;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                LockableOutputStream.unlock(this.lockFile, this.lockFileChannel);
            }
        }

        private static void unlock(Path lockFile, FileChannel lockFileChannel) {
            try {
                lockFileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Files.delete(lockFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class ShellQuotes {
        private static final BitSet safeChars = new BitSet();

        private ShellQuotes() {
        }

        private static String quote(String str) {
            if (str.isEmpty()) {
                return "''";
            }
            for (int i = 0; i < str.length(); ++i) {
                if (safeChars.get(str.charAt(i))) continue;
                return "'" + str.replace("'", "'\"'\"'") + "'";
            }
            return str;
        }

        static {
            safeChars.set(97, 123);
            safeChars.set(65, 91);
            safeChars.set(43, 59);
            safeChars.set(64);
            safeChars.set(37);
            safeChars.set(95);
            safeChars.set(61);
        }
    }

    class Native {
        private WeakReference<OptionDescriptors> compilerOptionDescriptors;
        private WeakReference<OptionDescriptors> vmOptionDescriptors;

        Native() {
        }

        private OptionDescriptors getCompilerOptions() {
            OptionDescriptors descriptors = null;
            if (this.compilerOptionDescriptors != null) {
                descriptors = (OptionDescriptors)this.compilerOptionDescriptors.get();
            }
            if (descriptors == null) {
                descriptors = RuntimeOptions.getOptions(EnumSet.of(RuntimeOptions.OptionClass.Compiler));
                this.compilerOptionDescriptors = new WeakReference<OptionDescriptors>(descriptors);
            }
            return descriptors;
        }

        private OptionDescriptors getVMOptions() {
            OptionDescriptors descriptors = null;
            if (this.vmOptionDescriptors != null) {
                descriptors = (OptionDescriptors)this.vmOptionDescriptors.get();
            }
            if (descriptors == null) {
                descriptors = RuntimeOptions.getOptions(EnumSet.of(RuntimeOptions.OptionClass.VM));
                this.vmOptionDescriptors = new WeakReference<OptionDescriptors>(descriptors);
            }
            return descriptors;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setNativeOption(String arg) {
            if (arg.startsWith("Dgraal.")) {
                this.setGraalStyleRuntimeOption(arg.substring("Dgraal.".length()));
                return;
            } else if (arg.startsWith("D")) {
                this.setSystemProperty(arg.substring("D".length()));
                return;
            } else if (arg.startsWith("XX:")) {
                this.setRuntimeOption(arg.substring("XX:".length()));
                return;
            } else {
                if (!arg.startsWith("X")) throw Launcher.this.abort("Unrecognized vm option: '--vm." + arg + "'. Such arguments should start with '--vm.D', '--vm.XX:', or '--vm.X'");
                if (!this.isXOption(arg)) throw Launcher.this.abort("Unrecognized vm option: '--vm." + arg + "'. Some VM options may be only supported in --jvm mode.");
                this.setXOption(arg.substring("X".length()));
            }
        }

        private void setGraalStyleRuntimeOption(String arg) {
            String value;
            String key;
            if (arg.startsWith("+") || arg.startsWith("-")) {
                throw Launcher.this.abort("Dgraal option must use <name>=<value> format, not +/- prefix");
            }
            int eqIdx = arg.indexOf(61);
            if (eqIdx < 0) {
                key = arg;
                value = "";
            } else {
                key = arg.substring(0, eqIdx);
                value = arg.substring(eqIdx + 1);
            }
            OptionDescriptor descriptor = this.getCompilerOptions().get(key);
            if (descriptor == null && (descriptor = this.getVMOptions().get(key)) != null) {
                if (this.isBooleanOption(descriptor)) {
                    Launcher.this.warn("VM options such as '%s' should be set with '--vm.XX:\u00b1%<s'.%nSupport for setting them with '--vm.Dgraal.%<s=<value>' is deprecated and will be removed.%n", key);
                } else {
                    Launcher.this.warn("VM options such as '%s' should be set with '--vm.XX:%<s=<value>'.%nSupport for setting them with '--vm.Dgraal.%<s=<value>' is deprecated and will be removed.%n", key);
                }
            }
            if (descriptor == null) {
                throw this.unknownOption(key);
            }
            try {
                RuntimeOptions.set((String)key, (Object)descriptor.getKey().getType().convert(value));
            }
            catch (IllegalArgumentException iae) {
                throw Launcher.this.abort("Invalid argument: '--vm." + arg + "': " + iae.getMessage());
            }
        }

        public void setSystemProperty(String arg) {
            String value;
            String key;
            int eqIdx = arg.indexOf(61);
            if (eqIdx < 0) {
                key = arg;
                value = "";
            } else {
                key = arg.substring(0, eqIdx);
                value = arg.substring(eqIdx + 1);
            }
            System.setProperty(key, value);
        }

        public void setRuntimeOption(String arg) {
            Object value;
            String key;
            int eqIdx = arg.indexOf(61);
            if (arg.startsWith("+") || arg.startsWith("-")) {
                key = arg.substring(1);
                if (eqIdx >= 0) {
                    throw Launcher.this.abort("Invalid argument: '--vm." + arg + "': Use either +/- or =, but not both");
                }
                OptionDescriptor descriptor = this.getVMOptionDescriptor(key);
                if (!this.isBooleanOption(descriptor)) {
                    throw Launcher.this.abort("Invalid argument: " + key + " is not a boolean option, set it with --vm.XX:" + key + "=<value>.");
                }
                value = arg.startsWith("+");
            } else if (eqIdx > 0) {
                key = arg.substring(0, eqIdx);
                OptionDescriptor descriptor = this.getVMOptionDescriptor(key);
                if (this.isBooleanOption(descriptor)) {
                    throw Launcher.this.abort("Boolean option '" + key + "' must be set with +/- prefix, not <name>=<value> format.");
                }
                try {
                    value = descriptor.getKey().getType().convert(arg.substring(eqIdx + 1));
                }
                catch (IllegalArgumentException iae) {
                    throw Launcher.this.abort("Invalid argument: '--vm." + arg + "': " + iae.getMessage());
                }
            } else {
                throw Launcher.this.abort("Invalid argument: '--vm." + arg + "'. Prefix boolean options with + or -, suffix other options with <name>=<value>");
            }
            RuntimeOptions.set((String)key, (Object)value);
        }

        private OptionDescriptor getVMOptionDescriptor(String key) {
            OptionDescriptor descriptor = this.getVMOptions().get(key);
            if (descriptor == null && (descriptor = this.getCompilerOptions().get(key)) != null) {
                Launcher.this.warn("compiler options such as '%s' should be set with '--vm.Dgraal.%<s=<value>'.%nSupport for setting them with '--vm.XX:...' is deprecated and will be removed.%n", key);
            }
            if (descriptor == null) {
                throw this.unknownOption(key);
            }
            return descriptor;
        }

        private boolean isXOption(String arg) {
            return arg.startsWith("Xmn") || arg.startsWith("Xms") || arg.startsWith("Xmx") || arg.startsWith("Xss");
        }

        private void setXOption(String arg) {
            try {
                RuntimeOptions.set((String)arg, null);
            }
            catch (RuntimeException re) {
                throw Launcher.this.abort("Invalid argument: '--vm.X" + arg + "' does not specify a valid number.");
            }
        }

        private boolean isBooleanOption(OptionDescriptor descriptor) {
            return descriptor.getKey().getType().equals(OptionType.defaultType(Boolean.class));
        }

        private AbortException unknownOption(String key) {
            throw Launcher.this.abort("Unknown native option: " + key + ". Use --help:vm to list available options.");
        }

        private void printNativeHelp() {
            System.out.println("Native VM options:");
            TreeMap<String, OptionDescriptor> sortedOptions = new TreeMap<String, OptionDescriptor>();
            for (OptionDescriptor descriptor : this.getVMOptions()) {
                if (descriptor.isDeprecated()) continue;
                sortedOptions.put(descriptor.getName(), descriptor);
            }
            for (Map.Entry entry : sortedOptions.entrySet()) {
                OptionDescriptor descriptor = (OptionDescriptor)entry.getValue();
                String helpMsg = descriptor.getHelp();
                if (this.isBooleanOption(descriptor)) {
                    Boolean val = (Boolean)descriptor.getKey().getDefaultValue();
                    if (helpMsg.length() != 0) {
                        helpMsg = helpMsg + ' ';
                    }
                    helpMsg = val == null || val == false ? helpMsg + "Default: - (disabled)." : helpMsg + "Default: + (enabled).";
                    Launcher.this.launcherOption("--vm.XX:\u00b1" + (String)entry.getKey(), helpMsg);
                    continue;
                }
                Object def = descriptor.getKey().getDefaultValue();
                if (def instanceof String) {
                    def = "\"" + def + "\"";
                }
                Launcher.this.launcherOption("--vm.XX:" + (String)entry.getKey() + "=" + def, helpMsg);
            }
            this.printCompilerOptions();
            Launcher.this.printBasicNativeHelp();
        }

        private void printCompilerOptions() {
            System.out.println("Compiler options:");
            TreeMap<String, OptionDescriptor> sortedOptions = new TreeMap<String, OptionDescriptor>();
            for (OptionDescriptor descriptor : this.getCompilerOptions()) {
                if (descriptor.isDeprecated()) continue;
                sortedOptions.put(descriptor.getName(), descriptor);
            }
            for (Map.Entry entry : sortedOptions.entrySet()) {
                OptionDescriptor descriptor = (OptionDescriptor)entry.getValue();
                String helpMsg = descriptor.getHelp();
                Object def = descriptor.getKey().getDefaultValue();
                if (def instanceof String) {
                    def = '\"' + (String)def + '\"';
                }
                Launcher.this.launcherOption("--vm.Dgraal." + (String)entry.getKey() + "=" + def, helpMsg);
            }
        }

        private void executePolyglot(List<String> args, boolean forceNative) {
            ArrayList<String> command = new ArrayList<String>(args.size() + 3);
            Path executable = Launcher.this.getGraalVMBinaryPath("polyglot");
            if (forceNative) {
                command.add("--native");
            }
            command.add("--use-launcher");
            command.add(Launcher.this.getMainClass());
            command.addAll(args);
            this.exec(executable, command);
        }

        private void execJVM(String classpath, List<String> jvmArgs, List<String> args) {
            ArrayList<String> command = new ArrayList<String>(jvmArgs.size() + args.size() + 4);
            Path executable = Launcher.this.getGraalVMBinaryPath("java");
            if (classpath != null) {
                command.add("-classpath");
                command.add(classpath);
            }
            command.addAll(jvmArgs);
            command.add(Launcher.this.getMainClass());
            command.addAll(args);
            this.exec(executable, command);
        }

        private String getClasspath(List<String> jvmArgs) {
            assert (Launcher.isAOT());
            assert (CLASSPATH != null);
            StringBuilder sb = new StringBuilder();
            if (!CLASSPATH.isEmpty()) {
                Path graalVMHome = Launcher.this.getGraalVMHome();
                if (graalVMHome == null) {
                    throw Launcher.this.abort("Can not resolve classpath: could not get GraalVM home");
                }
                for (String entry : CLASSPATH.split(File.pathSeparator)) {
                    Path resolved = graalVMHome.resolve(entry);
                    if (Launcher.this.isVerbose() && !Files.exists(resolved, new LinkOption[0])) {
                        Launcher.this.warn("%s does not exist", resolved);
                    }
                    sb.append(resolved);
                    sb.append(File.pathSeparatorChar);
                }
            }
            String classpathFromArgs = null;
            Iterator<String> iterator = jvmArgs.iterator();
            while (iterator.hasNext()) {
                String jvmArg = iterator.next();
                if ((jvmArg.equals("-cp") || jvmArg.equals("-classpath")) && iterator.hasNext()) {
                    iterator.remove();
                    classpathFromArgs = iterator.next();
                    iterator.remove();
                }
                if (!jvmArg.startsWith("-Djava.class.path=")) continue;
                iterator.remove();
                classpathFromArgs = jvmArg.substring("-Djava.class.path=".length());
            }
            if (classpathFromArgs != null) {
                sb.append(classpathFromArgs);
                sb.append(File.pathSeparatorChar);
            }
            if (sb.length() == 0) {
                return null;
            }
            return sb.substring(0, sb.length() - 1);
        }

        private void exec(Path executable, List<String> command) {
            assert (Launcher.isAOT());
            if (Launcher.this.isVerbose()) {
                StringBuilder sb = this.formatExec(executable, command);
                Launcher.this.err.print(sb.toString());
            }
            String[] argv = new String[command.size() + 1];
            int i = 0;
            Path filename = executable.getFileName();
            if (filename == null) {
                throw Launcher.this.abort(String.format("Cannot determine execute filename from path %s", filename));
            }
            argv[i++] = filename.toString();
            for (String arg : command) {
                argv[i++] = arg;
            }
            ProcessProperties.exec((Path)executable, (String[])argv);
        }

        private StringBuilder formatExec(Path executable, List<String> command) {
            StringBuilder sb = new StringBuilder("exec: ");
            sb.append(executable);
            for (String arg : command) {
                sb.append(' ');
                sb.append(ShellQuotes.quote(arg));
            }
            sb.append(System.lineSeparator());
            return sb;
        }
    }

    protected static enum OS {
        Darwin,
        Linux,
        Solaris,
        Windows;

        private static final OS current;

        private static OS findCurrent() {
            String name = System.getProperty("os.name");
            if (name.equals("Linux")) {
                return Linux;
            }
            if (name.equals("SunOS")) {
                return Solaris;
            }
            if (name.equals("Mac OS X") || name.equals("Darwin")) {
                return Darwin;
            }
            if (name.startsWith("Windows")) {
                return Windows;
            }
            throw new IllegalArgumentException("unknown OS: " + name);
        }

        public static OS getCurrent() {
            return current;
        }

        static {
            current = OS.findCurrent();
        }
    }

    static final class PrintableOption
    implements Comparable<PrintableOption> {
        final String option;
        final String description;

        protected PrintableOption(String option, String description) {
            this.option = option;
            this.description = description;
        }

        @Override
        public int compareTo(PrintableOption o) {
            return this.option.compareTo(o.option);
        }
    }

    protected static final class AbortException
    extends RuntimeException {
        static final long serialVersionUID = 4681646279864737876L;
        private final int exitCode;

        AbortException(String message, int exitCode) {
            super(message);
            this.exitCode = exitCode;
        }

        AbortException(Throwable cause, int exitCode) {
            super(null, cause);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    protected static enum VersionAction {
        None,
        PrintAndExit,
        PrintAndContinue;

    }

    public static enum VMType {
        Native,
        JVM;

    }
}

