/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty.jline;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

public final class JLine3Feature
implements Feature {
    public static final String TERMINAL_BUILDER = "org.graalvm.shadowed.org.jline.terminal.TerminalBuilder";
    private static final List<String> RESOURCES = Arrays.asList("capabilities.txt", "colors.txt", "ansi.caps", "dumb.caps", "dumb-color.caps", "screen.caps", "screen-256color.caps", "windows.caps", "windows-256color.caps", "windows-conemu.caps", "windows-vtp.caps", "xterm.caps", "xterm-256color.caps");
    private static final String RESOURCE_PATH = "org/graalvm/shadowed/org/jline/utils/";
    private static final List<String> JNI_CLASS_NAMES = Arrays.asList("org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary", "org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary$WinSize", "org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary$Termios", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$SMALL_RECT", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$COORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$CONSOLE_SCREEN_BUFFER_INFO", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$CHAR_INFO", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$KEY_EVENT_RECORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$MOUSE_EVENT_RECORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$WINDOW_BUFFER_SIZE_RECORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$FOCUS_EVENT_RECORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$MENU_EVENT_RECORD", "org.graalvm.shadowed.org.fusesource.jansi.internal.Kernel32$INPUT_RECORD");
    private static final List<String> RUNTIME_INIT_CLASS_NAMES = Arrays.asList("org.graalvm.shadowed.org.fusesource.jansi.AnsiConsole", "org.graalvm.shadowed.org.fusesource.jansi.WindowsAnsiOutputStream", "org.graalvm.shadowed.org.fusesource.jansi.WindowsAnsiProcessor", "org.graalvm.shadowed.org.jline.terminal.impl.jna.win.JnaWinSysTerminal", "org.graalvm.shadowed.org.jline.terminal.impl.jansi.win.WindowsAnsiWriter", "org.graalvm.shadowed.org.jline.terminal.impl.jansi.win.JansiWinConsoleWriter", "org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary", "org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary$Termios", "org.graalvm.shadowed.org.fusesource.jansi.internal.CLibrary$WinSize");
    private AtomicBoolean resourceRegistered = new AtomicBoolean();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName(TERMINAL_BUILDER) != null;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        Stream.concat(JNI_CLASS_NAMES.stream(), RUNTIME_INIT_CLASS_NAMES.stream()).map(arg_0 -> ((Feature.DuringSetupAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JNI_CLASS_NAMES.stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).map(jniClass -> ReflectionUtil.lookupMethod((Class)jniClass, (String)"init", (Class[])new Class[0])).forEach(initMethod -> access.registerReachabilityHandler(a -> this.registerJNIFields((Method)initMethod), new Object[]{initMethod}));
        for (String resource : RESOURCES) {
            String resourcePath = RESOURCE_PATH + resource;
            InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(resourcePath);
            Resources.registerResource((String)resourcePath, (InputStream)resourceAsStream);
        }
    }

    private void registerJNIFields(Method initMethod) {
        Class<?> jniClass = initMethod.getDeclaringClass();
        JNIRuntimeAccess.register((Field[])jniClass.getDeclaredFields());
        if (!this.resourceRegistered.getAndSet(true)) {
            String resource = "META-INF/native/windows64/jansi.dll";
            Resources.registerResource((String)resource, (InputStream)jniClass.getClassLoader().getResourceAsStream(resource));
        }
    }
}

