/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class ExportMessageData
extends MessageContainer {
    private final ExportsLibrary exports;
    private final LibraryMessage resolvedMessage;
    private final Element element;
    private final AnnotationMirror annotation;
    private NodeData specializedNode;
    private boolean overriden;
    private boolean abstractImpl;

    ExportMessageData(ExportsLibrary exports, LibraryMessage resolvedMessage, Element element, AnnotationMirror annotation) {
        this.exports = exports;
        this.resolvedMessage = resolvedMessage;
        this.element = element;
        this.annotation = annotation;
    }

    public boolean isAbstract() {
        return this.abstractImpl;
    }

    public void setAbstract(boolean abstractImpl) {
        this.abstractImpl = abstractImpl;
    }

    public void setOverriden(boolean overriden) {
        this.overriden = overriden;
    }

    public boolean isOverriden() {
        return this.overriden;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<MessageContainer> children = new ArrayList<MessageContainer>();
        if (this.specializedNode != null) {
            children.add(this.specializedNode);
        }
        return children;
    }

    public LibraryMessage getResolvedMessage() {
        return this.resolvedMessage;
    }

    public ExportsLibrary getExportsLibrary() {
        return this.exports;
    }

    public boolean isClass() {
        return this.element == null ? false : this.element.getKind().isClass();
    }

    public boolean isMethod() {
        return !this.isClass();
    }

    public TypeMirror getReceiverType() {
        if (this.element == null || this.exports.isExplicitReceiver()) {
            return this.exports.getReceiverType();
        }
        if (this.element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)this.element;
            if (this.element.getModifiers().contains((Object)Modifier.STATIC)) {
                return method.getParameters().get(0).asType();
            }
            return method.getEnclosingElement().asType();
        }
        if (this.element instanceof TypeElement) {
            return this.element.getEnclosingElement().asType();
        }
        throw new AssertionError((Object)this.element.getClass().getName());
    }

    public boolean isDeclared() {
        if (this.getElement() == null) {
            return true;
        }
        return ElementUtils.elementEquals(this.getElement().getEnclosingElement(), this.exports.getDeclaringType());
    }

    public Element getElement() {
        return this.element;
    }

    public void setSpecializedNode(NodeData specializedNode) {
        this.specializedNode = specializedNode;
    }

    public NodeData getSpecializedNode() {
        return this.specializedNode;
    }

    @Override
    public Element getMessageElement() {
        return this.element;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.annotation;
    }

    public boolean isGenerated() {
        return this.element instanceof GeneratedElement;
    }

    public String toString() {
        return "ExportMessageData [element=" + this.element + ", exports=" + this.exports + ", message=" + this.resolvedMessage + "]";
    }
}

