/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.compiler.AbstractCompiler;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class GeneratedCompiler
extends AbstractCompiler {
    public static boolean isValidElement(Element currentElement) {
        return currentElement instanceof CodeElement;
    }

    @Override
    public List<? extends Element> getEnclosedElementsInDeclarationOrder(TypeElement type) {
        return ((CodeTypeElement)type).getEnclosedElements();
    }

    @Override
    public List<? extends Element> getAllMembersInDeclarationOrder(ProcessingEnvironment environment, TypeElement type) {
        ArrayList<? extends Element> elements = new ArrayList<Element>();
        TypeElement currentType = type;
        while (currentType != null) {
            elements.addAll(CompilerFactory.getCompiler(currentType).getEnclosedElementsInDeclarationOrder(currentType));
            TypeMirror superClass = currentType.getSuperclass();
            if (superClass != null && superClass.getKind() == TypeKind.DECLARED) {
                currentType = (TypeElement)((DeclaredType)currentType.getSuperclass()).asElement();
                continue;
            }
            currentType = null;
        }
        return elements;
    }

    @Override
    protected boolean emitDeprecationWarningImpl(ProcessingEnvironment environment, Element element) {
        return false;
    }
}

