/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;

public class TruffleProcessorOptions {
    private static final String OptionsPrefix = "truffle.dsl.";
    private static final String GenerateSpecializationStatisticsOptionName = "GenerateSpecializationStatistics";
    private static final String GenerateSlowPathOnlyOptionName = "GenerateSlowPathOnly";
    private static final String GenerateSlowPathOnlyFilterOptionName = "GenerateSlowPathOnlyFilter";
    private static final String CacheSharingWarningsEnabledOptionName = "cacheSharingWarningsEnabled";
    private static final String StateBitWidth = "StateBitWidth";

    public static Boolean generateSpecializationStatistics(ProcessingEnvironment env) {
        String value = env.getOptions().get("truffle.dsl.GenerateSpecializationStatistics");
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static boolean generateSlowPathOnly(ProcessingEnvironment env) {
        return Boolean.parseBoolean(env.getOptions().get("truffle.dsl.GenerateSlowPathOnly"));
    }

    public static String generateSlowPathOnlyFilter(ProcessingEnvironment env) {
        return env.getOptions().get("truffle.dsl.GenerateSlowPathOnlyFilter");
    }

    public static boolean cacheSharingWarningsEnabled(ProcessingEnvironment env) {
        return Boolean.parseBoolean(env.getOptions().get("truffle.dsl.cacheSharingWarningsEnabled"));
    }

    public static int stateBitWidth(ProcessingEnvironment env) {
        String value = env.getOptions().get("truffle.dsl.StateBitWidth");
        if (value == null) {
            return 32;
        }
        return Integer.parseInt(value);
    }

    public static Set<String> getSupportedOptions() {
        HashSet<String> result = new HashSet<String>();
        result.add("truffle.dsl.GenerateSpecializationStatistics");
        result.add("truffle.dsl.GenerateSlowPathOnly");
        result.add("truffle.dsl.GenerateSlowPathOnlyFilter");
        result.add("truffle.dsl.cacheSharingWarningsEnabled");
        result.add("truffle.dsl.StateBitWidth");
        return result;
    }
}

