/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.graal.isolated.IsolatedSpeculationLog;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCallNode;
import com.oracle.truffle.api.Assumption;
import java.util.function.Supplier;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.WordPointer;

final class IsolatedCompilableTruffleAST
extends IsolatedObjectProxy<SubstrateCompilableTruffleAST>
implements SubstrateCompilableTruffleAST {
    private String cachedName;
    private IsolatedSpeculationLog cachedSpeculationLog;

    IsolatedCompilableTruffleAST(ClientHandle<SubstrateCompilableTruffleAST> compilable) {
        super(compilable);
    }

    public JavaConstant asJavaConstant() {
        return new IsolatedObjectConstant(this.handle, false);
    }

    public SpeculationLog getCompilationSpeculationLog() {
        if (this.cachedSpeculationLog == null) {
            ClientHandle<SpeculationLog> logHandle = IsolatedCompilableTruffleAST.getCompilationSpeculationLog0(IsolatedCompileContext.get().getClient(), this.handle);
            this.cachedSpeculationLog = new IsolatedSpeculationLog(logHandle);
        }
        return this.cachedSpeculationLog;
    }

    public void onCompilationFailed(Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        IsolatedCompilableTruffleAST.onCompilationFailed0(IsolatedCompileContext.get().getClient(), this.handle, IsolatedCompileContext.get().hand(serializedException), silent, bailout, permanentBailout, graphTooBig);
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = IsolatedCompileContext.get().unhand(IsolatedCompilableTruffleAST.getName0(IsolatedCompileContext.get().getClient(), this.handle));
        }
        return this.cachedName;
    }

    public int getNonTrivialNodeCount() {
        return IsolatedCompilableTruffleAST.getNonTrivialNodeCount0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public TruffleCallNode[] getCallNodes() {
        CompilerHandle<IsolatedTruffleCallNode[]> nodes = IsolatedCompilableTruffleAST.getCallNodes0(IsolatedCompileContext.get().getClient(), this.handle);
        return IsolatedCompileContext.get().unhand(nodes);
    }

    public int getCallCount() {
        return IsolatedCompilableTruffleAST.getCallCount0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public boolean cancelCompilation(CharSequence reason) {
        IsolatedCompileContext context = IsolatedCompileContext.get();
        return IsolatedCompilableTruffleAST.cancelCompilation0(context.getClient(), this.handle, context.createStringInClient(reason));
    }

    public void dequeueInlined() {
        IsolatedCompileContext context = IsolatedCompileContext.get();
        IsolatedCompilableTruffleAST.dequeueInlined0(context.getClient(), this.handle);
    }

    public boolean isSameOrSplit(CompilableTruffleAST ast) {
        IsolatedCompilableTruffleAST other = (IsolatedCompilableTruffleAST)ast;
        return IsolatedCompilableTruffleAST.isSameOrSplit0(IsolatedCompileContext.get().getClient(), this.handle, other.handle);
    }

    public int getKnownCallSiteCount() {
        return IsolatedCompilableTruffleAST.getKnownCallSiteCount0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public JavaConstant getNodeRewritingAssumptionConstant() {
        return new IsolatedObjectConstant(IsolatedCompilableTruffleAST.getNodeRewritingAssumption0(IsolatedCompileContext.get().getClient(), this.handle), false);
    }

    public JavaConstant getValidRootAssumptionConstant() {
        return new IsolatedObjectConstant(IsolatedCompilableTruffleAST.getValidRootAssumption0(IsolatedCompileContext.get().getClient(), this.handle), false);
    }

    @Override
    public SubstrateInstalledCode createSubstrateInstalledCode() {
        throw VMError.shouldNotReachHere("Must not be called during isolated compilation");
    }

    @Override
    public InstalledCode createPreliminaryInstalledCode() {
        return new IsolatedCodeInstallBridge(this.handle);
    }

    public boolean isTrivial() {
        return IsolatedCompilableTruffleAST.isTrivial0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<SpeculationLog> getCompilationSpeculationLog0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        SpeculationLog log = compilable.getCompilationSpeculationLog();
        return IsolatedCompileClient.get().hand(log);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onCompilationFailed0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, CompilerHandle<Supplier<String>> serializedExceptionHandle, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        Supplier<String> serializedException = () -> {
            ClientHandle<String> resultHandle = IsolatedCompilableTruffleAST.getReasonAndStackTrace0(IsolatedCompileClient.get().getCompiler(), serializedExceptionHandle);
            return IsolatedCompileClient.get().unhand(resultHandle);
        };
        IsolatedCompileClient.get().unhand(compilableHandle).onCompilationFailed(serializedException, silent, bailout, permanentBailout, graphTooBig);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<String> getReasonAndStackTrace0(CompilerIsolateThread compiler, CompilerHandle<Supplier<String>> reasonAndStackTraceHandle) {
        Supplier<String> supplier = IsolatedCompileContext.get().unhand(reasonAndStackTraceHandle);
        return IsolatedCompileContext.get().createStringInClient(supplier.get());
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<String> getName0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        String name = IsolatedCompileClient.get().unhand(compilableHandle).getName();
        return IsolatedCompileClient.get().createStringInCompiler(name);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int getNonTrivialNodeCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getNonTrivialNodeCount();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<IsolatedTruffleCallNode[]> getCallNodes0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        TruffleCallNode[] nodes = compilable.getCallNodes();
        ClientHandle[] nodeHandles = new ClientHandle[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeHandles[i] = IsolatedCompileClient.get().hand(nodes[i]);
        }
        try (PinnedObject pinnedNodeHandles = PinnedObject.create((Object)nodeHandles);){
            CompilerHandle<IsolatedTruffleCallNode[]> compilerHandle = IsolatedCompilableTruffleAST.getCallNodes1(IsolatedCompileClient.get().getCompiler(), (WordPointer)pinnedNodeHandles.addressOfArrayElement(0), nodeHandles.length);
            return compilerHandle;
        }
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<IsolatedTruffleCallNode[]> getCallNodes1(CompilerIsolateThread compiler, WordPointer nodeHandleArray, int length) {
        IsolatedTruffleCallNode[] nodes = new IsolatedTruffleCallNode[length];
        for (int i = 0; i < nodes.length; ++i) {
            ClientHandle handle = (ClientHandle)nodeHandleArray.read(i);
            nodes[i] = new IsolatedTruffleCallNode(handle);
        }
        return IsolatedCompileContext.get().hand(nodes);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int getCallCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getCallCount();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean cancelCompilation0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<String> reasonHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        SubstrateCompilableTruffleAST compilable = isolatedCompileClient.unhand(compilableHandle);
        String reason = isolatedCompileClient.unhand(reasonHandle);
        return compilable.cancelCompilation(reason);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void dequeueInlined0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        SubstrateCompilableTruffleAST compilable = isolatedCompileClient.unhand(handle);
        compilable.dequeueInlined();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean isSameOrSplit0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<SubstrateCompilableTruffleAST> otherHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        SubstrateCompilableTruffleAST other = IsolatedCompileClient.get().unhand(otherHandle);
        return compilable.isSameOrSplit(other);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int getKnownCallSiteCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getKnownCallSiteCount();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<Assumption> getNodeRewritingAssumption0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        CompilableTruffleAST ast = IsolatedCompileClient.get().unhand(handle);
        JavaConstant assumptionConstant = ast.getNodeRewritingAssumptionConstant();
        Assumption assumption = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)assumptionConstant), Assumption.class);
        return IsolatedCompileClient.get().hand(assumption);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<Assumption> getValidRootAssumption0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        CompilableTruffleAST ast = IsolatedCompileClient.get().unhand(handle);
        JavaConstant assumptionConstant = ast.getValidRootAssumptionConstant();
        Assumption assumption = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)assumptionConstant), Assumption.class);
        return IsolatedCompileClient.get().hand(assumption);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean isTrivial0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        SubstrateCompilableTruffleAST compilable = IsolatedCompileClient.get().unhand(handle);
        return compilable.isTrivial();
    }
}

