/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedRuntimeCodeInstaller;
import com.oracle.svm.graal.isolated.OptionValuesEncoder;
import com.oracle.svm.graal.meta.SubstrateMethod;
import java.lang.reflect.Array;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class IsolatedGraalUtils {
    public static CompilerIsolateThread createCompilationIsolate() {
        Isolates.CreateIsolateParameters.Builder builder = new Isolates.CreateIsolateParameters.Builder();
        long addressSpaceSize = SubstrateOptions.CompilationIsolateAddressSpaceSize.getValue();
        if (addressSpaceSize > 0L) {
            builder.reservedAddressSpaceSize((UnsignedWord)WordFactory.signed((long)addressSpaceSize));
        }
        Isolates.CreateIsolateParameters params = builder.build();
        return (CompilerIsolateThread)Isolates.createIsolate((Isolates.CreateIsolateParameters)params);
    }

    public static InstalledCode compileInNewIsolateAndInstall(SubstrateMethod method) {
        CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
        IsolatedCompileClient.set(new IsolatedCompileClient(context));
        byte[] encodedOptions = IsolatedGraalUtils.encodeRuntimeOptionValues();
        ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedGraalUtils.compileInNewIsolateAndInstall0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method), IsolatedCompileClient.get().hand(encodedOptions), IsolatedGraalUtils.getNullableArrayLength(encodedOptions));
        Isolates.tearDownIsolate((IsolateThread)context);
        InstalledCode installedCode = (InstalledCode)IsolatedCompileClient.get().unhand(installedCodeHandle);
        IsolatedCompileClient.set(null);
        return installedCode;
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<SubstrateInstalledCode> compileInNewIsolateAndInstall0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef, ClientHandle<byte[]> encodedOptions, int encodedOptionsLength) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        IsolatedGraalUtils.applyClientRuntimeOptionValues(encodedOptions, encodedOptionsLength);
        assert (SubstrateOptions.shouldCompileInIsolates());
        SubstrateMethod method = ImageHeapObjects.deref(methodRef);
        DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();
        CompilationResult compilationResult = SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method);
        ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedRuntimeCodeInstaller.installInClientIsolate(methodRef, compilationResult, (ClientHandle)IsolatedHandles.nullHandle());
        Log.log().string("Code for " + method.format("%H.%n(%p)") + ": " + compilationResult.getTargetCodeSize() + " bytes").newline();
        IsolatedCompileContext.set(null);
        return installedCodeHandle;
    }

    public static void compileInNewIsolate(SubstrateMethod method) {
        if (SubstrateOptions.shouldCompileInIsolates()) {
            CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
            IsolatedCompileClient.set(new IsolatedCompileClient(context));
            byte[] encodedOptions = IsolatedGraalUtils.encodeRuntimeOptionValues();
            IsolatedGraalUtils.compileInNewIsolate0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method), IsolatedCompileClient.get().hand(encodedOptions), IsolatedGraalUtils.getNullableArrayLength(encodedOptions));
            Isolates.tearDownIsolate((IsolateThread)context);
            IsolatedCompileClient.set(null);
        } else {
            try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
                SubstrateGraalUtils.compile(debug, method);
            }
        }
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void compileInNewIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef, ClientHandle<byte[]> encodedOptions, int encodedOptionsLength) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        IsolatedGraalUtils.applyClientRuntimeOptionValues(encodedOptions, encodedOptionsLength);
        assert (SubstrateOptions.shouldCompileInIsolates());
        try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
            SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), ImageHeapObjects.deref(methodRef));
        }
        IsolatedCompileContext.set(null);
    }

    public static byte[] encodeRuntimeOptionValues() {
        UnmodifiableEconomicMap map = RuntimeOptionValues.singleton().getMap();
        return map.isEmpty() ? null : OptionValuesEncoder.encode(map);
    }

    public static int getNullableArrayLength(Object array) {
        return array != null ? Array.getLength(array) : -1;
    }

    public static void applyClientRuntimeOptionValues(ClientHandle<byte[]> encodedOptionsHandle, int encodedOptionsLength) {
        if (!encodedOptionsHandle.equal((ComparableWord)IsolatedHandles.nullHandle())) {
            byte[] encodedOptions = new byte[encodedOptionsLength];
            try (PinnedObject pin = PinnedObject.create((Object)encodedOptions);){
                IsolatedGraalUtils.copyOptions(IsolatedCompileContext.get().getClient(), encodedOptionsHandle, pin.addressOfArrayElement(0));
            }
            EconomicMap<OptionKey<?>, Object> options = OptionValuesEncoder.decode(encodedOptions);
            options.replaceAll((k, v) -> OptionsParser.parseOptionValue((OptionDescriptor)k.getDescriptor(), (Object)v));
            RuntimeOptionValues.singleton().update((UnmodifiableEconomicMap)options);
        }
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void copyOptions(@CEntryPoint.IsolateThreadContext ClientIsolateThread isolate, ClientHandle<byte[]> encodedOptionsHandle, PointerBase buffer) {
        byte[] encodedOptions = IsolatedCompileClient.get().unhand(encodedOptionsHandle);
        CTypeConversion.asByteBuffer((PointerBase)buffer, (int)encodedOptions.length).put(encodedOptions);
    }

    private IsolatedGraalUtils() {
    }
}

