/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeSnippets;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.util.SplittableRandom;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;

public final class IdentityHashCodeSupport {
    public static final LocationIdentity IDENTITY_HASHCODE_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCode");
    private static final FastThreadLocalObject<SplittableRandom> hashCodeGeneratorTL = FastThreadLocalFactory.createObject(SplittableRandom.class);

    public static void ensureInitialized() {
        new SplittableRandom().nextInt();
    }

    public static IdentityHashCodeSnippets.Templates createSnippetTemplates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, TargetDescription target) {
        return new IdentityHashCodeSnippets.Templates((IdentityHashCodeSnippets)new SubstrateIdentityHashCodeSnippets(), options, factories, providers, target, IDENTITY_HASHCODE_LOCATION);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int generateIdentityHashCode(Object obj) {
        int newHashCode = IdentityHashCodeSupport.generateHashCode();
        if (!GraalUnsafeAccess.getUnsafe().compareAndSwapInt(obj, ConfigurationValues.getObjectLayout().getIdentityHashCodeOffset(), 0, newHashCode)) {
            newHashCode = ObjectAccess.readInt((Object)obj, (int)ConfigurationValues.getObjectLayout().getIdentityHashCodeOffset(), (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
        }
        VMError.guarantee(newHashCode != 0, "Missing identity hash code");
        return newHashCode;
    }

    private static int generateHashCode() {
        SplittableRandom hashCodeGenerator = hashCodeGeneratorTL.get();
        if (hashCodeGenerator == null) {
            hashCodeGenerator = new SplittableRandom();
            hashCodeGeneratorTL.set(hashCodeGenerator);
        }
        int hashCode = hashCodeGenerator.nextInt(Integer.MAX_VALUE) + 1;
        assert (hashCode != 0) : "Must not return 0 because it means 'hash code not computed yet' in the field that stores the hash code";
        assert (hashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return hashCode;
    }
}

