/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;

public final class HeapPolicyOptions {
    @Option(help={"The maximum heap size as percent of physical memory"})
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new RuntimeOptionKey<Integer>(80);
    @Option(help={"The maximum size of the young generation as a percentage of the maximum heap size"})
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new RuntimeOptionKey<Integer>(10);
    @Option(help={"Bytes that can be allocated before (re-)querying the physical memory size"})
    public static final HostedOptionKey<Long> AllocationBeforePhysicalMemorySize = new HostedOptionKey<Long>(0x100000L);
    @Option(help={"The size of an aligned chunk."})
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(Long.valueOf(0x100000L)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            int multiple = 4096;
            UserError.guarantee(newValue > 0L && newValue % (long)multiple == 0L, "%s value must be a multiple of %d.", this.getName(), multiple);
        }
    };
    @Option(help={"The size at or above which an array will be allocated in its own unaligned chunk.  0 implies (AlignedHeapChunkSize / 8)."})
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(0L);
    @Option(help={"Fill unused memory chunks with a sentinel value."})
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"Before use, fill memory chunks with a sentinel value."})
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"After use, Fill memory chunks with a sentinel value."})
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape."})
    public static final RuntimeOptionKey<Boolean> TraceHeapChunks = new RuntimeOptionKey<Boolean>(false);
    @Option(help={"Maximum number of survivor spaces."})
    public static final HostedOptionKey<Integer> MaxSurvivorSpaces = new HostedOptionKey<Integer>(0);
    @Option(help={"Determines if a full GC collects the young generation separately or together with the old generation."})
    public static final RuntimeOptionKey<Boolean> CollectYoungGenerationSeparately = new RuntimeOptionKey<Boolean>(false);

    private HeapPolicyOptions() {
    }
}

