/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Insets;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.GapContent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class TextComponentBuilders {
    TextComponentBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JTextField.class.getName())) {
            return new JTextFieldBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTextArea.class.getName())) {
            return new JTextAreaBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JEditorPane.class.getName())) {
            return new JEditorPaneBuilder(instance, heap);
        }
        return null;
    }

    private static class JEditorPaneBuilder
    extends JTextComponentBuilder<JEditorPane> {
        JEditorPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JEditorPane createInstanceImpl() {
            return new JEditorPane();
        }
    }

    private static class JTextAreaBuilder
    extends JTextComponentBuilder<JTextArea> {
        JTextAreaBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JTextArea createInstanceImpl() {
            return new JTextArea();
        }
    }

    private static class JTextFieldBuilder
    extends JTextComponentBuilder<JTextField> {
        JTextFieldBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JTextField createInstanceImpl() {
            return new JTextField();
        }
    }

    private static abstract class JTextComponentBuilder<T extends JTextComponent>
    extends ComponentBuilders.JComponentBuilder<T> {
        private final DocumentTextBuilder model;
        private final boolean isEditable;
        private final BaseBuilders.InsetsBuilder margin;

        JTextComponentBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.model = DocumentTextBuilder.fromField(instance, "model", heap);
            this.isEditable = DetailsUtils.getBooleanFieldValue(instance, "editable", false);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
        }

        @Override
        protected void setupInstance(T instance) {
            super.setupInstance(instance);
            if (this.model != null) {
                ((JTextComponent)instance).setText((String)this.model.createInstance());
            }
            ((JTextComponent)instance).setEditable(this.isEditable);
            if (this.margin != null) {
                ((JTextComponent)instance).setMargin((Insets)this.margin.createInstance());
            }
        }
    }

    private static class DocumentTextBuilder
    extends Utils.InstanceBuilder<String> {
        private final ContentTextBuilder data;

        DocumentTextBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.data = ContentTextBuilder.fromField(instance, "data", heap);
        }

        static DocumentTextBuilder fromField(Instance instance, String field, Heap heap) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, PlainDocument.class.getName())) {
                return null;
            }
            return new DocumentTextBuilder((Instance)model, heap);
        }

        @Override
        protected String createInstanceImpl() {
            return this.data != null ? (String)this.data.createInstance() : "";
        }
    }

    private static class ContentTextBuilder
    extends Utils.InstanceBuilder<String> {
        private final char[] array;

        ContentTextBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            List<String> values = DetailsUtils.getPrimitiveArrayFieldValues(instance, "array");
            this.array = values != null ? DetailsUtils.getCharArray(values) : null;
        }

        static ContentTextBuilder fromField(Instance instance, String field, Heap heap) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, GapContent.class.getName())) {
                return null;
            }
            return new ContentTextBuilder((Instance)model, heap);
        }

        @Override
        protected String createInstanceImpl() {
            return this.array != null ? new String(this.array).trim() : "";
        }
    }
}

