/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;

final class DataViewBuilders {
    DataViewBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JComboBox.class.getName())) {
            return new JComboBoxBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JList.class.getName())) {
            return new JListBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTree.class.getName())) {
            return new JTreeBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTable.class.getName())) {
            return new JTableBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTableHeader.class.getName())) {
            return new JTableHeaderBuilder(instance, heap);
        }
        return null;
    }

    private static class JTableHeaderBuilder
    extends ComponentBuilders.JComponentBuilder<JTableHeader> {
        private final TableColumnModelBuilder columnModel;

        JTableHeaderBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.columnModel = TableColumnModelBuilder.fromField(instance, "columnModel", heap);
        }

        @Override
        protected void setupInstance(JTableHeader instance) {
            TableColumnModel _columnModel;
            super.setupInstance(instance);
            TableColumnModel tableColumnModel = _columnModel = this.columnModel == null ? null : (TableColumnModel)this.columnModel.createInstance();
            if (_columnModel == null || _columnModel.getColumnCount() == 0) {
                TableColumn column = new TableColumn(0, instance.getWidth());
                column.setHeaderValue("Table");
                _columnModel = new DefaultTableColumnModel();
                _columnModel.addColumn(column);
            }
            instance.setColumnModel(_columnModel);
        }

        @Override
        protected JTableHeader createInstanceImpl() {
            return new JTableHeader();
        }
    }

    private static class JTableBuilder
    extends ComponentBuilders.JComponentBuilder<JTable> {
        private final TableColumnModelBuilder columnModel;

        JTableBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.columnModel = TableColumnModelBuilder.fromField(instance, "columnModel", heap);
        }

        @Override
        protected JTable createInstanceImpl() {
            return new JTable();
        }

        @Override
        protected Component createPresenterImpl(JTable instance) {
            TableColumnModel _columnModel;
            TableColumnModel tableColumnModel = _columnModel = this.columnModel == null ? null : (TableColumnModel)this.columnModel.createInstance();
            if (_columnModel == null || _columnModel.getColumnCount() == 0) {
                TableColumn column = new TableColumn(0, instance.getWidth());
                column.setHeaderValue("Table");
                _columnModel = new DefaultTableColumnModel();
                _columnModel.addColumn(column);
            }
            instance.setColumnModel(_columnModel);
            instance.setPreferredScrollableViewportSize(instance.getSize());
            return new JScrollPane(instance);
        }
    }

    private static class TableColumnModelBuilder
    extends Utils.InstanceBuilder<DefaultTableColumnModel> {
        private final List<TableColumnBuilder> tableColumns = new ArrayList<TableColumnBuilder>();
        private final int columnMargin;

        TableColumnModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            int size;
            Instance columns;
            Object _elementData;
            this.columnMargin = DetailsUtils.getIntFieldValue(instance, "columnMargin", 1);
            Object _columns = instance.getValueOfField("tableColumns");
            if (_columns instanceof Instance && (_elementData = (columns = (Instance)_columns).getValueOfField("elementData")) instanceof ObjectArrayInstance && (size = DetailsUtils.getIntFieldValue(columns, "elementCount", 0)) > 0) {
                ObjectArrayInstance elementData = (ObjectArrayInstance)_elementData;
                for (Object column : elementData.getValues()) {
                    if (!(column instanceof Instance)) continue;
                    this.tableColumns.add(new TableColumnBuilder((Instance)column, heap));
                }
            }
        }

        static TableColumnModelBuilder fromField(Instance instance, String field, Heap heap) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, DefaultTableColumnModel.class.getName())) {
                return null;
            }
            return new TableColumnModelBuilder((Instance)model, heap);
        }

        @Override
        protected void setupInstance(DefaultTableColumnModel instance) {
            super.setupInstance(instance);
            for (TableColumnBuilder builder : this.tableColumns) {
                instance.addColumn((TableColumn)builder.createInstance());
            }
            instance.setColumnMargin(this.columnMargin);
        }

        @Override
        protected DefaultTableColumnModel createInstanceImpl() {
            return new DefaultTableColumnModel();
        }
    }

    private static class TableColumnBuilder
    extends Utils.InstanceBuilder<TableColumn> {
        private final int modelIndex;
        private final int width;
        private final String headerValue;

        TableColumnBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.modelIndex = DetailsUtils.getIntFieldValue(instance, "modelIndex", 0);
            this.width = DetailsUtils.getIntFieldValue(instance, "width", 75);
            String _headerValue = Utils.getFieldString(instance, "headerValue");
            this.headerValue = _headerValue != null ? _headerValue : "Col " + (this.modelIndex + 1);
        }

        @Override
        protected void setupInstance(TableColumn instance) {
            super.setupInstance(instance);
            instance.setHeaderValue(this.headerValue);
        }

        @Override
        protected TableColumn createInstanceImpl() {
            return new TableColumn(this.modelIndex, this.width, null, null);
        }
    }

    private static class JTreeBuilder
    extends ComponentBuilders.JComponentBuilder<JTree> {
        private final boolean editable;

        JTreeBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.editable = DetailsUtils.getBooleanFieldValue(instance, "editable", false);
        }

        @Override
        protected void setupInstance(JTree instance) {
            super.setupInstance(instance);
            instance.setEditable(this.editable);
        }

        @Override
        protected JTree createInstanceImpl() {
            return new JTree(new Object[0]);
        }
    }

    private static class JListBuilder
    extends ComponentBuilders.JComponentBuilder<JList> {
        private final DefaultListModelBuilder dataModel;

        JListBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.dataModel = DefaultListModelBuilder.fromField(instance, "dataModel", heap);
        }

        @Override
        protected void setupInstance(JList instance) {
            ListModel model;
            super.setupInstance(instance);
            ListModel listModel = model = this.dataModel == null ? null : (ListModel)this.dataModel.createInstance();
            if (model != null) {
                instance.setModel(model);
            }
        }

        @Override
        protected JList createInstanceImpl() {
            return new JList();
        }
    }

    private static class DefaultListModelBuilder
    extends Utils.InstanceBuilder<DefaultListModel> {
        private final List<String> model = new ArrayList<String>();

        DefaultListModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            int size;
            Instance delegate;
            Object _elementData;
            Object _delegate = instance.getValueOfField("delegate");
            if (_delegate instanceof Instance && (_elementData = (delegate = (Instance)_delegate).getValueOfField("elementData")) instanceof ObjectArrayInstance && (size = DetailsUtils.getIntFieldValue(delegate, "elementCount", 0)) > 0) {
                ObjectArrayInstance elementData = (ObjectArrayInstance)_elementData;
                for (Object _item : elementData.getValues()) {
                    if (!(_item instanceof Instance)) continue;
                    Instance item = (Instance)_item;
                    String ytem = DetailsUtils.getInstanceString(item, heap);
                    if (ytem == null) {
                        ytem = BrowserUtils.getSimpleType(item.getJavaClass().getName()) + " #" + item.getInstanceNumber();
                    }
                    this.model.add(ytem);
                }
            }
        }

        static DefaultListModelBuilder fromField(Instance instance, String field, Heap heap) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, DefaultListModel.class.getName())) {
                return null;
            }
            return new DefaultListModelBuilder((Instance)model, heap);
        }

        @Override
        protected void setupInstance(DefaultListModel instance) {
            super.setupInstance(instance);
            for (String item : this.model) {
                instance.addElement(item);
            }
        }

        @Override
        protected DefaultListModel createInstanceImpl() {
            return new DefaultListModel();
        }
    }

    private static class JComboBoxBuilder
    extends ComponentBuilders.JComponentBuilder<JComboBox> {
        private final boolean isEditable;
        private final String selectedObject;

        JComboBoxBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            Instance selected;
            Object _selected;
            Instance dataModel;
            this.isEditable = DetailsUtils.getBooleanFieldValue(instance, "isEditable", false);
            String _selectedObject = null;
            Object _dataModel = instance.getValueOfField("dataModel");
            if (_dataModel instanceof Instance && DetailsUtils.isSubclassOf(dataModel = (Instance)_dataModel, DefaultComboBoxModel.class.getName()) && (_selected = dataModel.getValueOfField("selectedObject")) instanceof Instance && (_selectedObject = DetailsUtils.getInstanceString(selected = (Instance)_selected, heap)) == null) {
                _selectedObject = BrowserUtils.getSimpleType(selected.getJavaClass().getName()) + " #" + selected.getInstanceNumber();
            }
            this.selectedObject = _selectedObject;
        }

        @Override
        protected void setupInstance(JComboBox instance) {
            super.setupInstance(instance);
            instance.setEditable(this.isEditable);
            if (this.selectedObject != null) {
                instance.addItem(this.selectedObject);
            }
        }

        @Override
        protected JComboBox createInstanceImpl() {
            return new JComboBox();
        }
    }
}

