/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class UtilDetailsProvider
extends DetailsProvider.Basic {
    private static final String LOGGER_MASK = "java.util.logging.Logger+";
    private static final String LEVEL_MASK = "java.util.logging.Level+";
    private static final String LOCALE_MASK = "java.util.Locale";
    private static final String DATE_MASK = "java.util.Date+";
    private static final String TIMEZONE_MASK = "java.util.TimeZone+";
    private static final String PATTERN_MASK = "java.util.regex.Pattern";
    private static final String CURRENCY_MASK = "java.util.Currency";
    private static final String ZIPENTRY_MASK = "java.util.zip.ZipEntry+";
    private static final String LOGRECORD_MASK = "java.util.logging.LogRecord";
    private Formatter formatter = new SimpleFormatter();

    public UtilDetailsProvider() {
        super(LOGGER_MASK, LEVEL_MASK, LOCALE_MASK, DATE_MASK, TIMEZONE_MASK, PATTERN_MASK, CURRENCY_MASK, ZIPENTRY_MASK, LOGRECORD_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (LOGGER_MASK.equals(className) || LEVEL_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        if (LOCALE_MASK.equals(className)) {
            String country;
            String language = DetailsUtils.getInstanceFieldString(instance, "language", heap);
            if (language == null) {
                language = "";
            }
            if ((country = DetailsUtils.getInstanceFieldString(instance, "country", heap)) == null) {
                country = "";
            }
            if (!language.isEmpty() || !country.isEmpty()) {
                if (language.isEmpty() || country.isEmpty()) {
                    return language + country;
                }
                return language + "_" + country;
            }
        } else {
            if (DATE_MASK.equals(className)) {
                long fastTime = DetailsUtils.getLongFieldValue(instance, "fastTime", -1L);
                return new Date(fastTime).toString();
            }
            if (TIMEZONE_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "ID", heap);
            }
            if (PATTERN_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "pattern", heap);
            }
            if (CURRENCY_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "currencyCode", heap);
            }
            if (ZIPENTRY_MASK.equals(className)) {
                String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                long size = DetailsUtils.getLongFieldValue(instance, "size", -1L);
                if (name != null && size != -1L) {
                    return String.format("%s, size=%d", name, size);
                }
                return name;
            }
            if (LOGRECORD_MASK.equals(className)) {
                return this.formatter.format(new DetailsLogRecord(instance, heap));
            }
        }
        return null;
    }

    private class DetailsLogRecord
    extends LogRecord {
        private final Instance record;
        private final Heap heap;

        private DetailsLogRecord(Instance rec, Heap h) {
            super(Level.ALL, null);
            this.record = rec;
            this.heap = h;
        }

        @Override
        public long getMillis() {
            Object time = this.record.getValueOfField("millis");
            if (time instanceof Number) {
                return ((Number)time).longValue();
            }
            return 0L;
        }

        @Override
        public String getSourceClassName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceClassName", this.heap);
        }

        @Override
        public String getSourceMethodName() {
            return DetailsUtils.getInstanceFieldString(this.record, "sourceMethodName", this.heap);
        }

        @Override
        public String getLoggerName() {
            return DetailsUtils.getInstanceFieldString(this.record, "loggerName", this.heap);
        }

        @Override
        public String getMessage() {
            return DetailsUtils.getInstanceFieldString(this.record, "message", this.heap);
        }

        @Override
        public Object[] getParameters() {
            Object pars = this.record.getValueOfField("parameters");
            if (pars instanceof ObjectArrayInstance) {
                ArrayList<String> parameters = new ArrayList<String>();
                for (Object o : ((ObjectArrayInstance)pars).getValues()) {
                    String par = null;
                    if (o instanceof Instance) {
                        par = DetailsUtils.getInstanceString((Instance)o, this.heap);
                    }
                    if (par == null) {
                        par = "";
                    }
                    parameters.add(par);
                }
                return parameters.toArray();
            }
            return null;
        }

        @Override
        public Level getLevel() {
            String level = DetailsUtils.getInstanceFieldString(this.record, "level", this.heap);
            return Level.parse(level);
        }
    }
}

