/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class LangDetailsProvider
extends DetailsProvider.Basic {
    private static final String ENUM_MASK = "java.lang.Enum+";
    private static final String STACKTRACE_MASK = "java.lang.StackTraceElement";

    public LangDetailsProvider() {
        super(ENUM_MASK, STACKTRACE_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        String declaringClass;
        if (ENUM_MASK.equals(className)) {
            String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            int ordinal = DetailsUtils.getIntFieldValue(instance, "ordinal", -1);
            if (name != null) {
                if (ordinal != -1) {
                    return name + " (" + ordinal + ")";
                }
                return name;
            }
        } else if (STACKTRACE_MASK.equals(className) && (declaringClass = DetailsUtils.getInstanceFieldString(instance, "declaringClass", heap)) != null) {
            String methodName = DetailsUtils.getInstanceFieldString(instance, "methodName", heap);
            String fileName = DetailsUtils.getInstanceFieldString(instance, "fileName", heap);
            int lineNumber = DetailsUtils.getIntFieldValue(instance, "lineNumber", -1);
            if (methodName == null) {
                methodName = "Unknown method";
            }
            StackTraceElement ste = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            return ste.toString();
        }
        return null;
    }
}

