/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.info.Accessor;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;

public class ExecuteNativeAccessorNode
extends JavaScriptRootNode {
    private final JSContext context;
    private final GraalJSAccess graalAccess;
    private final Accessor accessor;
    private final FunctionTemplate signature;
    private final boolean getter;
    private final BranchProfile errorBranch = BranchProfile.create();
    @Node.Child
    private GetPrototypeNode getPrototypeNode;
    @Node.Child
    private PropertyGetNode prototypePropertyGetNode;
    @Node.Child
    private PropertyGetNode holderPropertyGetNode;

    public ExecuteNativeAccessorNode(GraalJSAccess graalAccess, JSContext context, Accessor accessor, boolean getter) {
        this.context = context;
        this.graalAccess = graalAccess;
        this.accessor = accessor;
        this.signature = accessor.getSignature();
        this.getter = getter;
        this.getPrototypeNode = GetPrototypeNode.create();
        this.prototypePropertyGetNode = PropertyGetNode.create((Object)"prototype", (boolean)false, (JSContext)context);
        this.holderPropertyGetNode = PropertyGetNode.createGetHidden((HiddenKey)GraalJSAccess.HOLDER_KEY, (JSContext)context);
    }

    public Object execute(VirtualFrame frame) {
        long functionPointer;
        DynamicObject instancePrototype;
        Object functionPrototype;
        DynamicObject functionObject;
        Object[] arguments = frame.getArguments();
        if (this.signature != null && (functionObject = this.signature.getFunctionObject(this.context.getRealm())) != null && (functionPrototype = this.prototypePropertyGetNode.getValue((Object)functionObject)) != (instancePrototype = this.getPrototypeNode.executeJSObject(arguments[0]))) {
            this.errorBranch.enter();
            throw Errors.createTypeError((String)this.incompatibleReceiverMessage());
        }
        long l = functionPointer = this.getter ? this.accessor.getGetterPtr() : this.accessor.getSetterPtr();
        if (functionPointer == 0L) {
            assert (!this.getter);
            return false;
        }
        Object holder = this.holderPropertyGetNode.getValue(arguments[1]);
        return this.executeAccessorMethod(functionPointer, holder, arguments);
    }

    @CompilerDirectives.TruffleBoundary
    private String incompatibleReceiverMessage() {
        return "Method " + this.accessor.getName() + " called on incompatible receiver";
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeAccessorMethod(long functionPointer, Object holder, Object[] arguments) {
        Object result;
        if (this.getter) {
            result = NativeAccess.executeAccessorGetter(functionPointer, holder, this.accessor.getName(), arguments, this.accessor.getData());
            result = this.graalAccess.correctReturnValue(result);
        } else {
            NativeAccess.executeAccessorSetter(functionPointer, holder, this.accessor.getName(), arguments, this.accessor.getData());
            result = Undefined.instance;
        }
        return result;
    }
}

