/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.info;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.info.ObjectTemplate;

public final class FunctionTemplate {
    public static final HiddenKey CONSTRUCTOR = new HiddenKey("FunctionTemplateConstructor");
    private final ObjectTemplate functionObjectTemplate = new ObjectTemplate();
    private final ObjectTemplate instanceTemplate = new ObjectTemplate();
    private final ObjectTemplate prototypeTemplate;
    private final int id;
    private long functionPointer;
    private Object additionalData;
    private final FunctionTemplate signature;
    private final int length;
    private FunctionTemplate parent;
    private String className = "";
    private DynamicObject functionObj;
    private final boolean singleFunctionTemplate;

    public FunctionTemplate(int id, long functionPointer, Object additionalData, FunctionTemplate signature, int length, boolean isConstructor, boolean singleFunctionTemplate) {
        this.prototypeTemplate = isConstructor ? new ObjectTemplate() : null;
        this.id = id;
        this.functionPointer = functionPointer;
        this.additionalData = additionalData;
        this.signature = signature;
        this.length = length;
        this.singleFunctionTemplate = singleFunctionTemplate;
    }

    public ObjectTemplate getFunctionObjectTemplate() {
        return this.functionObjectTemplate;
    }

    public ObjectTemplate getInstanceTemplate() {
        return this.instanceTemplate;
    }

    public ObjectTemplate getPrototypeTemplate() {
        return this.prototypeTemplate;
    }

    public void setFunctionObject(JSRealm realm, DynamicObject functionObj) {
        if (this.singleFunctionTemplate) {
            this.functionObj = functionObj;
        } else {
            GraalJSAccess.getRealmEmbedderData(realm).setFunctionTemplateObject(this.id, functionObj);
        }
    }

    public DynamicObject getFunctionObject(JSRealm realm) {
        return this.singleFunctionTemplate ? this.functionObj : GraalJSAccess.getRealmEmbedderData(realm).getFunctionTemplateObject(this.id);
    }

    public int getID() {
        return this.id;
    }

    public void setFunctionPointer(long functionPointer) {
        this.functionPointer = functionPointer;
    }

    public long getFunctionPointer() {
        return this.functionPointer;
    }

    public void setAdditionalData(Object additionalData) {
        this.additionalData = additionalData;
    }

    public Object getAdditionalData() {
        return this.additionalData;
    }

    public FunctionTemplate getSignature() {
        return this.signature;
    }

    public int getLength() {
        return this.length;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public FunctionTemplate getParent() {
        return this.parent;
    }

    public void setParent(FunctionTemplate parent) {
        this.parent = parent;
    }
}

