/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.info;

import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.trufflenode.ContextData;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;
import com.oracle.truffle.trufflenode.node.ExecuteNativeAccessorNode;
import java.util.concurrent.atomic.AtomicInteger;

public class Accessor {
    private static final AtomicInteger idGenerator = new AtomicInteger();
    private final GraalJSAccess graalAccess;
    private final String name;
    private final long getterPtr;
    private final long setterPtr;
    private final Object data;
    private final FunctionTemplate signature;
    private final int id;
    private final int attributes;

    public Accessor(GraalJSAccess graalAccess, Object name, long getterPtr, long setterPtr, Object data, FunctionTemplate signature, int attributes) {
        this.graalAccess = graalAccess;
        this.name = (String)name;
        this.getterPtr = getterPtr;
        this.setterPtr = setterPtr;
        this.data = data;
        this.signature = signature;
        this.id = idGenerator.getAndIncrement();
        this.attributes = attributes;
    }

    public long getGetterPtr() {
        return this.getterPtr;
    }

    public long getSetterPtr() {
        return this.setterPtr;
    }

    public String getName() {
        return this.name;
    }

    public Object getData() {
        return this.data;
    }

    public FunctionTemplate getSignature() {
        return this.signature;
    }

    public int getAttributes() {
        return this.attributes;
    }

    private Pair<JSFunctionData, JSFunctionData> createFunctions(JSContext context) {
        JSFunctionData getter = this.getterPtr == 0L ? null : this.createFunction(context, true);
        JSFunctionData setter = JSAttributes.isWritable((int)this.attributes) ? this.createFunction(context, false) : null;
        return new Pair((Object)getter, (Object)setter);
    }

    private JSFunctionData createFunction(JSContext context, boolean getter) {
        return GraalJSAccess.functionDataFromRootNode(context, new ExecuteNativeAccessorNode(this.graalAccess, context, this, getter));
    }

    public Pair<JSFunctionData, JSFunctionData> getFunctions(JSContext context) {
        ContextData contextData = GraalJSAccess.getContextEmbedderData(context);
        Pair<JSFunctionData, JSFunctionData> functions = contextData.getAccessorPair(this.id);
        if (functions == null) {
            functions = this.createFunctions(context);
            contextData.setAccessorPair(this.id, functions);
        }
        return functions;
    }
}

