/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode;

import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.trufflenode.JSExternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class ContextData {
    private final Map<String, FunctionNode> functionNodeCache = new WeakHashMap<String, FunctionNode>();
    private final Map<Source, ScriptNode> scriptNodeCache = new WeakHashMap<Source, ScriptNode>();
    private final List<Pair<JSFunctionData, JSFunctionData>> accessorPairs = new ArrayList<Pair<JSFunctionData, JSFunctionData>>();
    private final Shape externalObjectShape;

    public ContextData(JSContext context) {
        this.externalObjectShape = JSExternal.makeInitialShape(context);
    }

    public Pair<JSFunctionData, JSFunctionData> getAccessorPair(int id) {
        if (id < this.accessorPairs.size()) {
            return this.accessorPairs.get(id);
        }
        return null;
    }

    public void setAccessorPair(int id, Pair<JSFunctionData, JSFunctionData> pair) {
        while (this.accessorPairs.size() <= id) {
            this.accessorPairs.add(null);
        }
        this.accessorPairs.set(id, pair);
    }

    public Shape getExternalObjectShape() {
        return this.externalObjectShape;
    }

    public Map<Source, ScriptNode> getScriptNodeCache() {
        return this.scriptNodeCache;
    }

    public Map<String, FunctionNode> getFunctionNodeCache() {
        return this.functionNodeCache;
    }
}

