/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
final class SignatureBuilderGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SignatureBuilderGen() {
    }

    static {
        LibraryExport.register(LibFFISignature.SignatureBuilder.class, (LibraryExport[])new LibraryExport[]{new NFIBackendSignatureBuilderLibraryExports()});
    }

    @GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
    private static final class NFIBackendSignatureBuilderLibraryExports
    extends LibraryExport<NFIBackendSignatureBuilderLibrary> {
        private NFIBackendSignatureBuilderLibraryExports() {
            super(NFIBackendSignatureBuilderLibrary.class, LibFFISignature.SignatureBuilder.class, false);
        }

        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFISignature.SignatureBuilder);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFISignature.SignatureBuilder);
            return new Cached();
        }

        @GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
        private static final class Uncached
        extends NFIBackendSignatureBuilderLibrary {
            private final TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_ = this.lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature.SignatureBuilder) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature.SignatureBuilder;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                if (arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                    LibFFISignature.SignatureBuilder.SetReturnType.doSet(arg0Value, arg1Value_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void addArgument(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                if (arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                    LibFFISignature.SignatureBuilder.AddArgument.doGeneric(arg0Value, arg1Value_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object build(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                return LibFFISignature.SignatureBuilder.Build.doGeneric(arg0Value, (NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void makeVarargs(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LibFFISignature.SignatureBuilder)receiver).makeVarargs();
            }
        }

        @GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
        private static final class Cached
        extends NFIBackendSignatureBuilderLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilerDirectives.CompilationFinal
            private AddArgumentCachedData addArgument_cached_cache;
            @CompilerDirectives.CompilationFinal
            private BuildCachedData build_cached_cache;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature.SignatureBuilder) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature.SignatureBuilder;
            }

            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                    LibFFISignature.SignatureBuilder.SetReturnType.doSet(arg0Value, arg1Value_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setReturnTypeAndSpecialize(arg0Value, arg1Value);
            }

            private void setReturnTypeAndSpecialize(LibFFISignature.SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arg1Value instanceof LibFFIType) {
                        LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        LibFFISignature.SignatureBuilder.SetReturnType.doSet(arg0Value, arg1Value_);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            @ExplodeLoop
            public void addArgument(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 6) != 0 && arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                    if ((state_0 & 2) != 0) {
                        AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                        while (s1_ != null) {
                            if (arg0Value.state == s1_.oldState_ && arg1Value_.typeInfo == s1_.cachedTypeInfo_) {
                                LibFFISignature.SignatureBuilder.AddArgument.doCached(arg0Value, arg1Value_, s1_.oldState_, s1_.cachedTypeInfo_, s1_.newState_);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        LibFFISignature.SignatureBuilder.AddArgument.doGeneric(arg0Value, arg1Value_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.addArgumentAndSpecialize(arg0Value, arg1Value);
            }

            private void addArgumentAndSpecialize(LibFFISignature.SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    if (arg1Value instanceof LibFFIType) {
                        LibFFIType arg1Value_ = (LibFFIType)arg1Value;
                        if ((exclude & 1) == 0) {
                            int count1_ = 0;
                            AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                            if ((state_0 & 2) != 0) {
                                while (s1_ != null && (arg0Value.state != s1_.oldState_ || arg1Value_.typeInfo != s1_.cachedTypeInfo_)) {
                                    s1_ = s1_.next_;
                                    ++count1_;
                                }
                            }
                            if (s1_ == null && count1_ < 3) {
                                s1_ = new AddArgumentCachedData(this.addArgument_cached_cache);
                                s1_.oldState_ = arg0Value.state;
                                s1_.cachedTypeInfo_ = arg1Value_.typeInfo;
                                s1_.newState_ = s1_.oldState_.addArg(s1_.cachedTypeInfo_);
                                this.addArgument_cached_cache = s1_;
                                this.state_0_ = state_0 |= 2;
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                LibFFISignature.SignatureBuilder.AddArgument.doCached(arg0Value, arg1Value_, s1_.oldState_, s1_.cachedTypeInfo_, s1_.newState_);
                                return;
                            }
                        }
                        this.exclude_ = exclude |= 1;
                        this.addArgument_cached_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        LibFFISignature.SignatureBuilder.AddArgument.doGeneric(arg0Value, arg1Value_);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            @ExplodeLoop
            public Object build(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature.SignatureBuilder arg0Value = (LibFFISignature.SignatureBuilder)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x18) != 0) {
                    if ((state_0 & 8) != 0) {
                        BuildCachedData s1_ = this.build_cached_cache;
                        while (s1_ != null) {
                            if (arg0Value.state == s1_.cachedState_ && arg0Value.retTypeInfo == s1_.cachedRetType_) {
                                TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                NFIContext ctx__ = (NFIContext)nFILanguageImplContextReference__.get();
                                return LibFFISignature.SignatureBuilder.Build.doCached(arg0Value, s1_.cachedState_, s1_.cachedRetType_, ctx__, s1_.cachedSigInfo_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        NFIContext build_generic_ctx__ = (NFIContext)nFILanguageImplContextReference__1.get();
                        return LibFFISignature.SignatureBuilder.Build.doGeneric(arg0Value, build_generic_ctx__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.buildAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object buildAndSpecialize(LibFFISignature.SignatureBuilder arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    NFIContext ctx__ = null;
                    if ((exclude & 2) == 0) {
                        LibFFIType.CachedTypeInfo cachedRetType__;
                        int count1_ = 0;
                        BuildCachedData s1_ = this.build_cached_cache;
                        if ((state_0 & 8) != 0) {
                            while (s1_ != null) {
                                if (arg0Value.state == s1_.cachedState_ && arg0Value.retTypeInfo == s1_.cachedRetType_) {
                                    TruffleLanguage.ContextReference nFILanguageImplContextReference__2 = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__2 == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__2 = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    ctx__ = (NFIContext)nFILanguageImplContextReference__2.get();
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && arg0Value.retTypeInfo == (cachedRetType__ = arg0Value.retType.typeInfo) && count1_ < 3) {
                            s1_ = new BuildCachedData(this.build_cached_cache);
                            s1_.cachedState_ = arg0Value.state;
                            s1_.cachedRetType_ = cachedRetType__;
                            TruffleLanguage.ContextReference nFILanguageImplContextReference__3 = this.nFILanguageImplContextReference_;
                            if (nFILanguageImplContextReference__3 == null) {
                                this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__3 = super.lookupContextReference(NFILanguageImpl.class);
                            }
                            ctx__ = (NFIContext)nFILanguageImplContextReference__3.get();
                            s1_.cachedSigInfo_ = LibFFISignature.prepareSignatureInfo(ctx__.language, cachedRetType__, s1_.cachedState_);
                            this.build_cached_cache = s1_;
                            this.state_0_ = state_0 |= 8;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = LibFFISignature.SignatureBuilder.Build.doCached(arg0Value, s1_.cachedState_, s1_.cachedRetType_, ctx__, s1_.cachedSigInfo_);
                            return object;
                        }
                    }
                    NFIContext build_generic_ctx__ = null;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__4 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__4 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__4 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    build_generic_ctx__ = (NFIContext)nFILanguageImplContextReference__4.get();
                    this.exclude_ = exclude |= 2;
                    this.build_cached_cache = null;
                    state_0 &= 0xFFFFFFF7;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = LibFFISignature.SignatureBuilder.Build.doGeneric(arg0Value, build_generic_ctx__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void makeVarargs(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                ((LibFFISignature.SignatureBuilder)receiver).makeVarargs();
            }

            @GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
            private static final class BuildCachedData {
                @CompilerDirectives.CompilationFinal
                BuildCachedData next_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.ArgsState cachedState_;
                @CompilerDirectives.CompilationFinal
                LibFFIType.CachedTypeInfo cachedRetType_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.CachedSignatureInfo cachedSigInfo_;

                BuildCachedData(BuildCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=LibFFISignature.SignatureBuilder.class)
            private static final class AddArgumentCachedData {
                @CompilerDirectives.CompilationFinal
                AddArgumentCachedData next_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.ArgsState oldState_;
                @CompilerDirectives.CompilationFinal
                LibFFIType.CachedTypeInfo cachedTypeInfo_;
                @CompilerDirectives.CompilationFinal
                LibFFISignature.ArgsState newState_;

                AddArgumentCachedData(AddArgumentCachedData next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

