/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIBackendImpl;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.spi.NFIBackendTools;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;

@TruffleLanguage.Registration(id="internal/nfi-native", name="nfi-native", version="0.1", characterMimeTypes={"trufflenfi/native"}, internal=true, services={NFIBackendFactory.class}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public class NFILanguageImpl
extends TruffleLanguage<NFIContext> {
    public static final String MIME_TYPE = "trufflenfi/native";
    @CompilerDirectives.CompilationFinal
    private NFIBackendImpl backend;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType.CachedTypeInfo[] simpleTypeMap = new LibFFIType.CachedTypeInfo[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType.CachedTypeInfo[] arrayTypeMap = new LibFFIType.CachedTypeInfo[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal
    LibFFIType.CachedTypeInfo cachedEnvType;

    LibFFIType.CachedTypeInfo lookupSimpleTypeInfo(NativeSimpleType type) {
        return this.simpleTypeMap[type.ordinal()];
    }

    NFIBackendTools getTools() {
        return this.backend.tools;
    }

    protected NFIContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            @Override
            public String getBackendId() {
                return "native";
            }

            @Override
            public NFIBackend createBackend(NFIBackendTools tools) {
                if (NFILanguageImpl.this.backend == null) {
                    NFILanguageImpl.this.backend = new NFIBackendImpl(NFILanguageImpl.this, tools);
                }
                return NFILanguageImpl.this.backend;
            }
        });
        return new NFIContext(this, env);
    }

    protected void initializeContext(NFIContext context) throws Exception {
        context.initialize();
    }

    protected boolean patchContext(NFIContext context, TruffleLanguage.Env newEnv) {
        context.patchEnv(newEnv);
        context.initialize();
        return true;
    }

    protected void disposeContext(NFIContext context) {
        context.dispose();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        return Truffle.getRuntime().createCallTarget(new RootNode(this){

            public Object execute(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("illegal access to internal language");
            }
        });
    }

    protected static NFIContext getCurrentContext() {
        return (NFIContext)NFILanguageImpl.getCurrentContext(NFILanguageImpl.class);
    }
}

