/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.netbeans.core.network.proxy.pac.datetime.DateRange;
import org.netbeans.core.network.proxy.pac.datetime.TimeRange;

public class PacUtilsDateTime {
    public static final List<String> WEEKDAY_NAMES = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    public static final List<String> MONTH_NAMES = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private static final TimeZone UTC_TIME = TimeZone.getTimeZone("UTC");

    public static boolean isInWeekdayRange(Date date, Object ... objectArray) throws PacDateTimeInputException {
        int n;
        int n2;
        int n3 = PacUtilsDateTime.getNoOfParams(objectArray);
        boolean bl = PacUtilsDateTime.usesGMT(objectArray);
        Calendar calendar = PacUtilsDateTime.getCalendar(date, bl);
        if (bl) {
            --n3;
        }
        if (n3 < 1 || n3 > 2) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        if (n3 == 1) {
            n = n2 = PacUtilsDateTime.getWeekday(objectArray[0].toString());
        } else {
            n2 = PacUtilsDateTime.getWeekday(objectArray[0].toString());
            n = PacUtilsDateTime.getWeekday(objectArray[1].toString());
        }
        int n4 = calendar.get(7);
        if (n2 <= n) {
            return n4 >= n2 && n4 <= n;
        }
        return n4 >= n2 || n4 <= n;
    }

    public static boolean isInTimeRange(Date date, Object ... objectArray) throws PacDateTimeInputException {
        int n = PacUtilsDateTime.getNoOfParams(objectArray);
        boolean bl = PacUtilsDateTime.usesGMT(objectArray);
        Calendar calendar = PacUtilsDateTime.getCalendar(date, bl);
        if (bl) {
            --n;
        }
        if (n < 1 || n > 6 || n == 5 || n == 3) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        TimeRange.TimeRangeBuilder timeRangeBuilder = TimeRange.getBuilder();
        if (n == 1) {
            timeRangeBuilder.setHourMinMax(PacUtilsDateTime.getHour(objectArray[0]), PacUtilsDateTime.getHour(objectArray[0]));
        }
        if (n == 2) {
            timeRangeBuilder.setHourMinMax(PacUtilsDateTime.getHour(objectArray[0]), PacUtilsDateTime.getHour(objectArray[1]));
            if (PacUtilsDateTime.getHour(objectArray[0]) != PacUtilsDateTime.getHour(objectArray[1])) {
                timeRangeBuilder.setMinuteMinMax(0, 0);
            }
        }
        if (n == 4) {
            timeRangeBuilder.setHourMinMax(PacUtilsDateTime.getHour(objectArray[0]), PacUtilsDateTime.getHour(objectArray[2])).setMinuteMinMax(PacUtilsDateTime.getMinute(objectArray[1]), PacUtilsDateTime.getMinute(objectArray[3])).setSecondMinMax(0, 0);
        }
        if (n == 6) {
            timeRangeBuilder.setHourMinMax(PacUtilsDateTime.getHour(objectArray[0]), PacUtilsDateTime.getHour(objectArray[3])).setMinuteMinMax(PacUtilsDateTime.getMinute(objectArray[1]), PacUtilsDateTime.getMinute(objectArray[4])).setSecondMinMax(PacUtilsDateTime.getSecond(objectArray[2]), PacUtilsDateTime.getSecond(objectArray[5]));
        }
        TimeRange timeRange = timeRangeBuilder.createTimeRange();
        return timeRange.isInRange(calendar);
    }

    public static boolean isInDateRange(Date date, Object ... objectArray) throws PacDateTimeInputException {
        int n = PacUtilsDateTime.getNoOfParams(objectArray);
        boolean bl = PacUtilsDateTime.usesGMT(objectArray);
        Calendar calendar = PacUtilsDateTime.getCalendar(date, bl);
        if (bl) {
            --n;
        }
        if (n < 1 || n > 6 || n == 5 || n == 3) {
            throw new PacDateTimeInputException("invalid number of arguments");
        }
        DateRange.DateRangeBuilder dateRangeBuilder = DateRange.getBuilder();
        if (n == 1) {
            int n2;
            if (PacUtilsDateTime.isYear(objectArray[0])) {
                n2 = PacUtilsDateTime.getYear(objectArray[0]);
                dateRangeBuilder.setYear(n2, n2);
            } else if (PacUtilsDateTime.isMonth(objectArray[0])) {
                n2 = PacUtilsDateTime.getMonth(objectArray[0].toString());
                dateRangeBuilder.setMonth(n2, n2);
            } else if (PacUtilsDateTime.isDate(objectArray[0])) {
                n2 = PacUtilsDateTime.getDate(objectArray[0]);
                dateRangeBuilder.setDate(n2, n2);
            } else {
                throw new PacDateTimeInputException("invalid argument : " + objectArray[0].toString());
            }
        }
        if (n == 2) {
            if (PacUtilsDateTime.isYear(objectArray[0])) {
                dateRangeBuilder.setYear(PacUtilsDateTime.getYear(objectArray[0]), PacUtilsDateTime.getYear(objectArray[1]));
            } else if (PacUtilsDateTime.isMonth(objectArray[0])) {
                dateRangeBuilder.setMonth(PacUtilsDateTime.getMonth(objectArray[0].toString()), PacUtilsDateTime.getMonth(objectArray[1].toString()));
            } else if (PacUtilsDateTime.isDate(objectArray[0])) {
                dateRangeBuilder.setDate(PacUtilsDateTime.getDate(objectArray[0]), PacUtilsDateTime.getDate(objectArray[1]));
            } else {
                throw new PacDateTimeInputException("invalid argument : " + objectArray[0].toString());
            }
        }
        if (n == 4) {
            if (PacUtilsDateTime.isMonth(objectArray[0])) {
                dateRangeBuilder.setYear(PacUtilsDateTime.getYear(objectArray[1]), PacUtilsDateTime.getYear(objectArray[3])).setMonth(PacUtilsDateTime.getMonth(objectArray[0].toString()), PacUtilsDateTime.getMonth(objectArray[2].toString()));
            } else if (PacUtilsDateTime.isDate(objectArray[0])) {
                dateRangeBuilder.setMonth(PacUtilsDateTime.getMonth(objectArray[1].toString()), PacUtilsDateTime.getMonth(objectArray[3].toString())).setDate(PacUtilsDateTime.getDate(objectArray[0]), PacUtilsDateTime.getDate(objectArray[2]));
            } else {
                throw new PacDateTimeInputException("invalid argument : " + objectArray[0].toString());
            }
        }
        if (n == 6) {
            dateRangeBuilder.setYear(PacUtilsDateTime.getYear(objectArray[2]), PacUtilsDateTime.getYear(objectArray[5])).setMonth(PacUtilsDateTime.getMonth(objectArray[1].toString()), PacUtilsDateTime.getMonth(objectArray[4].toString())).setDate(PacUtilsDateTime.getDate(objectArray[0]), PacUtilsDateTime.getDate(objectArray[3]));
        }
        DateRange dateRange = dateRangeBuilder.createDateRange();
        return dateRange.isInRange(calendar);
    }

    private static boolean isMonth(Object object) {
        return object instanceof CharSequence;
    }

    private static boolean isYear(Object object) {
        try {
            int n = PacUtilsDateTime.getInteger(object);
            return n >= 1000;
        }
        catch (PacDateTimeInputException pacDateTimeInputException) {
            return false;
        }
    }

    private static boolean isDate(Object object) {
        try {
            int n = PacUtilsDateTime.getInteger(object);
            return n >= 1 && n <= 31;
        }
        catch (PacDateTimeInputException pacDateTimeInputException) {
            return false;
        }
    }

    private static int getDate(Object object) throws PacDateTimeInputException {
        if (!PacUtilsDateTime.isDate(object)) {
            throw new PacDateTimeInputException("value " + object.toString() + " is not a valid day of month");
        }
        return PacUtilsDateTime.getInteger(object);
    }

    private static int getYear(Object object) throws PacDateTimeInputException {
        if (!PacUtilsDateTime.isYear(object)) {
            throw new PacDateTimeInputException("value " + object.toString() + " is not a valid year");
        }
        return PacUtilsDateTime.getInteger(object);
    }

    private static int getWeekday(String string) throws PacDateTimeInputException {
        int n = WEEKDAY_NAMES.indexOf(string);
        if (n == -1) {
            throw new PacDateTimeInputException("Unknown weekday name : \"" + string + "\"");
        }
        return n + 1;
    }

    private static int getMonth(String string) throws PacDateTimeInputException {
        int n = MONTH_NAMES.indexOf(string);
        if (n == -1) {
            throw new PacDateTimeInputException("Unknown month name : \"" + string + "\"");
        }
        return n;
    }

    private static int getInteger(Object object) throws PacDateTimeInputException {
        if (object instanceof Integer || object instanceof Long) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PacDateTimeInputException("value is " + object + " is not an integer");
    }

    private static int getHour(Object object) throws PacDateTimeInputException {
        int n = PacUtilsDateTime.getInteger(object);
        if (n < 0 || n > 23) {
            throw new PacDateTimeInputException("value is " + n + " is not a valid hour of day (0-23)");
        }
        return n;
    }

    private static int getMinute(Object object) throws PacDateTimeInputException {
        int n = PacUtilsDateTime.getInteger(object);
        if (n < 0 || n > 59) {
            throw new PacDateTimeInputException("value is " + n + " is not a valid minute (0-59)");
        }
        return n;
    }

    private static int getSecond(Object object) throws PacDateTimeInputException {
        int n = PacUtilsDateTime.getInteger(object);
        if (n < 0 || n > 59) {
            throw new PacDateTimeInputException("value is " + n + " is not a valid second (0-59)");
        }
        return n;
    }

    private static Calendar getCalendar(Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (bl) {
            calendar.setTimeZone(UTC_TIME);
        }
        return calendar;
    }

    public static int getNoOfParams(Object ... objectArray) {
        int n = 0;
        for (Object object : objectArray) {
            if (object == null || !(object instanceof Number) && !(object instanceof CharSequence)) continue;
            ++n;
        }
        return n;
    }

    public static boolean usesGMT(Object ... objectArray) {
        String string;
        int n = PacUtilsDateTime.getNoOfParams(objectArray);
        return objectArray[n - 1] instanceof CharSequence && (string = objectArray[n - 1].toString()).equals("GMT");
    }

    public static class PacDateTimeInputException
    extends Exception {
        public PacDateTimeInputException(String string) {
            super(string);
        }
    }
}

