/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Objects;
import java.util.Set;

public final class StackTraceEntry {
    static final byte STATE_UNKNOWN = 0;
    static final byte STATE_INTERPRETED = 1;
    static final byte STATE_COMPILED = 2;
    static final byte STATE_COMPILATION_ROOT = 3;
    private final SourceSection sourceSection;
    private final String rootName;
    private final Set<Class<?>> tags;
    private final Node instrumentedNode;
    private final byte state;
    private volatile StackTraceElement stackTraceElement;

    StackTraceEntry(Instrumenter instrumenter, EventContext context, byte state) {
        this.tags = instrumenter.queryTags(context.getInstrumentedNode());
        this.sourceSection = context.getInstrumentedSourceSection();
        this.instrumentedNode = context.getInstrumentedNode();
        this.rootName = StackTraceEntry.extractRootName(this.instrumentedNode);
        this.state = state;
    }

    StackTraceEntry(StackTraceEntry location, byte state) {
        this.sourceSection = location.sourceSection;
        this.instrumentedNode = location.instrumentedNode;
        this.rootName = location.rootName;
        this.tags = location.tags;
        this.stackTraceElement = location.stackTraceElement;
        this.state = state;
    }

    StackTraceEntry(Instrumenter instrumenter, Node node, byte state) {
        this.tags = instrumenter.queryTags(node);
        this.sourceSection = node.getSourceSection();
        this.instrumentedNode = node;
        this.rootName = StackTraceEntry.extractRootName(this.instrumentedNode);
        this.state = state;
    }

    public boolean isCompiled() {
        return this.state == 2 || this.state == 3;
    }

    public boolean isInterpreted() {
        return this.state == 1;
    }

    public boolean isInlined() {
        return this.state == 2;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public String getRootName() {
        return this.rootName;
    }

    public Set<Class<?>> getTags() {
        return this.tags;
    }

    public StackTraceElement toStackTraceElement() {
        String methodName;
        StackTraceElement stack = this.stackTraceElement;
        if (stack != null) {
            return stack;
        }
        LanguageInfo languageInfo = this.getInstrumentedNode().getRootNode().getLanguageInfo();
        String declaringClass = languageInfo != null ? languageInfo.getId() : "";
        SourceSection sourceLocation = this.getSourceSection();
        String string = methodName = this.rootName == null ? "" : this.rootName;
        if (!this.tags.contains(StandardTags.RootTag.class)) {
            methodName = methodName + "~" + StackTraceEntry.formatIndices(this.sourceSection, true);
        }
        String fileName = this.formatFileName();
        int startLine = sourceLocation != null ? sourceLocation.getStartLine() : -1;
        this.stackTraceElement = new StackTraceElement(declaringClass, methodName, fileName, startLine);
        return this.stackTraceElement;
    }

    private String formatFileName() {
        if (this.sourceSection == null) {
            return "<Unknown>";
        }
        Source source = this.sourceSection.getSource();
        if (source == null) {
            return "<Unknown>";
        }
        if (source.getPath() == null) {
            return source.getName();
        }
        return source.getPath();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }

    private static String extractRootName(Node instrumentedNode) {
        RootNode rootNode = instrumentedNode.getRootNode();
        if (rootNode != null) {
            if (rootNode.getName() == null) {
                return rootNode.toString();
            }
            return rootNode.getName();
        }
        return "<Unknown>";
    }

    Node getInstrumentedNode() {
        return this.instrumentedNode;
    }

    public int hashCode() {
        return 31 * (31 + this.rootName.hashCode()) + this.sourceSection.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceEntry)) {
            return false;
        }
        StackTraceEntry other = (StackTraceEntry)obj;
        return Objects.equals(this.sourceSection, other.sourceSection) && Objects.equals(this.rootName, other.rootName);
    }

    public String toString() {
        String s = "";
        switch (this.state) {
            case 0: {
                s = "";
                break;
            }
            case 3: {
                s = ", Interpreted";
                break;
            }
            case 2: {
                s = ", Compiled";
                break;
            }
            case 1: {
                s = ", Interpreted";
            }
        }
        return "StackLocation [rootName=" + this.rootName + ", tags=" + this.tags + ", sourceSection=" + this.sourceSection + s + "]";
    }
}

