/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.ProfilerException;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import com.oracle.truffle.tools.profiler.impl.CPUTracerInstrument;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.polyglot.Engine;

public final class CPUTracer
implements Closeable {
    private static final SourceSectionFilter DEFAULT_FILTER = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
    private final TruffleInstrument.Env env;
    private boolean closed = false;
    private boolean collecting = false;
    private SourceSectionFilter filter = null;
    private EventBinding<?> activeBinding;
    private final Map<SourceSection, Payload> payloadMap = new ConcurrentHashMap<SourceSection, Payload>();

    CPUTracer(TruffleInstrument.Env env) {
        this.env = env;
    }

    public static CPUTracer find(Engine engine) {
        return CPUTracerInstrument.getTracer(engine);
    }

    public synchronized void setCollecting(boolean collecting) {
        if (this.closed) {
            throw new ProfilerException("CPUTracer is already closed.");
        }
        if (this.collecting != collecting) {
            this.collecting = collecting;
            this.resetTracer();
        }
    }

    public synchronized boolean isCollecting() {
        return this.collecting;
    }

    public synchronized void setFilter(SourceSectionFilter filter) {
        this.verifyConfigAllowed();
        this.filter = filter;
    }

    public synchronized SourceSectionFilter getFilter() {
        return this.filter;
    }

    public Collection<Payload> getPayloads() {
        return Collections.unmodifiableCollection(this.payloadMap.values());
    }

    public void clearData() {
        this.payloadMap.clear();
    }

    private Payload getCounter(final EventContext context) {
        SourceSection sourceSection = context.getInstrumentedSourceSection();
        return this.payloadMap.computeIfAbsent(sourceSection, new Function<SourceSection, Payload>(){

            @Override
            public Payload apply(SourceSection section) {
                return new Payload(new StackTraceEntry(CPUTracer.this.env.getInstrumenter(), context, 1));
            }
        });
    }

    private synchronized void verifyConfigAllowed() {
        assert (Thread.holdsLock(this));
        if (this.closed) {
            throw new ProfilerException("CPUTracer is already closed.");
        }
        if (this.collecting) {
            throw new ProfilerException("Cannot change tracer configuration while collecting. Call setCollecting(false) to disable collection first.");
        }
    }

    private synchronized void resetTracer() {
        assert (Thread.holdsLock(this));
        if (this.activeBinding != null) {
            this.activeBinding.dispose();
            this.activeBinding = null;
        }
        if (!this.collecting || this.closed) {
            return;
        }
        SourceSectionFilter f = this.filter;
        if (f == null) {
            f = DEFAULT_FILTER;
        }
        this.activeBinding = this.env.getInstrumenter().attachExecutionEventFactory(f, new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                return new CounterNode(CPUTracer.this.getCounter(context));
            }
        });
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.clearData();
    }

    static {
        CPUTracerInstrument.setFactory(new ProfilerToolFactory<CPUTracer>(){

            @Override
            public CPUTracer create(TruffleInstrument.Env env) {
                return new CPUTracer(env);
            }
        });
    }

    private static class CounterNode
    extends ExecutionEventNode {
        private final Payload payload;

        CounterNode(Payload payload) {
            this.payload = payload;
        }

        protected void onEnter(VirtualFrame frame) {
            if (CompilerDirectives.inInterpreter()) {
                this.payload.countInterpreted++;
            } else {
                this.payload.countCompiled++;
            }
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    public static final class Payload {
        private final StackTraceEntry location;
        private long countInterpreted;
        private long countCompiled;

        Payload(StackTraceEntry location) {
            this.location = location;
        }

        public String getRootName() {
            return this.location.getRootName();
        }

        public Set<Class<?>> getTags() {
            return this.location.getTags();
        }

        public SourceSection getSourceSection() {
            return this.location.getSourceSection();
        }

        public long getCountCompiled() {
            return this.countCompiled;
        }

        public long getCountInterpreted() {
            return this.countInterpreted;
        }

        public long getCount() {
            return this.countCompiled + this.countInterpreted;
        }
    }
}

