/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMI64Vector
extends LLVMVector {
    private final long[] vector;

    public static LLVMI64Vector create(long[] vector) {
        return new LLVMI64Vector(vector);
    }

    private LLVMI64Vector(long[] vector) {
        this.vector = vector;
    }

    public long getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PrimitiveType.I64;
    }

    @Override
    public Object getElement(int index) {
        return index >= 0 && index < this.vector.length ? Long.valueOf(this.vector[index]) : null;
    }
}

