/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibrariesFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ManagedPointerLibraries.class)
final class ManagedPointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);

    private ManagedPointerLibrariesGen() {
    }

    static {
        LibraryExport.register(ManagedPointerLibraries.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports(), new InteropLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object asForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object));
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private LLVMAsForeignLibrary receiverObjectLLVMAsForeignLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.receiverObjectLLVMAsForeignLibrary_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create(castReceiver.object));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || !ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) {
                    return false;
                }
                return this.receiverObjectLLVMAsForeignLibrary_.accepts(((LLVMPointerImpl)receiver).object);
            }

            @Override
            public boolean isForeign(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMAsForeignLibrary isForeignNode__foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                return ManagedPointerLibraries.isForeign(arg0Value, isForeignNode__foreigns__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object asForeign(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMAsForeignLibrary asForeignNode__foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                return ManagedPointerLibraries.asForeign(arg0Value, asForeignNode__foreigns__);
            }
        }
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), LLVMDynAccessSymbolNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.OperationNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (!((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object)).isForeign(arg0Value.object)) {
                    return ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object));
                }
                if (((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object)).isForeign(arg0Value.object)) {
                    return ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object), ManagedPointerLibrariesFactory.ForeignIdentityHashNodeGen.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isExecutable(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.execute(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                ManagedPointerLibraries.toNative(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private LLVMAsForeignLibrary receiverObjectLLVMAsForeignLibrary_;
            @Node.Child
            private InteropLibrary receiverObjectInteropLibrary_;
            @Node.Child
            private LLVMNativeLibrary receiverObjectLLVMNativeLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
            @Node.Child
            private InvokeMemberCachedData invokeMember_cached_cache;
            @Node.Child
            private InteropLibrary invokeMember_resolve_interop_;
            @Node.Child
            private LLVMDynAccessSymbolNode invokeMember_resolve_dynAccessSymbolNode_;
            @Node.Child
            private LLVMAddressEqualsNode.Operation isIdenticalOrUndefined_pointer_equals_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__write_;
            @Node.Child
            private ManagedPointerLibraries.ForeignIdentityHashNode identityHashCode_foreign_hashForeign_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.receiverObjectLLVMAsForeignLibrary_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create(castReceiver.object));
                this.receiverObjectInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(castReceiver.object));
                this.receiverObjectLLVMNativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.create(castReceiver.object));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || !ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) {
                    return false;
                }
                if (!this.receiverObjectLLVMAsForeignLibrary_.accepts(((LLVMPointerImpl)receiver).object)) {
                    return false;
                }
                if (!this.receiverObjectInteropLibrary_.accepts(((LLVMPointerImpl)receiver).object)) {
                    return false;
                }
                return this.receiverObjectLLVMNativeLibrary_.accepts(((LLVMPointerImpl)receiver).object);
            }

            @ExplodeLoop
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        while (s1_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCached_((Object)s1_);
                                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
                            }
                            if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length) {
                                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                                return CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberAndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    LLVMContext context__ = null;
                    if (exclude == 0) {
                        int count1_ = 0;
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null) {
                                if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length && (s1_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                                    TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                    if (lLVMLanguageContextReference__2 == null) {
                                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                    }
                                    context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            Assumption assumption0;
                            LLVMInteropType.Method method__;
                            String methodName__;
                            LLVMInteropType.Clazz clazz__ = CommonPointerLibraries.asClazz(arg0Value);
                            if (CommonPointerLibraries.asClazz(arg0Value) == clazz__ && arg1Value.equals(methodName__ = (method__ = clazz__.findMethodByArguments(arg0Value, arg1Value, arg2Value)).getName()) && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMLanguage.getLanguage().singleContextAssumption)) && count1_ < 3) {
                                s1_ = (InvokeMemberCachedData)super.insert((Node)new InvokeMemberCachedData(this.invokeMember_cached_cache));
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__3 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                                s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                                s1_.clazz_ = clazz__;
                                s1_.method_ = method__;
                                s1_.argCount_ = arg2Value.length;
                                s1_.methodName_ = methodName__;
                                s1_.llvmFunction_ = CommonPointerLibraries.getLLVMFunction(context__, method__, clazz__, arg1Value);
                                s1_.assumption0_ = assumption0;
                                this.invokeMember_cached_cache = s1_;
                                this.state_0_ = state_0 |= 1;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            return object;
                        }
                    }
                    LLVMContext invokeMember_resolve_context__ = null;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__4 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                    this.invokeMember_resolve_interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                    this.invokeMember_resolve_dynAccessSymbolNode_ = (LLVMDynAccessSymbolNode)super.insert((Node)LLVMDynAccessSymbolNodeGen.create());
                    this.exclude_ = exclude |= 1;
                    this.invokeMember_cached_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                InvokeMemberCachedData s1_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.invokeMember_cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeCached_(Object s1_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    InvokeMemberCachedData prev = null;
                    InvokeMemberCachedData cur = this.invokeMember_cached_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.invokeMember_cached_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.invokeMember_cached_cache == null) {
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                    }
                    if ((state_0 & 8) != 0 && Cached.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.isIdenticalOrUndefined_pointer_equals_ = (LLVMAddressEqualsNode.Operation)super.insert((Node)LLVMAddressEqualsNodeGen.OperationNodeGen.create());
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                        return triState;
                    }
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMembers(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.readMemberNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.writeMemberNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0) {
                    return CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    long l = CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.readArrayElementNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.writeArrayElementNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            public int identityHashCode(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC000) != 0) {
                    LLVMAsForeignLibrary identityHashCode_foreign_foreigns__;
                    LLVMAsForeignLibrary identityHashCode_internal_foreigns__;
                    if ((state_0 & 0x4000) != 0 && !(identityHashCode_internal_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_).isForeign(arg0Value.object)) {
                        return ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, identityHashCode_internal_foreigns__);
                    }
                    if ((state_0 & 0x8000) != 0 && (identityHashCode_foreign_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_).isForeign(arg0Value.object)) {
                        return ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, identityHashCode_foreign_foreigns__, this.identityHashCode_foreign_hashForeign_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.identityHashCodeAndSpecialize(arg0Value);
            }

            private int identityHashCodeAndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMAsForeignLibrary identityHashCode_internal_foreigns__ = null;
                    identityHashCode_internal_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                    if (!identityHashCode_internal_foreigns__.isForeign(arg0Value.object)) {
                        this.state_0_ = state_0 |= 0x4000;
                        lock.unlock();
                        hasLock = false;
                        int n = ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, identityHashCode_internal_foreigns__);
                        return n;
                    }
                    LLVMAsForeignLibrary identityHashCode_foreign_foreigns__ = null;
                    identityHashCode_foreign_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                    if (identityHashCode_foreign_foreigns__.isForeign(arg0Value.object)) {
                        this.identityHashCode_foreign_hashForeign_ = (ManagedPointerLibraries.ForeignIdentityHashNode)super.insert((Node)ManagedPointerLibrariesFactory.ForeignIdentityHashNodeGen.create());
                        this.state_0_ = state_0 |= 0x8000;
                        lock.unlock();
                        hasLock = false;
                        int n = ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, identityHashCode_foreign_foreigns__, this.identityHashCode_foreign_hashForeign_);
                        return n;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isNull(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                InteropLibrary isNullNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.isNull(arg0Value, isNullNode__interop__);
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                InteropLibrary isExecutableNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.isExecutable(arg0Value, isExecutableNode__interop__);
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                InteropLibrary executeNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.execute(arg0Value, arg1Value, executeNode__interop__);
            }

            public boolean isPointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMNativeLibrary isPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.isPointer(arg0Value, isPointerNode__natives__);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMNativeLibrary asPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.asPointer(arg0Value, asPointerNode__natives__);
            }

            public void toNative(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                InteropLibrary toNativeNode__interop__ = this.receiverObjectInteropLibrary_;
                ManagedPointerLibraries.toNative(arg0Value, toNativeNode__interop__);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state_0 & 4) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }

            @GeneratedBy(value=CommonPointerLibraries.class)
            private static final class InvokeMemberCachedData
            extends Node {
                @Node.Child
                InvokeMemberCachedData next_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Clazz clazz_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Method method_;
                @CompilerDirectives.CompilationFinal
                int argCount_;
                @CompilerDirectives.CompilationFinal
                String methodName_;
                @CompilerDirectives.CompilationFinal
                LLVMFunction llvmFunction_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                InvokeMemberCachedData(InvokeMemberCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.toNativePointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private LLVMNativeLibrary receiverObjectLLVMNativeLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.receiverObjectLLVMNativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.create(castReceiver.object));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || !ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver))) {
                    return false;
                }
                return this.receiverObjectLLVMNativeLibrary_.accepts(((LLVMPointerImpl)receiver).object);
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMNativeLibrary isPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.isPointer(arg0Value, isPointerNode__natives__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMNativeLibrary asPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.asPointer(arg0Value, asPointerNode__natives__);
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && ManagedPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(arg0Value_))) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                LLVMNativeLibrary toNativePointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.toNativePointer(arg0Value, toNativePointerNode__natives__);
            }
        }
    }
}

