/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.NativePointerLibraries;
import java.util.Objects;

@CompilerDirectives.ValueType
@ExportLibrary(value=DynamicDispatchLibrary.class)
final class LLVMPointerImpl
implements LLVMManagedPointer,
LLVMNativePointer {
    static final LLVMPointerImpl NULL = new LLVMPointerImpl(null, 0L, null);
    final Object object;
    private final long offset;
    private final LLVMInteropType exportType;

    LLVMPointerImpl(Object object, long offset, LLVMInteropType exportType) {
        this.object = object;
        this.offset = offset;
        this.exportType = exportType;
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        CompilerAsserts.neverPartOfCompilation();
        if (!(obj instanceof LLVMPointerImpl)) {
            return false;
        }
        LLVMPointerImpl other = (LLVMPointerImpl)obj;
        return Objects.equals(this.object, other.object) && this.offset == other.offset;
    }

    @Override
    public boolean isSame(LLVMPointer o) {
        LLVMPointerImpl other = (LLVMPointerImpl)o;
        return this.object == other.object && this.offset == other.offset;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.object);
        result = 31 * result + Long.hashCode(this.offset);
        return result;
    }

    boolean isNative() {
        return this.object == null;
    }

    @Override
    public long asNative() {
        assert (this.isNative());
        return this.offset;
    }

    boolean isManaged() {
        return this.object != null;
    }

    @Override
    public Object getObject() {
        assert (this.isManaged());
        return this.object;
    }

    @Override
    public long getOffset() {
        assert (this.isManaged());
        return this.offset;
    }

    @Override
    public boolean isNull() {
        return this.object == null && this.offset == 0L;
    }

    @Override
    public LLVMInteropType getExportType() {
        return this.exportType;
    }

    @Override
    public LLVMPointerImpl copy() {
        if (CompilerDirectives.inCompiledCode()) {
            return new LLVMPointerImpl(this.object, this.offset, this.exportType);
        }
        return this;
    }

    @Override
    public LLVMPointerImpl increment(long incr) {
        return new LLVMPointerImpl(this.object, this.offset + incr, null);
    }

    @Override
    public LLVMPointerImpl export(LLVMInteropType newType) {
        return new LLVMPointerImpl(this.object, this.offset, newType);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.isNative()) {
            return String.format("0x%x", this.asNative());
        }
        return String.format("%s+0x%x", this.getObject().getClass().getSimpleName(), this.getOffset());
    }

    @ExportMessage
    Class<?> dispatch(@Cached ConditionProfile isNativeProfile) {
        if (isNativeProfile.profile(this.isNative())) {
            return NativePointerLibraries.class;
        }
        assert (this.isManaged());
        return ManagedPointerLibraries.class;
    }
}

