/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=CommonPointerLibraries.class)
final class CommonPointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private CommonPointerLibrariesGen() {
    }

    static {
        LibraryExport.register(CommonPointerLibraries.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedWriteLibraryExports(), new LLVMManagedReadLibraryExports(), new ReferenceLibraryExports()});
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class ReferenceLibraryExports
    extends LibraryExport<ReferenceLibrary> {
        private ReferenceLibraryExports() {
            super(ReferenceLibrary.class, LLVMPointerImpl.class, false);
        }

        protected ReferenceLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ReferenceLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Uncached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.OperationNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private LLVMAddressEqualsNode.Operation native_equals_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                    }
                    if ((state_0 & 2) != 0 && Cached.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.native_equals_ = (LLVMAddressEqualsNode.Operation)super.insert((Node)LLVMAddressEqualsNodeGen.OperationNodeGen.create());
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                        return bl;
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            private static boolean fallbackGuard_(int state_0, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isReadable((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI8((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI16((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI32((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readFloat((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readI64(Object receiver, long offset) throws UnexpectedResultException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI64((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readDouble((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readPointer((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readGenericI64((LLVMPointerImpl)receiver, offset);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isReadable((LLVMPointerImpl)receiver);
            }

            @Override
            public byte readI8(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI8((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public short readI16(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI16((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public int readI32(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI32((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public float readFloat(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readFloat((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public long readI64(Object receiver, long offset) throws UnexpectedResultException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI64((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public double readDouble(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readDouble((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public LLVMPointer readPointer(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readPointer((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public Object readGenericI64(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readGenericI64((LLVMPointerImpl)receiver, offset);
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isWritable((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object receiver, long offset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI8((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object receiver, long offset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI16((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object receiver, long offset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI32((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object receiver, long offset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeFloat((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object receiver, long offset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object receiver, long offset, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeGenericI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object receiver, long offset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeDouble((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writePointer(Object receiver, long offset, LLVMPointer value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writePointer((LLVMPointerImpl)receiver, offset, value);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isWritable((LLVMPointerImpl)receiver);
            }

            @Override
            public void writeI8(Object receiver, long offset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI8((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI16(Object receiver, long offset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI16((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI32(Object receiver, long offset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI32((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeFloat(Object receiver, long offset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeFloat((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI64(Object receiver, long offset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeGenericI64(Object receiver, long offset, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeGenericI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeDouble(Object receiver, long offset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeDouble((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writePointer(Object receiver, long offset, LLVMPointer value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writePointer((LLVMPointerImpl)receiver, offset, value);
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), LLVMDynAccessSymbolNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.OperationNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
            @Node.Child
            private InvokeMemberCachedData invokeMember_cached_cache;
            @Node.Child
            private InteropLibrary invokeMember_resolve_interop_;
            @Node.Child
            private LLVMDynAccessSymbolNode invokeMember_resolve_dynAccessSymbolNode_;
            @Node.Child
            private LLVMAddressEqualsNode.Operation isIdenticalOrUndefined_pointer_equals_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__write_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && CommonPointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @ExplodeLoop
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        while (s1_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCached_((Object)s1_);
                                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
                            }
                            if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length) {
                                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                                return CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberAndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    LLVMContext context__ = null;
                    if (exclude == 0) {
                        int count1_ = 0;
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null) {
                                if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length && (s1_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                                    TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                    if (lLVMLanguageContextReference__2 == null) {
                                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                    }
                                    context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            Assumption assumption0;
                            LLVMInteropType.Method method__;
                            String methodName__;
                            LLVMInteropType.Clazz clazz__ = CommonPointerLibraries.asClazz(arg0Value);
                            if (CommonPointerLibraries.asClazz(arg0Value) == clazz__ && arg1Value.equals(methodName__ = (method__ = clazz__.findMethodByArguments(arg0Value, arg1Value, arg2Value)).getName()) && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMLanguage.getLanguage().singleContextAssumption)) && count1_ < 3) {
                                s1_ = (InvokeMemberCachedData)super.insert((Node)new InvokeMemberCachedData(this.invokeMember_cached_cache));
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__3 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                                s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                                s1_.clazz_ = clazz__;
                                s1_.method_ = method__;
                                s1_.argCount_ = arg2Value.length;
                                s1_.methodName_ = methodName__;
                                s1_.llvmFunction_ = CommonPointerLibraries.getLLVMFunction(context__, method__, clazz__, arg1Value);
                                s1_.assumption0_ = assumption0;
                                this.invokeMember_cached_cache = s1_;
                                this.state_0_ = state_0 |= 1;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            return object;
                        }
                    }
                    LLVMContext invokeMember_resolve_context__ = null;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__4 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                    this.invokeMember_resolve_interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                    this.invokeMember_resolve_dynAccessSymbolNode_ = (LLVMDynAccessSymbolNode)super.insert((Node)LLVMDynAccessSymbolNodeGen.create());
                    this.exclude_ = exclude |= 1;
                    this.invokeMember_cached_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                InvokeMemberCachedData s1_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.invokeMember_cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeCached_(Object s1_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    InvokeMemberCachedData prev = null;
                    InvokeMemberCachedData cur = this.invokeMember_cached_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.invokeMember_cached_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.invokeMember_cached_cache == null) {
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                    }
                    if ((state_0 & 8) != 0 && Cached.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.isIdenticalOrUndefined_pointer_equals_ = (LLVMAddressEqualsNode.Operation)super.insert((Node)LLVMAddressEqualsNodeGen.OperationNodeGen.create());
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                        return triState;
                    }
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.readMemberNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.writeMemberNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0) {
                    return CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    long l = CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.readArrayElementNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.writeArrayElementNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state_0 & 4) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }

            @GeneratedBy(value=CommonPointerLibraries.class)
            private static final class InvokeMemberCachedData
            extends Node {
                @Node.Child
                InvokeMemberCachedData next_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Clazz clazz_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Method method_;
                @CompilerDirectives.CompilationFinal
                int argCount_;
                @CompilerDirectives.CompilationFinal
                String methodName_;
                @CompilerDirectives.CompilationFinal
                LLVMFunction llvmFunction_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                InvokeMemberCachedData(InvokeMemberCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

