/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMWriteNode.class)
public final class LLVMWriteNodeFactory {

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteVectorNode.class)
    public static final class LLVMWriteVectorNodeGen
    extends LLVMWriteNode.LLVMWriteVectorNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteVectorNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof LLVMVector) {
                LLVMVector valueNodeValue_ = (LLVMVector)valueNodeValue;
                this.writeVector(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (state_0 != 0 && valueNodeValue_ instanceof LLVMVector) {
                LLVMVector valueNodeValue__ = (LLVMVector)valueNodeValue_;
                this.writeVector(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof LLVMVector) {
                LLVMVector valueNodeValue_ = (LLVMVector)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeVector(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteVectorNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteVectorNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWritePointerNode.class)
    public static final class LLVMWritePointerNodeGen
    extends LLVMWriteNode.LLVMWritePointerNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWritePointerNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.writeLong(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMWritePointerNodeGen.fallbackGuard_(state_0, valueNodeValue)) {
                this.writeObject(frameValue, valueNodeValue);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long0(state_0, frameValue);
                return;
            }
            this.execute_generic1(state_0, frameValue);
        }

        private void execute_long0(int state_0, VirtualFrame frameValue) {
            long valueNodeValue_;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.writeLong(frameValue, valueNodeValue_);
        }

        private void execute_generic1(int state_0, VirtualFrame frameValue) {
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && valueNodeValue_ instanceof Long) {
                long valueNodeValue__ = (Long)valueNodeValue_;
                this.writeLong(frameValue, valueNodeValue__);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMWritePointerNodeGen.fallbackGuard_(state_0, valueNodeValue_)) {
                this.writeObject(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeLong(frameValue, valueNodeValue_);
                return;
            }
            this.state_0_ = state_0 |= 2;
            this.writeObject(frameValue, valueNodeValue);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state_0, Object valueNodeValue) {
            return (state_0 & 1) != 0 || !(valueNodeValue instanceof Long);
        }

        public static LLVMWriteNode.LLVMWritePointerNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWritePointerNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWrite80BitFloatingNode.class)
    public static final class LLVMWrite80BitFloatingNodeGen
    extends LLVMWriteNode.LLVMWrite80BitFloatingNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWrite80BitFloatingNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue_ = (LLVM80BitFloat)valueNodeValue;
                this.write80BitFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if (state_0 != 0 && valueNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue__ = (LLVM80BitFloat)valueNodeValue_;
                this.write80BitFloat(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat valueNodeValue_ = (LLVM80BitFloat)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.write80BitFloat(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWrite80BitFloatingNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWrite80BitFloatingNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteDoubleNode.class)
    public static final class LLVMWriteDoubleNodeGen
    extends LLVMWriteNode.LLVMWriteDoubleNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteDoubleNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            double valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeDouble(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteDoubleNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteDoubleNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteFloatNode.class)
    public static final class LLVMWriteFloatNodeGen
    extends LLVMWriteNode.LLVMWriteFloatNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteFloatNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Float) {
                float valueNodeValue_ = ((Float)valueNodeValue).floatValue();
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            float valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, Float.valueOf(valueNodeValue_));
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Float) {
                float valueNodeValue_ = ((Float)valueNodeValue).floatValue();
                this.state_0_ = state_0 |= 1;
                this.writeFloat(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteFloatNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteFloatNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteIVarBitNode.class)
    public static final class LLVMWriteIVarBitNodeGen
    extends LLVMWriteNode.LLVMWriteIVarBitNode {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteIVarBitNodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE) >>> 1, valueNodeValue)) {
                LLVMIVarBit valueNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE) >>> 1, valueNodeValue);
                this.writeIVarBit(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE) >>> 1, valueNodeValue_)) {
                LLVMIVarBit valueNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE) >>> 1, valueNodeValue_);
                this.writeIVarBit(frameValue, valueNodeValue__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(valueNodeValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit valueNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, valueNodeValue);
                state_0 |= lLVMIVarBitCast0 << 1;
                this.state_0_ = state_0 |= 1;
                this.writeIVarBit(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteIVarBitNode create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteIVarBitNodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI64Node.class)
    public static final class LLVMWriteI64NodeGen
    extends LLVMWriteNode.LLVMWriteI64Node {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private LLVMWriteI64NodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.writeI64(frameValue, valueNodeValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writePointer(frameValue, valueNodeValue);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long0(state_0, frameValue);
                return;
            }
            this.execute_generic1(state_0, frameValue);
        }

        private void execute_long0(int state_0, VirtualFrame frameValue) {
            long valueNodeValue_;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.writeI64(frameValue, valueNodeValue_);
        }

        private void execute_generic1(int state_0, VirtualFrame frameValue) {
            Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && valueNodeValue_ instanceof Long) {
                long valueNodeValue__ = (Long)valueNodeValue_;
                this.writeI64(frameValue, valueNodeValue__);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.writePointer(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0 && valueNodeValue instanceof Long) {
                    long valueNodeValue_ = (Long)valueNodeValue;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.writeI64(frameValue, valueNodeValue_);
                    return;
                }
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                this.writePointer(frameValue, valueNodeValue);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteI64Node create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI64NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI32Node.class)
    public static final class LLVMWriteI32NodeGen
    extends LLVMWriteNode.LLVMWriteI32Node {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI32NodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Integer) {
                int valueNodeValue_ = (Integer)valueNodeValue;
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Integer) {
                int valueNodeValue_ = (Integer)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeI32(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteI32Node create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI32NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI16Node.class)
    public static final class LLVMWriteI16NodeGen
    extends LLVMWriteNode.LLVMWriteI16Node {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI16NodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Short) {
                short valueNodeValue_ = (Short)valueNodeValue;
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Short) {
                short valueNodeValue_ = (Short)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeI16(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteI16Node create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI16NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI8Node.class)
    public static final class LLVMWriteI8NodeGen
    extends LLVMWriteNode.LLVMWriteI8Node {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI8NodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Byte) {
                byte valueNodeValue_ = (Byte)valueNodeValue;
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Byte) {
                byte valueNodeValue_ = (Byte)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeI8(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteI8Node create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI8NodeGen(slot, valueNode);
        }
    }

    @GeneratedBy(value=LLVMWriteNode.LLVMWriteI1Node.class)
    public static final class LLVMWriteI1NodeGen
    extends LLVMWriteNode.LLVMWriteI1Node {
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMWriteI1NodeGen(FrameSlot slot, LLVMExpressionNode valueNode) {
            super(slot);
            this.valueNode_ = valueNode;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue);
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            boolean valueNodeValue_;
            int state_0 = this.state_0_;
            try {
                valueNodeValue_ = this.valueNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state_0 != 0) {
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueNodeValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                this.writeI1(frameValue, valueNodeValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMWriteNode.LLVMWriteI1Node create(FrameSlot slot, LLVMExpressionNode valueNode) {
            return new LLVMWriteI1NodeGen(slot, valueNode);
        }
    }
}

