/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAccessSymbolNode
extends LLVMExpressionNode {
    protected final LLVMSymbol symbol;
    @CompilerDirectives.CompilationFinal
    private LLVMStack.LLVMStackAccess stackAccess;

    LLVMAccessSymbolNode(LLVMSymbol symbol) {
        this.symbol = LLVMAlias.resolveAlias(symbol);
    }

    @Override
    public abstract LLVMPointer executeGeneric(VirtualFrame var1);

    @Override
    public String toString() {
        return this.getShortString("symbol");
    }

    public LLVMSymbol getSymbol() {
        return this.symbol;
    }

    private LLVMPointer checkNull(LLVMPointer result) {
        if (result == null) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMLinkerException(this, String.format("External %s %s cannot be found.", this.symbol.getKind(), this.symbol.getName()));
        }
        return result;
    }

    @Specialization(assumptions={"singleContextAssumption()"})
    public LLVMPointer accessSingleContext(@CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        return this.checkNull(context.getSymbol(this.symbol));
    }

    @Specialization
    public LLVMPointer accessMultiContext(VirtualFrame frame) {
        if (this.stackAccess == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackAccess = ((LLVMRootNode)this.getRootNode()).getStackAccess();
        }
        return this.checkNull(this.stackAccess.executeGetStack(frame).getContext().getSymbol(this.symbol));
    }
}

