/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.UnaryOperation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeChild(value="operandNode")
public abstract class LLVMUnaryNode
extends LLVMExpressionNode {
    final LLVMUnaryOp op;
    private static final LLVMFPUnaryOp NEG = new LLVMFPUnaryOp(){

        @Override
        float doFloat(float operand) {
            return -operand;
        }

        @Override
        double doDouble(double operand) {
            return -operand;
        }

        @Override
        LLVM80BitFloat doFP80(LLVM80BitFloat operand) {
            return operand.negate();
        }

        @Override
        boolean doBoolean(boolean operand) {
            return !operand;
        }

        @Override
        byte doByte(byte operand) {
            return -operand;
        }

        @Override
        short doShort(short operand) {
            return -operand;
        }

        @Override
        int doInt(int operand) {
            return -operand;
        }

        @Override
        long doLong(long operand) {
            return -operand;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit operand) {
            return LLVMIVarBit.fromInt(operand.getBitSize(), 0).sub(operand);
        }
    };

    public abstract Object executeWithTarget(Object var1);

    protected LLVMUnaryNode(UnaryOperation op) {
        switch (op) {
            case NEG: {
                this.op = NEG;
                break;
            }
            default: {
                throw new AssertionError((Object)op.name());
            }
        }
    }

    public static abstract class LLVMFP80UnaryNode
    extends LLVMFloatingUnaryNode {
        LLVMFP80UnaryNode(UnaryOperation op) {
            super(op);
        }

        @Specialization
        LLVM80BitFloat do80BitFloat(LLVM80BitFloat operand) {
            return this.fpOp().doFP80(operand);
        }
    }

    public static abstract class LLVMDoubleUnaryNode
    extends LLVMFloatingUnaryNode {
        LLVMDoubleUnaryNode(UnaryOperation op) {
            super(op);
        }

        @Specialization
        double doDouble(double operand) {
            return this.fpOp().doDouble(operand);
        }
    }

    public static abstract class LLVMFloatUnaryNode
    extends LLVMFloatingUnaryNode {
        LLVMFloatUnaryNode(UnaryOperation op) {
            super(op);
        }

        @Specialization
        float doFloat(float operand) {
            return this.fpOp().doFloat(operand);
        }
    }

    public static abstract class LLVMFloatingUnaryNode
    extends LLVMUnaryNode {
        LLVMFloatingUnaryNode(UnaryOperation op) {
            super(op);
            assert (this.op instanceof LLVMFPUnaryOp);
        }

        LLVMFPUnaryOp fpOp() {
            return (LLVMFPUnaryOp)this.op;
        }
    }

    private static abstract class LLVMFPUnaryOp
    extends LLVMUnaryOp {
        private LLVMFPUnaryOp() {
        }

        abstract float doFloat(float var1);

        abstract double doDouble(double var1);

        abstract LLVM80BitFloat doFP80(LLVM80BitFloat var1);
    }

    private static abstract class LLVMUnaryOp {
        private LLVMUnaryOp() {
        }

        abstract boolean doBoolean(boolean var1);

        abstract byte doByte(byte var1);

        abstract short doShort(short var1);

        abstract int doInt(int var1);

        abstract long doLong(long var1);

        abstract LLVMIVarBit doVarBit(LLVMIVarBit var1);
    }
}

